/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.ImageUtils;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.DIBitmap;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilder;
import com.jniwrapper.win32.system.LocalMemoryBlock;
import com.jniwrapper.win32.system.MemoryAllocationAttributes;
import com.jniwrapper.win32.ui.User32;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class DDBitmap
extends Bitmap {
    private static final String FUNCTION_CREATE_COMPATIBLE_BITMAP = "CreateCompatibleBitmap";
    private DC _dc;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    public DDBitmap() {
        this._dc = new WindowDC(null);
        this.setSize(0, 0);
    }

    public DDBitmap(long value) {
        super(value);
        this._dc = new WindowDC(null);
        this.setSize(0, 0);
    }

    public DDBitmap(int width, int height) {
        this(new WindowDC(null), width, height);
    }

    public DDBitmap(DC dc, int width, int height) {
        this._dc = dc;
        this.setSize(width, height);
        Function function = Gdi32.get(FUNCTION_CREATE_COMPATIBLE_BITMAP);
        function.invoke(this, this._dc, new Int(width), new Int(height));
    }

    public DDBitmap(DIBitmap diBitmap) {
        this((DC)new WindowDC(null), diBitmap);
    }

    public DDBitmap(DC dc, DIBitmap diBitmap) {
        this(dc, diBitmap.getWidth(), diBitmap.getHeight());
        PrimitiveArray bits = diBitmap.getDIBytes();
        Function function = Gdi32.getInstance().getFunction("CreateDIBitmap");
        function.invoke((Parameter)this, new Parameter[]{dc, new Pointer(diBitmap.getDIBSection().getBitmapInfoHeader()), new UInt32(4L), new Pointer(bits), new Pointer(diBitmap.getBitmapInfo()), new UInt(0L)});
    }

    public DDBitmap(String fileName) {
        this((DC)new WindowDC(null), fileName);
    }

    public DDBitmap(DC dc, String fileName) {
        this._dc = dc;
        this.loadFromFile(fileName);
    }

    public DDBitmap(Image image) {
        this((DC)new WindowDC(null), image);
    }

    public DDBitmap(DC dc, Image image) {
        this(dc, image.getWidth(null), image.getHeight(null));
        BufferedImage bufferedImage = ImageUtils.createBufferedImage(image);
        this.setBitsForBitmap(bufferedImage);
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setSize((int)bitmapInfo.getBitmapInfoHeader().getWidth(), (int)bitmapInfo.getBitmapInfoHeader().getHeight());
    }

    public DDBitmap(Bitmap.PredefinedBitmap predefinedBitmap) {
        this((DC)new WindowDC(null), predefinedBitmap);
    }

    public DDBitmap(DC dc, Bitmap.PredefinedBitmap predefinedBitmap) {
        this._dc = dc;
        this.loadPredefinedBitmap(predefinedBitmap);
    }

    public void loadFromFile(String fileName) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle result = new Handle();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{new Pointer(null, true), new Str(fileName), new UInt(GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(32848L)});
        if (result.isNull()) {
            throw new LastErrorException(errorCode, "Failed to load resource.", true);
        }
        this.setValue(result.getValue());
        this.setSize((int)this.getBitmapStructure().getBitmapWidth(), (int)this.getBitmapStructure().getBitmapHeight());
    }

    public void loadPredefinedBitmap(Bitmap.PredefinedBitmap predefinedBitmap) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle result = new Handle();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{new Pointer(null, true), new UInt32(predefinedBitmap.getValue()), new UInt(GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(32832L)});
        if (result.isNull()) {
            throw new LastErrorException(errorCode, "Failed to load resource.", true);
        }
        this.setValue(result.getValue());
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setSize((int)bitmapInfo.getBitmapInfoHeader().getWidth(), (int)bitmapInfo.getBitmapInfoHeader().getHeight());
    }

    private void setBitsForBitmap(BufferedImage bufferedImage) {
        BitmapBuilder builder = _builderFactory.createBuilder(bufferedImage);
        BitmapInfo bitmapInfo = builder.getBitmapInfo();
        DIBitmap dibitmap = new DIBitmap();
        this.createDIBSection(dibitmap, new Pointer((Parameter)new Pointer(builder.getBitmapData())), bitmapInfo);
        builder.setBitmapColors();
        PrimitiveArray pa = builder.getBitmapData();
        dibitmap.getDIBits(this._dc, 0, this.getHeight(), new Pointer(pa), bitmapInfo, 0);
        this.setDIBits(this._dc, 0, this.getHeight(), new Pointer(pa), bitmapInfo, 0);
        Image transparentMaskImage = builder.getTransparentMask();
        if (transparentMaskImage != null) {
            this.setTransparentMask(transparentMaskImage);
        }
    }

    public BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = new BitmapInfo();
        this.getDIBits(this._dc, 0, 0, new Pointer(null, true), bitmapInfo, 0);
        bitmapInfo.getBitmapInfoHeader().setCompression(Bitmap.Compression.RGB);
        return bitmapInfo;
    }

    public BitmapStructure getBitmapStructure() {
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(this, bitmapStructure);
        return bitmapStructure;
    }

    public BitmapInfoHeader getBitmapInfoHeader() {
        return this.getBitmapInfo().getBitmapInfoHeader();
    }

    public DIBitmap toDIBitmap() {
        BitmapInfoHeader bitmapInfo = this.getBitmapInfoHeader();
        int height = (int)bitmapInfo.getHeight();
        int width = (int)bitmapInfo.getWidth();
        int bitscount = (int)bitmapInfo.getSizeImage();
        PrimitiveArray bits = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = DDBitmap.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, bitscount);
        Pointer pbits = new Pointer(bits);
        DIBitmap result = new DIBitmap(width, height);
        this.createDIBSection(result, this._dc, this.getBitmapInfo(), 0, new Pointer((Parameter)pbits), new Handle(), 0);
        this.getDIBits(this._dc, 0, height, pbits, this.getBitmapInfo(), 0);
        return result;
    }

    public PrimitiveArray getDIBytes() {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        int height = this.getHeight();
        int width = this.getWidth();
        int bitPerPixel = this.getBitCount();
        Pointer NULL = new Pointer(null, true);
        this.getDIBits(this._dc, 0, height, NULL, bitmapInfo, 0);
        int bytesCount = height * width * bitPerPixel / 8;
        byte[] buffer = new byte[bytesCount];
        PrimitiveArray bits = new PrimitiveArray(buffer);
        this.getDIBits(this._dc, 0, height, new Pointer(bits), bitmapInfo, 0);
        return bits;
    }

    public byte[] getBytes() {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        int height = this.getHeight();
        int width = this.getWidth();
        int bitPerPixel = this.getBitCount();
        Pointer NULL = new Pointer(null, true);
        this.getDIBits(this._dc, 0, height, NULL, bitmapInfo, 0);
        int bytesCount = height * width * bitPerPixel / 8;
        LocalMemoryBlock memoryBuffer = new LocalMemoryBlock(bytesCount, MemoryAllocationAttributes.FIXED);
        this.getDIBits(this._dc, 0, height, memoryBuffer, bitmapInfo, 0);
        MemoryBuffer bitsBuffer = DataBufferFactory.getInstance().createExternMemoryBuffer(memoryBuffer.getValue(), bytesCount);
        byte[] result = bitsBuffer.readByteArray(0, bytesCount);
        memoryBuffer.free();
        return result;
    }

    public void setDIBytes(PrimitiveArray bytes) {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        PrimitiveArray bits = bytes;
        this.setDIBits(this._dc, 0, this.getHeight(), new Pointer(bits), bitmapInfo, 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

