/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.mapi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.ULongInt;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.mapi.MailContact;
import com.jniwrapper.win32.mapi.MapiException;
import com.jniwrapper.win32.mapi.MapiFileDesc;
import com.jniwrapper.win32.mapi.MapiMessageStructure;
import com.jniwrapper.win32.mapi.MapiRecipDesc;
import com.jniwrapper.win32.system.Kernel32;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class MapiMessage {
    private static final Library LIB = new Library("mapi32");
    private static final int MAPI_LOGON_UI = 1;
    private static final int MAPI_NEW_SESSION = 2;
    private static final int MAPI_DIALOG = 8;
    private MapiMessageStructure _mapiMessageStructure = new MapiMessageStructure();
    private List _receivers = new LinkedList();
    private List _files = new LinkedList();
    private boolean _logonUI;

    public MapiMessage() {
    }

    public MapiMessage(MailContact to) {
        this.addRecipient(to);
    }

    public MapiMessage(MailContact from, MailContact to) {
        this(to);
        this.setSender(from);
    }

    public MapiMessage(List to) {
        this.addRecipients(to);
    }

    public MapiMessage(MailContact from, List to) {
        this(to);
        this.setSender(from);
    }

    public boolean send(boolean showDialog) throws MapiException {
        long options;
        Function mapiSendMail = LIB.getFunction("MAPISendMail");
        UInt result = new UInt();
        this.fillStructure();
        long l2 = options = showDialog ? 8L : 2L;
        if (this._logonUI) {
            options |= 1L;
        }
        String currentDirectory = Kernel32.getCurrentDirectory();
        mapiSendMail.invoke((Parameter)result, new Parameter[]{new Handle(), new ULongInt(), new Pointer(this._mapiMessageStructure), new Int(options), new ULongInt()});
        Kernel32.setCurrentDirectory(currentDirectory);
        int resultCode = (int)result.getValue();
        if (resultCode != 0 && resultCode != 1) {
            throw new MapiException(resultCode);
        }
        return resultCode == 0;
    }

    private void fillStructure() {
        LinkedList<MapiRecipDesc> mapiRecipDesc = new LinkedList<MapiRecipDesc>();
        for (int i2 = 0; i2 < this._receivers.size(); ++i2) {
            MailContact mailContact = (MailContact)this._receivers.get(i2);
            mapiRecipDesc.add(mailContact.getStructure());
        }
        this._mapiMessageStructure.setRecips(mapiRecipDesc);
        LinkedList<MapiFileDesc> mapiFileDesc = new LinkedList<MapiFileDesc>();
        for (int i3 = 0; i3 < this._files.size(); ++i3) {
            File file = (File)this._files.get(i3);
            mapiFileDesc.add(new MapiFileDesc(file));
        }
        this._mapiMessageStructure.setFiles(mapiFileDesc);
    }

    public String getSubject() {
        return this._mapiMessageStructure.getSubject();
    }

    public void setSubject(String subject) {
        this._mapiMessageStructure.setSubject(subject == null ? "" : subject);
    }

    public String getText() {
        return this._mapiMessageStructure.getText();
    }

    public void setText(String text) {
        this._mapiMessageStructure.setText(text == null ? "" : text);
    }

    public List getRecipients() {
        return this._receivers;
    }

    public void addRecipients(List recipients) {
        for (int i2 = 0; i2 < recipients.size(); ++i2) {
            MailContact mailContact = (MailContact)recipients.get(i2);
            this._receivers.add(mailContact);
        }
    }

    public void addRecipient(MailContact recipient) {
        if (recipient.getType().equals(MailContact.Type.SENDER)) {
            throw new IllegalArgumentException("The specified mail receiver is of the SENDER type.");
        }
        this._receivers.add(recipient);
    }

    public boolean removeRecipient(MailContact recipient) {
        return this._receivers.remove(recipient);
    }

    public MailContact getSender() {
        return new MailContact(this._mapiMessageStructure.getOriginator());
    }

    public void setSender(MailContact sender) {
        if (!sender.getType().equals(MailContact.Type.SENDER)) {
            throw new IllegalArgumentException("The specified mail sender is not of the SENDER type.");
        }
        this._mapiMessageStructure.setOriginator(sender.getStructure());
    }

    public List getAttachedFiles() {
        return this._mapiMessageStructure.getFiles();
    }

    public void attachFiles(List files) {
        for (int i2 = 0; i2 < files.size(); ++i2) {
            File file = (File)files.get(i2);
            this._files.add(file);
        }
    }

    public void attachFile(File file) {
        this._files.add(file);
    }

    public boolean removeAttachedFile(File file) {
        return this._files.remove(file);
    }

    public boolean isLogonUI() {
        return this._logonUI;
    }

    public void setLogonUI(boolean logonUI) {
        this._logonUI = logonUI;
    }

    static {
        LIB.load();
    }
}

