/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.Bool;
import com.jniwrapper.ExternalStringArray;
import com.jniwrapper.Function;
import com.jniwrapper.NativeResource;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.StringArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.EnvironmentVariables;
import com.jniwrapper.win32.system.Kernel32;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public class ProcessVariables
extends Handle
implements EnvironmentVariables {
    private static final Logger LOG = Logger.getInstance(class$com$jniwrapper$win32$process$ProcessVariables == null ? (class$com$jniwrapper$win32$process$ProcessVariables = ProcessVariables.class$("com.jniwrapper.win32.process.ProcessVariables")) : class$com$jniwrapper$win32$process$ProcessVariables);
    private static final FunctionName FUNCTION_GetEnvironmentStrings = new FunctionName("GetEnvironmentStrings", false);
    private static final FunctionName FUNCTION_GetEnvironmentVariable = new FunctionName("GetEnvironmentVariable");
    private static final FunctionName FUNCTION_SetEnvironmentVariable = new FunctionName("SetEnvironmentVariable");
    private static final FunctionName FUNCTION_FreeEnvironmentStrings = new FunctionName("FreeEnvironmentStrings");
    private Pointer _stringArrayPtr;
    static /* synthetic */ Class class$com$jniwrapper$win32$process$ProcessVariables;

    public ProcessVariables() {
        this.readStrings();
        this.registerResource();
    }

    public ProcessVariables(String[] variables) {
        StringArray stringArray = new StringArray(variables);
        this._stringArrayPtr = new Pointer(stringArray);
        this._stringArrayPtr.castTo(this);
        this.registerResource();
    }

    protected void registerResource() {
        NativeResourceCollector.getInstance().addNativeResource(this, new EnvironmentVariablesResource(this.getValue()));
    }

    private void readStrings() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetEnvironmentStrings.toString());
        function.invoke(this);
    }

    public String[] getStrings() {
        ExternalStringArray stringArray = new ExternalStringArray(this);
        return stringArray.getStrings();
    }

    public Map toMap() {
        this.readStrings();
        HashMap<String, String> result = new HashMap<String, String>();
        String[] values = this.getStrings();
        for (int i2 = 0; i2 < values.length; ++i2) {
            StringTokenizer tokenizer = new StringTokenizer(values[i2], "=");
            result.put(tokenizer.nextToken(), tokenizer.nextToken());
        }
        return result;
    }

    public String getValue(String variable) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetEnvironmentVariable.toString());
        Str varName = new Str(variable);
        UInt32 length = new UInt32();
        Str result = new Str();
        long errorCode = function.invoke(length, varName, new Pointer.OutOnly(result), new UInt32(result.getMaxLength()));
        if (length.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
        int requiredLength = (int)length.getValue();
        if (requiredLength > result.getMaxLength()) {
            result = new Str(requiredLength);
            errorCode = function.invoke(length, varName, new Pointer.OutOnly(result), new UInt32(requiredLength));
        }
        if (length.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
        return result.getValue();
    }

    public void setValue(String variable, String value) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetEnvironmentVariable.toString());
        Bool functionResult = new Bool();
        long errorCode = function.invoke(functionResult, new Str(variable), new Str(value));
        if (!functionResult.getValue()) {
            throw new LastErrorException(errorCode);
        }
    }

    public boolean contains(String variable) {
        return this.toMap().containsKey(variable);
    }

    public String[] getVariableNames() {
        Map map = this.toMap();
        LinkedList names = new LinkedList();
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            names.add(i2.next());
        }
        return names.toArray(new String[names.size()]);
    }

    public void freeEnvironmentStrings() {
        try {
            ProcessVariables.freeEnvironmentStrings(this);
        }
        catch (Throwable e2) {
            LOG.error("", e2);
        }
    }

    private static void freeEnvironmentStrings(Handle environmentBlock) {
        if (!environmentBlock.isNull()) {
            Function function = Kernel32.getInstance().getFunction(FUNCTION_FreeEnvironmentStrings.toString());
            Bool functionResult = new Bool();
            long errorCode = function.invoke((Parameter)functionResult, environmentBlock);
            if (!functionResult.getValue()) {
                throw new LastErrorException(errorCode);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class EnvironmentVariablesResource
    implements NativeResource {
        private long _handle;

        protected EnvironmentVariablesResource(long handle) {
            this._handle = handle;
        }

        public void release() throws Throwable {
            ProcessVariables.freeEnvironmentStrings(new Handle(this._handle));
        }
    }
}

