/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Handle;

public class StartupInfo
extends Structure {
    private UInt32 cb = new UInt32();
    private Pointer.Void reserved = new Pointer.Void();
    private Str desktop = new Str();
    private Str title = new Str();
    private UInt32 x = new UInt32();
    private UInt32 y = new UInt32();
    private UInt32 xSize = new UInt32();
    private UInt32 ySize = new UInt32();
    private UInt32 xCountChars = new UInt32();
    private UInt32 yCountChars = new UInt32();
    private UInt32 fillAttribute = new UInt32();
    private UInt32 flags = new UInt32();
    private UInt16 showWindow = new UInt16();
    private UInt16 cbReserved2 = new UInt16();
    private Pointer.Void lpReserved2 = new Pointer.Void();
    private Handle stdInput = new Handle();
    private Handle stdOutput = new Handle();
    private Handle stdError = new Handle();

    public StartupInfo(Options options) {
        this();
        this.flags.setValue(options.getFlags());
    }

    public StartupInfo() {
        this.init(new Parameter[]{this.cb, this.reserved, new Pointer(this.desktop), new Pointer(this.title), this.x, this.y, this.xSize, this.ySize, this.xCountChars, this.yCountChars, this.fillAttribute, this.flags, this.showWindow, this.cbReserved2, this.lpReserved2, this.stdInput, this.stdOutput, this.stdError}, (short)8);
        this.cb.setValue(this.getLength());
    }

    public StartupInfo(StartupInfo that) {
        this();
        this.initFrom(that);
    }

    public Str getDesktop() {
        return this.desktop;
    }

    public Str getTitle() {
        return this.title;
    }

    public UInt32 getX() {
        return this.x;
    }

    public UInt32 getY() {
        return this.y;
    }

    public UInt32 getxSize() {
        return this.xSize;
    }

    public UInt32 getySize() {
        return this.ySize;
    }

    public UInt32 getxCountChars() {
        return this.xCountChars;
    }

    public UInt32 getyCountChars() {
        return this.yCountChars;
    }

    public UInt32 getFillAttribute() {
        return this.fillAttribute;
    }

    public UInt32 getFlags() {
        return this.flags;
    }

    public UInt16 getShowWindow() {
        return this.showWindow;
    }

    public Handle getStdInput() {
        return this.stdInput;
    }

    public Handle getStdOutput() {
        return this.stdOutput;
    }

    public Handle getStdError() {
        return this.stdError;
    }

    public Object clone() {
        return new StartupInfo(this);
    }

    public static class Options
    extends FlagSet {
        public static final int STARTF_USESHOWWINDOW = 1;
        public static final int STARTF_USESIZE = 2;
        public static final int STARTF_USEPOSITION = 4;
        public static final int STARTF_USECOUNTCHARS = 8;
        public static final int STARTF_USEFILLATTRIBUTE = 16;
        public static final int STARTF_RUNFULLSCREEN = 32;
        public static final int STARTF_FORCEONFEEDBACK = 64;
        public static final int STARTF_FORCEOFFFEEDBACK = 128;
        public static final int STARTF_USESTDHANDLES = 256;
        public static final int STARTF_USEHOTKEY = 512;

        public Options() {
        }

        public Options(long flags) {
            super(flags);
        }

        public void setUseShowWindow(boolean set) {
            this.setupFlag(1L, set);
        }

        public boolean isUseShowWindow() {
            return this.contains(1L);
        }

        public void setUseSize(boolean set) {
            this.setupFlag(2L, set);
        }

        public boolean isUseSize() {
            return this.contains(2L);
        }

        public void setUsePosition(boolean set) {
            this.setupFlag(4L, set);
        }

        public boolean isUsePosition() {
            return this.contains(4L);
        }

        public void setUseCountChars(boolean set) {
            this.setupFlag(8L, set);
        }

        public boolean isUseCountChars() {
            return this.contains(8L);
        }

        public void setUseFillAttributes(boolean set) {
            this.setupFlag(16L, set);
        }

        public boolean isUseFillAttributes() {
            return this.contains(16L);
        }

        public void setRunFullScreen(boolean set) {
            this.setupFlag(32L, set);
        }

        public boolean isRunFullScreen() {
            return this.contains(32L);
        }

        public void setForceOnFeedback(boolean set) {
            this.setupFlag(64L, set);
        }

        public boolean isForceOnFeedback() {
            return this.contains(32L);
        }

        public void setForceOffFeedback(boolean set) {
            this.setupFlag(128L, set);
        }

        public boolean isForceOffFeedback() {
            return this.contains(128L);
        }

        public void setUseStdHandles(boolean set) {
            this.setupFlag(256L, set);
        }

        public boolean isUseStdHandles() {
            return this.contains(256L);
        }
    }
}

