/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Parameter;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Enums;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryValueTransformer;
import com.jniwrapper.win32.registry.WinRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegistryKeyValues
implements Map {
    private static final Logger LOG = Logger.getInstance(class$com$jniwrapper$win32$registry$RegistryKeyValues == null ? (class$com$jniwrapper$win32$registry$RegistryKeyValues = RegistryKeyValues.class$("com.jniwrapper.win32.registry.RegistryKeyValues")) : class$com$jniwrapper$win32$registry$RegistryKeyValues);
    private RegistryKey _registryKey;
    private List _entries = new ArrayList();
    private static final Map TYPE_ASSOCIATIONS = new HashMap();
    static /* synthetic */ Class class$com$jniwrapper$win32$registry$RegistryKeyValues;
    static /* synthetic */ Class class$com$jniwrapper$win32$registry$RegistryKeyType;

    public static void registerAssociation(RegistryKeyType type, RegistryValueTransformer transformer) {
        TYPE_ASSOCIATIONS.put(type, transformer);
    }

    public RegistryKeyValues(RegistryKey registryKey) {
        this._registryKey = registryKey;
        this.load();
    }

    private void load() {
        this._entries.clear();
        int i2 = 0;
        int errorCode = 0;
        while (errorCode == 0) {
            Str valueName = new Str("", 260);
            UInt32 type = new UInt32();
            UInt32 size = new UInt32();
            errorCode = (int)WinRegistry.enumValue(this._registryKey, i2, valueName, new UInt32(260L), type, null, size);
            if (errorCode == 0) {
                RegistryKeyType registryKeyType = (RegistryKeyType)Enums.getItem(class$com$jniwrapper$win32$registry$RegistryKeyType == null ? RegistryKeyValues.class$("com.jniwrapper.win32.registry.RegistryKeyType") : class$com$jniwrapper$win32$registry$RegistryKeyType, (int)type.getValue());
                RegistryValueEntry registryValueEntry = new RegistryValueEntry(valueName.getValue(), registryKeyType, (int)size.getValue());
                this._entries.add(registryValueEntry);
            }
            ++i2;
        }
    }

    private RegistryValueEntry find(Object key) {
        if (!this._entries.isEmpty()) {
            Iterator i2 = this._entries.iterator();
            while (i2.hasNext()) {
                RegistryValueEntry entry = (RegistryValueEntry)i2.next();
                if (!entry.getKey().equals(key)) continue;
                return entry;
            }
        }
        return null;
    }

    public int size() {
        UInt32 valueCount = new UInt32();
        try {
            this._registryKey.checkError(WinRegistry.queryInfoKey(this._registryKey, null, null, null, null, null, valueCount, null, null));
        }
        catch (Exception e2) {
            return 0;
        }
        if (valueCount.getValue() != (long)this._entries.size()) {
            this.load();
        }
        return this._entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.find(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Object get(Object key) {
        RegistryValueEntry entry = this.find(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        RegistryValueEntry entry = this.find(key);
        if (entry == null) {
            entry = new RegistryValueEntry(key.toString());
            entry.setType(entry.getValueType(value));
            entry.setValue(value);
            this._entries.add(entry);
            return null;
        }
        Object prevValue = entry.getValue();
        entry.setValue(value);
        return prevValue;
    }

    public Object put(Object key, Object value, RegistryKeyType valueType) {
        RegistryValueEntry entry = this.find(key);
        if (entry == null) {
            entry = new RegistryValueEntry(key.toString());
            entry.setType(valueType);
            entry.setValue(value);
            this._entries.add(entry);
            return null;
        }
        Object prevValue = entry.getValue();
        entry.setValue(value);
        return prevValue;
    }

    public Object remove(Object key) {
        RegistryValueEntry entry = this.find(key);
        if (entry != null) {
            Object prevValue = entry.getValue();
            this._registryKey.checkError(WinRegistry.deleteValue(this._registryKey, key.toString()));
            this._entries.remove(entry);
            return prevValue;
        }
        return null;
    }

    public void putAll(Map t2) {
        Iterator i2 = t2.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.size();
        Iterator i2 = this._entries.iterator();
        while (i2.hasNext()) {
            Map.Entry entry = (Map.Entry)i2.next();
            this._registryKey.checkError(WinRegistry.deleteValue(this._registryKey, entry.getKey().toString()));
        }
        this._entries.clear();
    }

    public Set keySet() {
        int size = this.size();
        HashSet result = new HashSet(size);
        Iterator i2 = this._entries.iterator();
        while (i2.hasNext()) {
            Map.Entry entry = (Map.Entry)i2.next();
            result.add(entry.getKey());
        }
        return result;
    }

    public Collection values() {
        int size = this.size();
        ArrayList result = new ArrayList(size);
        Iterator i2 = this._entries.iterator();
        while (i2.hasNext()) {
            Map.Entry entry = (Map.Entry)i2.next();
            Object value = entry.getValue();
            result.add(value);
        }
        return result;
    }

    public Set entrySet() {
        return new HashSet(this._entries);
    }

    public List getEntries() {
        return this._entries;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RegistryKeyValues.registerAssociation(RegistryKeyType.NONE, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.SZ, RegistryValueTransformer.STRING_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.EXPAND_SZ, RegistryValueTransformer.STRING_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.DWORD, RegistryValueTransformer.INTEGER_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.BINARY, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.RESOURCE_LIST, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.FULL_RESOURCE_DESCRIPTOR, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.RESOURCE_REQUIREMENTS_LIST, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.MULTI_SZ, RegistryValueTransformer.MULTISTRING_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.QWORD, RegistryValueTransformer.QWORD_TRANSFORMER);
    }

    public class RegistryValueEntry
    implements Map.Entry {
        private String _name;
        private RegistryKeyType _type = RegistryKeyType.NONE;
        private int _size;
        private Object _value;

        public RegistryValueEntry(String name, RegistryKeyType type, int size) {
            this._name = name;
            this._type = type;
            this._size = size;
        }

        public RegistryValueEntry(String name) {
            this._name = name;
        }

        public Object getKey() {
            return this._name;
        }

        private RegistryValueTransformer getValueTransformer(RegistryKeyType type) {
            Iterator i2 = TYPE_ASSOCIATIONS.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                RegistryKeyType keyType = (RegistryKeyType)entry.getKey();
                RegistryValueTransformer valueTranstormer = (RegistryValueTransformer)entry.getValue();
                if (!keyType.equals(type)) continue;
                return valueTranstormer;
            }
            throw new IllegalArgumentException("Unable to get value transformer for given value type: " + type);
        }

        public Object getValue() {
            if (this._value == null && !RegistryKeyValues.this._registryKey.isNull()) {
                RegistryKeyType type = this.getType();
                RegistryValueTransformer transformer = this.getValueTransformer(type);
                this._value = transformer.createRegistryValueParameter(this._size);
                RegistryKeyValues.this._registryKey.checkError(WinRegistry.getValue(RegistryKeyValues.this._registryKey, this._name, type.getValue(), (Parameter)this._value));
                this._value = transformer.fromRegistryValue((Parameter)this._value);
            }
            return this._value;
        }

        public Object setValue(Object value) {
            RegistryKeyType type = this.getType();
            RegistryValueTransformer transformer = this.getValueTransformer(type);
            Parameter result = transformer.toRegistryValue(value);
            RegistryKeyValues.this._registryKey.checkError(WinRegistry.setValue(RegistryKeyValues.this._registryKey, this._name, type.getValue(), result, result.getLength()));
            this._value = value;
            return result;
        }

        private RegistryKeyType getValueType(Object value) {
            RegistryKeyType result = RegistryKeyType.NONE;
            Iterator i2 = TYPE_ASSOCIATIONS.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                RegistryKeyType type = (RegistryKeyType)entry.getKey();
                RegistryValueTransformer transformer = (RegistryValueTransformer)entry.getValue();
                if (!transformer.isTypeSupported(value)) continue;
                result = type;
                break;
            }
            return result;
        }

        public RegistryKeyType getType() {
            return this._type;
        }

        public void setType(RegistryKeyType type) {
            this._type = type;
        }

        public int getSize() {
            return this._size;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("RegistryValueEntry [Name=");
            result.append(this._name).append(";type=").append(this._type).append(']');
            return result.toString();
        }
    }
}

