/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Function;
import com.jniwrapper.LongInt;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.shell.Shell32;
import java.io.File;

public class FileTypeAssociation {
    private static final String FUNCTION_SHCHANGENOTIFY = "SHChangeNotify";
    private static final long SHCNE_ASSOCCHANGED = 0x8000000L;
    private static final long SHCNF_IDLIST = 0L;
    private String _extension;

    public FileTypeAssociation(String extension) {
        this._extension = extension.startsWith(".") ? extension : "." + extension;
    }

    public void createAssociation(File executable, String progID) {
        if (!executable.isFile()) {
            throw new IllegalArgumentException("File not found.");
        }
        String commandLine = "\"" + executable.getAbsolutePath() + "\" \"%1\"";
        this.createAssociation(commandLine, progID);
    }

    public void createAssociation(String commandLine, String progID) {
        RegistryKey registryKey = RegistryKey.CLASSES_ROOT.createSubKey(progID + "\\shell\\open\\command", true);
        RegistryKeyValues values = registryKey.values();
        if (commandLine != null) {
            values.put("", commandLine);
        } else {
            values.put("", "");
        }
        registryKey.close();
        registryKey = RegistryKey.CLASSES_ROOT.createSubKey(this.getExtension(), true);
        values = registryKey.values();
        values.put("", progID, RegistryKeyType.SZ);
        registryKey.close();
        this.changeNotify();
    }

    public void removeAssociation() {
        try {
            RegistryKey.CLASSES_ROOT.deleteSubKey(this.getExtension());
        }
        catch (RegistryException e2) {
            // empty catch block
        }
        try {
            RegistryKey.CURRENT_USER.openSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts").deleteSubKey(this.getExtension());
        }
        catch (RegistryException e3) {
            // empty catch block
        }
        try {
            RegistryKey.LOCAL_MACHINE.openSubKey("SOFTWARE\\Classes").deleteSubKey(this.getExtension());
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        this.changeNotify();
    }

    public String getDefaultCommand() {
        RegistryKey key = RegistryKey.CLASSES_ROOT.openSubKey(this.getProgID());
        key = key.openSubKey("\\shell\\open\\command");
        RegistryKeyValues values = key.values();
        return values.get("").toString();
    }

    public String getProgID() {
        RegistryKeyValues values = RegistryKey.CLASSES_ROOT.openSubKey(this.getExtension()).values();
        return values.get("").toString();
    }

    public boolean isRegistered() {
        try {
            RegistryKey.CLASSES_ROOT.openSubKey(this.getExtension());
        }
        catch (RegistryException e2) {
            return false;
        }
        return true;
    }

    public String getExtension() {
        return this._extension;
    }

    private void changeNotify() {
        Function function = Shell32.getInstance().getFunction(FUNCTION_SHCHANGENOTIFY.toString());
        function.invoke(null, new LongInt(0x8000000L), new UInt(0L), new Pointer(null, true), new Pointer(null, true));
    }
}

