/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Function;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.HResult;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.shell.SHFileInfo;
import com.jniwrapper.win32.shell.SHFolderCustomSettings;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.ShellIcon;
import com.jniwrapper.win32.system.VersionInfo;
import java.io.File;

public class FolderIcon {
    private static final FunctionName FUNCTION_GET_SET_FOLDER_CUSTOM_SETTINGS = new FunctionName("SHGetSetFolderCustomSettings");
    private File _folder;
    private File _iconFile;
    private int _iconIndex;
    private String _infoTip;

    private FolderIcon(File folder, File iconFile, int iconIndex, String infoTip) {
        this._folder = folder;
        this._iconFile = iconFile;
        this._iconIndex = iconIndex;
        this._infoTip = infoTip;
    }

    private static void checkOSVersion() {
        VersionInfo verInfo = new VersionInfo();
        if (verInfo.getMajor() < 5L || verInfo.getMinor() < 1L) {
            throw new RuntimeException("Folder icon customization is not supported by running operation system");
        }
    }

    public File getFolder() {
        return this._folder;
    }

    public File getIconFile() {
        return this._iconFile;
    }

    public int getIconIndex() {
        return this._iconIndex;
    }

    public String getInfoTip() {
        return this._infoTip;
    }

    public ShellIcon getShellIcon() {
        return new ShellIcon(this._iconFile, this._iconIndex);
    }

    public static void setFolderIcon(File folder, File iconFile, int iconIndex) {
        FolderIcon.setFolderIcon(folder, iconFile, iconIndex, null);
    }

    public static void setFolderIcon(File folder, String infoTip) {
        FolderIcon.setFolderIcon(folder, null, 0, infoTip);
    }

    public static void setFolderIcon(File folder, File iconFile, int iconIndex, String infoTip) {
        boolean setIcon = false;
        boolean setInfoTip = false;
        FolderIcon.checkOSVersion();
        if (folder == null || !folder.isDirectory()) {
            throw new IllegalArgumentException("Invalid folder parameter");
        }
        if (iconFile != null) {
            if (!iconFile.isFile()) {
                throw new IllegalArgumentException("Invalid iconFile parameter");
            }
            if (iconIndex < 0) {
                throw new IllegalArgumentException("Invalid iconIndex parameter");
            }
            setIcon = true;
        }
        setInfoTip = infoTip != null;
        SHFolderCustomSettings fcs = new SHFolderCustomSettings();
        SHFolderCustomSettings.FolderSettingsInfo fsi = new SHFolderCustomSettings.FolderSettingsInfo();
        SHFolderCustomSettings.FolderSettingsAction fsa = new SHFolderCustomSettings.FolderSettingsAction();
        if (setIcon) {
            fcs.setIconFile(iconFile.getAbsolutePath());
            fcs.setIconIndex(iconIndex);
            fsi.setIconFile(true);
        }
        if (setInfoTip) {
            fcs.setInfoTip(infoTip);
            fsi.setInfoTip(true);
        }
        fcs.setMask(fsi);
        fsa.setForceWrite(true);
        HResult res = new HResult();
        Function function = Shell32.getInstance().getFunction(FUNCTION_GET_SET_FOLDER_CUSTOM_SETTINGS.toString());
        function.invoke(res, new Pointer(fcs), new Pointer(new Str(folder.getAbsolutePath())), new UInt32(fsa.getFlags()));
        ComException.checkResult((HResult)res);
    }

    public static FolderIcon getFolderIcon(File folder) {
        FolderIcon.checkOSVersion();
        if (folder == null || !folder.isDirectory()) {
            throw new IllegalArgumentException("Invalid folder parameter");
        }
        SHFolderCustomSettings fcs = new SHFolderCustomSettings();
        SHFolderCustomSettings.FolderSettingsInfo fsi = new SHFolderCustomSettings.FolderSettingsInfo();
        SHFolderCustomSettings.FolderSettingsAction fsa = new SHFolderCustomSettings.FolderSettingsAction();
        fcs.resetInfoTipBuffer();
        fsi.setInfoTip(true);
        fcs.setMask(fsi);
        fsa.setRead(true);
        HResult res = new HResult();
        Function function = Shell32.getInstance().getFunction(FUNCTION_GET_SET_FOLDER_CUSTOM_SETTINGS.toString());
        function.invoke(res, new Pointer(fcs), new Pointer(new Str(folder.getAbsolutePath())), new UInt32(fsa.getFlags()));
        SHFileInfo fileInfo = SHFileInfo.getFileInfo(folder.getAbsolutePath(), 4096);
        if (res.getValue() != 0L) {
            return new FolderIcon(folder, new File(fileInfo.getDisplayName()), fileInfo.getIconIndex(), "");
        }
        return new FolderIcon(folder, new File(fileInfo.getDisplayName()), fileInfo.getIconIndex(), fcs.getInfoTip());
    }

    public static void restoreDefaultFolderIcon(File folder) {
        FolderIcon.checkOSVersion();
        if (folder == null || !folder.isDirectory()) {
            throw new IllegalArgumentException("Invalid folder parameter");
        }
        SHFolderCustomSettings fcs = new SHFolderCustomSettings();
        SHFolderCustomSettings.FolderSettingsInfo fsi = new SHFolderCustomSettings.FolderSettingsInfo();
        SHFolderCustomSettings.FolderSettingsAction fsa = new SHFolderCustomSettings.FolderSettingsAction();
        fcs.setIconFile("");
        fcs.setIconIndex(0L);
        fsi.setIconFile(true);
        fcs.setMask(fsi);
        fsa.setForceWrite(true);
        HResult res = new HResult();
        Function function = Shell32.getInstance().getFunction(FUNCTION_GET_SET_FOLDER_CUSTOM_SETTINGS.toString());
        function.invoke(res, new Pointer(fcs), new Pointer(new Str(folder.getAbsolutePath())), new UInt32(fsa.getFlags()));
        ComException.checkResult((HResult)res);
    }
}

