/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.AdvApi32;
import com.jniwrapper.win32.system.Kernel32;

public class SystemInfo
extends Structure {
    private UInt16 _processorArchitecture = new UInt16();
    private UInt16 _reserved = new UInt16();
    private UInt32 _pageSize = new UInt32();
    private Pointer.Void _minAppAddress = new Pointer.Void();
    private Pointer.Void _maxAppAddress = new Pointer.Void();
    private IntPtr _activeProcessorMask = new IntPtr();
    private UInt32 _numberOfProcessors = new UInt32();
    private UInt32 _processorType = new UInt32();
    private UInt32 _allocationGranularity = new UInt32();
    private UInt16 _processorLevel = new UInt16();
    private UInt16 _processorRevision = new UInt16();
    static final String FUNCTION_GET_SYSTEM_INFO = "GetSystemInfo";
    static final FunctionName FUNCTION_GET_COMPUTER_NAME = new FunctionName("GetComputerName");
    static final FunctionName FUNCTION_GET_USER_NAME = new FunctionName("GetUserName");

    public SystemInfo() {
        this.init(new Parameter[]{this._processorArchitecture, this._reserved, this._pageSize, this._minAppAddress, this._maxAppAddress, this._activeProcessorMask, this._numberOfProcessors, this._processorType, this._allocationGranularity, this._processorLevel, this._processorRevision});
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GET_SYSTEM_INFO);
        function.invoke(null, new Pointer(this));
    }

    public SystemInfo(SystemInfo that) {
        this();
        this.initFrom(that);
    }

    public long getProcessorArchitecture() {
        return this._processorArchitecture.getValue();
    }

    public long getPageSize() {
        return this._pageSize.getValue();
    }

    public long getMinAppAddress() {
        return this._minAppAddress.getValue();
    }

    public long getMaxAppAddress() {
        return this._maxAppAddress.getValue();
    }

    public long getActiveProcessorMask() {
        return this._activeProcessorMask.getValue();
    }

    public long getNumberOfProcessors() {
        return this._numberOfProcessors.getValue();
    }

    public long getProcessorType() {
        return this._processorType.getValue();
    }

    public long getAllocationGranularity() {
        return this._allocationGranularity.getValue();
    }

    public long getProcessorLevel() {
        return this._processorLevel.getValue();
    }

    public long getProcessorRevision() {
        return this._processorRevision.getValue();
    }

    public Object clone() {
        return new SystemInfo(this);
    }

    public static String getComputerName() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GET_COMPUTER_NAME.toString());
        Str computerName = new Str("", 256);
        UInt32 size = new UInt32(computerName.getLength());
        Bool retVal = new Bool();
        long errorCode = function.invoke(retVal, new Pointer(computerName), new Pointer(size));
        if (retVal.getValue()) {
            String result = computerName.getValue();
            return result;
        }
        throw new LastErrorException(errorCode, "Unable to get computer name.");
    }

    public static String getUserName() {
        Function function = AdvApi32.get(FUNCTION_GET_USER_NAME);
        Str userName = new Str("", 256);
        UInt32 size = new UInt32(userName.getLength());
        Bool retVal = new Bool();
        long errorCode = function.invoke(retVal, new Pointer(userName), new Pointer(size));
        if (retVal.getValue()) {
            String result = userName.getValue();
            return result;
        }
        throw new LastErrorException(errorCode, "Unable to get user name.");
    }
}

