/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.ui.Wnd;

public class FlashInfo
extends Structure {
    private UInt _size = new UInt();
    private Wnd _wnd;
    private UInt32 _flags = new UInt32();
    private UInt _count = new UInt();
    private UInt32 _timeout = new UInt32();

    public FlashInfo(Wnd wnd, FlashOptions options, long count, long timeout) {
        this._wnd = wnd;
        this._flags.setValue(options.getFlags());
        this._count.setValue(count);
        this._timeout.setValue(timeout);
        this.init(new Parameter[]{this._size, this._wnd, this._flags, this._count, this._timeout}, (short)8);
        this._size.setValue(this.getLength());
    }

    public FlashInfo(FlashInfo that) {
        this(that._wnd, new FlashOptions(that._flags.getValue()), that._count.getValue(), that._timeout.getValue());
        this.initFrom(that);
    }

    public Object clone() {
        return new FlashInfo(this);
    }

    public static class FlashOptions
    extends FlagSet {
        public static final int STOP = 0;
        public static final int CAPTION = 1;
        public static final int TRAY = 2;
        public static final int ALL = 3;
        public static final int TIMER = 4;
        public static final int TIMERNOFG = 12;

        public FlashOptions() {
        }

        public FlashOptions(long flags) {
            super(flags);
        }

        public void setStop() {
            this.clear();
        }

        public void setFlashCaption(boolean value) {
            if (value) {
                this.add(1L);
            } else {
                this.remove(1L);
            }
        }

        public boolean isFlashCaption() {
            return this.contains(1L);
        }

        public void setFlashTray(boolean value) {
            if (value) {
                this.add(2L);
            } else {
                this.remove(2L);
            }
        }

        public boolean isFlashTray() {
            return this.contains(2L);
        }

        public void setFlashAll(boolean value) {
            if (value) {
                this.add(3L);
            } else {
                this.remove(3L);
            }
        }

        public boolean isFlashAll() {
            return this.contains(3L);
        }

        public void setFlashContinuously(boolean value) {
            if (value) {
                this.add(4L);
            } else {
                this.remove(4L);
            }
        }

        public boolean isFlashContinuously() {
            return this.contains(4L);
        }

        public void setFlashContinuouslyNoForeground(boolean value) {
            if (value) {
                this.add(12L);
            } else {
                this.remove(12L);
            }
        }

        public boolean isFlashContinuouslyNoForeground() {
            return this.contains(12L);
        }
    }
}

