/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.ui.controls.AbstractChooserField;
import com.jniwrapper.win32.ui.dialogs.SelectFolderDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class SelectFolderField
extends AbstractChooserField {
    public static final String PROPERTY_FOLDER = "folder";
    public static final int MODE_SELECT_FOLDER = 0;
    public static final int MODE_SELECT_PRINTER = 1;
    public static final int MODE_SELECT_COMPUTER = 2;
    private int _mode = 0;
    private SelectFolderDialog _dialog;

    public SelectFolderField() {
    }

    public SelectFolderField(int mode) {
        this();
        this.setMode(mode);
    }

    public void setFolder(String folder) {
        this.getTextField().setText(folder);
    }

    public String getFolder() {
        return this.getTextField().getText();
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public void actionPerformed(ActionEvent e2) {
        String oldFolder = this.getFolder();
        SelectFolderDialog dialog = this.getDialog();
        dialog.setFolder(oldFolder);
        if (dialog.execute()) {
            String newFolder = dialog.getFolder();
            this.setFolder(newFolder);
            this.firePropertyChange(PROPERTY_FOLDER, oldFolder, newFolder);
        }
    }

    protected SelectFolderDialog createDialog() {
        switch (this.getMode()) {
            case 0: {
                return new SelectFolderDialog();
            }
            case 1: {
                return SelectFolderDialog.createBrowseForPrintersDialog();
            }
            case 2: {
                return SelectFolderDialog.createBrowseForComputersDialog();
            }
        }
        throw new IllegalArgumentException();
    }

    public SelectFolderDialog getDialog() {
        if (this._dialog == null) {
            Window parent = SwingUtilities.getWindowAncestor(this);
            this._dialog = this.createDialog();
            this._dialog.setOwner(parent);
        }
        return this._dialog;
    }
}

