/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.winhttp;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.winhttp.ProxyInfo;
import com.jniwrapper.win32.winhttp.ProxySettings;
import com.jniwrapper.win32.winhttp.WinHttpException;
import com.jniwrapper.win32.winhttp.WinHttpLibrary;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class DefaultProxySettings
implements ProxySettings {
    private static final String FUNCTION_GET_DEFAULT_PROXY_CONFIGURATION = "WinHttpGetDefaultProxyConfiguration";
    private static final int WINHTTP_ACCESS_TYPE_NO_PROXY = 1;
    private boolean _isProxySet;
    private int _proxyPort;
    private String _proxyURL;
    private String _proxyBypass;

    public DefaultProxySettings() throws WinHttpException {
        Function function = WinHttpLibrary.getInstance().getFunction(FUNCTION_GET_DEFAULT_PROXY_CONFIGURATION);
        ProxyInfo proxyInfo = new ProxyInfo();
        IntBool result = new IntBool();
        long errorCode = function.invoke((Parameter)result, new Pointer(proxyInfo));
        if (result.getValue() == 0L) {
            throw new WinHttpException(errorCode);
        }
        long accessType = proxyInfo.getAccessType();
        this._isProxySet = accessType != 1L;
        this._proxyBypass = proxyInfo.getProxyBypass();
        String proxy = proxyInfo.getProxy();
        int portOffset = proxy.lastIndexOf(58);
        String port = proxy.substring(portOffset + 1, proxy.length());
        try {
            this._proxyPort = Integer.parseInt(port);
            this._proxyURL = proxy.substring(0, portOffset);
        }
        catch (NumberFormatException e2) {
            this._proxyPort = -1;
            this._proxyURL = proxy;
        }
    }

    public boolean isSet() {
        return this._isProxySet;
    }

    public String getURL() {
        return this._proxyURL;
    }

    public int getPort() {
        return this._proxyPort;
    }

    public String[] getProxyBypass() {
        return DefaultProxySettings.parseBypasses(this._proxyBypass);
    }

    static String[] parseBypasses(String bypass) {
        LinkedList<String> tokens = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(bypass, "; ");
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        String[] result = new String[tokens.size()];
        tokens.toArray(result);
        return result;
    }
}

