/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.winhttp;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.winhttp.DefaultProxySettings;
import com.jniwrapper.win32.winhttp.IEProxyConfig;
import com.jniwrapper.win32.winhttp.ProxySettings;
import com.jniwrapper.win32.winhttp.WinHttpException;
import com.jniwrapper.win32.winhttp.WinHttpLibrary;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class IEProxySettings
implements ProxySettings {
    private static final String FUNCTION_GET_IE_PROXY_CONFIGURATION = "WinHttpGetIEProxyConfigForCurrentUser";
    private static final String HTTP = "http";
    private static final int UNSPECIFIED = -1;
    private String _proxyURL;
    private int _proxyPort = -1;
    private boolean _isAutoDetect;
    private String _proxyBypass;
    private String _autoConfigURL;
    private List serverInfos;

    public IEProxySettings() throws WinHttpException {
        Function function = WinHttpLibrary.getInstance().getFunction(FUNCTION_GET_IE_PROXY_CONFIGURATION);
        IEProxyConfig ieProxyInfo = new IEProxyConfig();
        IntBool result = new IntBool();
        long errorCode = function.invoke((Parameter)result, new Pointer(ieProxyInfo));
        if (result.getValue() == 0L) {
            throw new WinHttpException(errorCode);
        }
        this._isAutoDetect = ieProxyInfo.isAutoDetect();
        this._autoConfigURL = ieProxyInfo.getAutoConfigUrl();
        this._proxyBypass = ieProxyInfo.getProxyBypass();
        String proxyInfo = ieProxyInfo.getProxy();
        this.serverInfos = new LinkedList();
        StringTokenizer tokenizer = new StringTokenizer(proxyInfo, ";");
        while (tokenizer.hasMoreTokens()) {
            ServerInfo info = new ServerInfo(tokenizer.nextToken());
            this.serverInfos.add(info);
        }
        ServerInfo defaultServerInfo = null;
        for (int i2 = 0; i2 < this.serverInfos.size(); ++i2) {
            ServerInfo serverInfo = (ServerInfo)this.serverInfos.get(i2);
            if (!HTTP.equalsIgnoreCase(serverInfo.getProtocol())) continue;
            defaultServerInfo = serverInfo;
        }
        if (defaultServerInfo != null) {
            this._proxyURL = defaultServerInfo.getProxyAddress();
            this._proxyPort = defaultServerInfo.getProxyPort();
        }
    }

    public boolean isAutoDetect() {
        return this._isAutoDetect;
    }

    public String getAutoConfigURL() {
        return this._autoConfigURL;
    }

    public boolean isSet() {
        return this._proxyPort != -1;
    }

    public int getPort() {
        return this._proxyPort;
    }

    public String getURL() {
        return this._proxyURL;
    }

    public String[] getProxyBypass() {
        return DefaultProxySettings.parseBypasses(this._proxyBypass);
    }

    public List getServers() {
        return Collections.unmodifiableList(this.serverInfos);
    }

    public static class ServerInfo {
        private String protocol;
        private String proxyAddress;
        private int proxyPort = -1;

        ServerInfo(String proxyInfo) {
            this.parseInfo(proxyInfo);
        }

        private void parseInfo(String proxyInfo) {
            block4: {
                int protocolPrefixIndex = proxyInfo.indexOf(61);
                if (protocolPrefixIndex != -1) {
                    this.protocol = proxyInfo.substring(0, protocolPrefixIndex);
                    proxyInfo = proxyInfo.substring(protocolPrefixIndex + 1);
                } else {
                    this.protocol = IEProxySettings.HTTP;
                }
                try {
                    URL serverURL = new URL(proxyInfo);
                    this.proxyAddress = serverURL.getProtocol() + "://" + serverURL.getHost();
                    this.proxyPort = serverURL.getPort();
                }
                catch (MalformedURLException e2) {
                    StringTokenizer infoTokenizer = new StringTokenizer(proxyInfo, ":");
                    this.proxyAddress = infoTokenizer.nextToken();
                    if (!infoTokenizer.hasMoreTokens()) break block4;
                    String port = infoTokenizer.nextToken();
                    this.proxyPort = Integer.parseInt(port);
                }
            }
        }

        ServerInfo(String serverType, String proxyAddress, int proxyPort) {
            this.protocol = serverType;
            this.proxyAddress = proxyAddress;
            this.proxyPort = proxyPort;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getProxyAddress() {
            return this.proxyAddress;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("ServerInfo[");
            result.append("protocol=").append(this.protocol);
            result.append(";proxyAddress=").append(this.proxyAddress);
            result.append(";port=").append(this.proxyPort);
            result.append("]");
            return result.toString();
        }
    }
}

