/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.winhttp;

import com.jniwrapper.win32.LastError;

public class WinHttpException
extends Exception {
    private static final int WINHTTP_ERROR_BASE = 12000;
    public static final int ERROR_WINHTTP_TIMEOUT = 12002;
    public static final int ERROR_WINHTTP_INTERNAL_ERROR = 12004;
    public static final int ERROR_WINHTTP_INVALID_URL = 12005;
    public static final int ERROR_WINHTTP_UNRECOGNIZED_SCHEME = 12006;
    public static final int ERROR_WINHTTP_NAME_NOT_RESOLVED = 12007;
    public static final int ERROR_WINHTTP_INVALID_OPTION = 12009;
    public static final int ERROR_WINHTTP_OPTION_NOT_SETTABLE = 12011;
    public static final int ERROR_WINHTTP_SHUTDOWN = 12012;
    public static final int ERROR_WINHTTP_LOGIN_FAILURE = 12015;
    public static final int ERROR_WINHTTP_OPERATION_CANCELLED = 12017;
    public static final int ERROR_WINHTTP_INCORRECT_HANDLE_TYPE = 12018;
    public static final int ERROR_WINHTTP_INCORRECT_HANDLE_STATE = 12019;
    public static final int ERROR_WINHTTP_CANNOT_CONNECT = 12029;
    public static final int ERROR_WINHTTP_CONNECTION_ERROR = 12030;
    public static final int ERROR_WINHTTP_RESEND_REQUEST = 12032;
    public static final int ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED = 12044;
    public static final int ERROR_WINHTTP_HEADER_NOT_FOUND = 12150;
    public static final int ERROR_WINHTTP_INVALID_SERVER_RESPONSE = 12152;
    public static final int ERROR_WINHTTP_REDIRECT_FAILED = 12156;
    public static final int ERROR_WINHTTP_AUTO_PROXY_SERVICE_ERROR = 12178;
    public static final int ERROR_WINHTTP_BAD_AUTO_PROXY_SCRIPT = 12166;
    public static final int ERROR_WINHTTP_UNABLE_TO_DOWNLOAD_SCRIPT = 12167;
    public static final int ERROR_WINHTTP_SECURE_FAILURE = 12175;
    public static final int ERROR_WINHTTP_SECURE_CERT_DATE_INVALID = 12037;
    public static final int ERROR_WINHTTP_SECURE_CERT_CN_INVALID = 12038;
    public static final int ERROR_WINHTTP_SECURE_INVALID_CA = 12045;
    public static final int ERROR_WINHTTP_SECURE_CERT_REV_FAILED = 12057;
    public static final int ERROR_WINHTTP_SECURE_INVALID_CERT = 12169;
    public static final int ERROR_WINHTTP_SECURE_CERT_REVOKED = 12170;
    public static final int ERROR_WINHTTP_SECURE_CERT_WRONG_USAGE = 12179;
    public static final int ERROR_WINHTTP_AUTODETECTION_FAILED = 12180;
    public static final int ERROR_WINHTTP_HEADER_COUNT_EXCEEDED = 12181;
    public static final int ERROR_WINHTTP_HEADER_SIZE_OVERFLOW = 12182;
    public static final int ERROR_WINHTTP_CHUNKED_ENCODING_HEADER_SIZE_OVERFLOW = 12183;
    public static final int ERROR_WINHTTP_RESPONSE_DRAIN_OVERFLOW = 12184;
    private int _errorCode;

    public WinHttpException() {
    }

    public WinHttpException(String message) {
        super(message);
    }

    public WinHttpException(long errorCode) {
        this(WinHttpException.getMessage((int)errorCode));
        this._errorCode = (int)errorCode;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    private static String getMessage(int errorCode) {
        switch (errorCode) {
            case 12178: {
                return "A proxy for the specified URL cannot be located.";
            }
            case 12180: {
                return "WinHTTP was unable to discover the URL of the Proxy Auto-Configuration (PAC) file.";
            }
            case 12166: {
                return "An error occurred executing the script code in the Proxy Auto-Configuration (PAC) file.";
            }
            case 12029: {
                return "Connection to the server failed.";
            }
            case 12183: {
                return "An overflow condition is encountered in the course of parsing chunked encoding.";
            }
            case 12044: {
                return "The server requests client authentication.";
            }
            case 12030: {
                return "The connection with the server has been reset or terminated";
            }
            case 12181: {
                return "A larger number of headers were present in a response than WinHTTP could receive.";
            }
            case 12150: {
                return "The requested header could not be located.";
            }
            case 12182: {
                return "The size of headers received exceeds the limit for the request handle.";
            }
            case 12019: {
                return "The requested operation cannot be carried out because the handle supplied is not in the correct state.";
            }
            case 12018: {
                return "The type of handle supplied is incorrect for this operation.";
            }
            case 12004: {
                return "An internal error has occurred.";
            }
            case 12009: {
                return "A request to WinHttpQueryOption or WinHttpSetOption specified an invalid option value.";
            }
            case 12152: {
                return "The server response could not be parsed.";
            }
            case 12005: {
                return "The URL is invalid.";
            }
            case 12015: {
                return "The login attempt failed.";
            }
            case 12007: {
                return "The server name could not be resolved.";
            }
            case 12017: {
                return "The operation was canceled.";
            }
            case 12011: {
                return "The requested option cannot be set, only queried.";
            }
            case 12156: {
                return "The redirection failed.";
            }
            case 12032: {
                return "The WinHTTP function failed.";
            }
            case 12184: {
                return "An incoming response exceeds an internal WinHTTP size limit.";
            }
            case 12038: {
                return "A certificate's CN name does not match the passed value";
            }
            case 12037: {
                return "Indicates that a required certificate is not within its validity period";
            }
            case 12057: {
                return "Revocation could not be checked because the revocation server was offline";
            }
            case 12170: {
                return "A certificate has been revoked";
            }
            case 12179: {
                return "A certificate is not valid for the requested usage";
            }
            case 12175: {
                return "One or more errors were found in the SSL certificate sent by the server.";
            }
            case 12045: {
                return "A certificate chain is not trusted by the trust provider.";
            }
            case 12169: {
                return "A certificate is invalid";
            }
            case 12012: {
                return "The WinHTTP function support is being shut down or unloaded.";
            }
            case 12002: {
                return "The request has timed out.";
            }
            case 12167: {
                return "The PAC file could not be downloaded.";
            }
            case 12006: {
                return "The URL specified a scheme other than \"http:\" or \"https:\".";
            }
        }
        return LastError.getMessage(errorCode);
    }
}

