/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.assertions;

import de.qfs.lib.assertions.Assertion;
import de.qfs.lib.assertions.AssertionFactory;
import de.qfs.lib.assertions.Expect;
import de.qfs.lib.util.Misc;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;

public abstract class Assert {
    public static boolean test(BooleanSupplier booleanSupplier, String string) {
        return Assert.doAssert(booleanSupplier, (Object)string, null, null, "test");
    }

    public static boolean test(boolean bl, String string) {
        return Assert.doAssert(bl, (Object)string, null, null, "test");
    }

    public static boolean fail() {
        return Assert.fail(null, null, null, null, null);
    }

    public static boolean fail(String string) {
        return Assert.fail(null, null, string, null, null);
    }

    public static boolean fail(Object object, Object object2) {
        return Assert.fail(object, object2, null, null, null);
    }

    public static boolean fail(Object object, Object object2, String string) {
        return Assert.fail(object, object2, string, null, null);
    }

    public static boolean fail(Object object, Object object2, String string, String string2) {
        return Assert.fail(object, object2, string, string2, null);
    }

    public static boolean fail(Object object, Object object2, String string, String string2, String string3) {
        if (Misc.emptyOrNull(string)) {
            string = "Assert.fail()";
        }
        if (Misc.emptyOrNull(string3)) {
            string3 = Assert.class.getName() + ".fail";
        }
        return Expect.fail(object, object2, string, string2, string3);
    }

    public static boolean isOk(Object object, String string) {
        return Assert.expect(object, string, "isOk").getOk().getResult();
    }

    public static boolean isOk(Object object) {
        return Assert.isOk(object, null);
    }

    public static boolean ok(Object object, String string) {
        return Assert.expect(object, string, "ok").getOk().getResult();
    }

    public static boolean ok(Object object) {
        return Assert.ok(object, null);
    }

    public static boolean isNotOk(Object object, String string) {
        return Assert.expect(object, string, "isNotOk").getNot().getOk().getResult();
    }

    public static boolean isNotOk(Object object) {
        return Assert.isNotOk(object, null);
    }

    public static boolean notOk(Object object, String string) {
        return Assert.expect(object, string, "notOk").getNot().getOk().getResult();
    }

    public static boolean notOk(Object object) {
        return Assert.notOk(object, null);
    }

    public static boolean equal(Object object, Object object2, String string) {
        return Assert.expect(object, string, "equal").equal(object2).getResult();
    }

    public static boolean equal(Object object, Object object2) {
        return Assert.equal(object, object2, null);
    }

    public static boolean notEqual(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notEqual").getNot().equal(object2).getResult();
    }

    public static boolean notEqual(Object object, Object object2) {
        return Assert.notEqual(object, object2, null);
    }

    public static boolean strictEqual(Object object, Object object2, String string) {
        return Assert.expect(object, string, "strictEqual").getStrict().equal(object2).getResult();
    }

    public static boolean strictEqual(Object object, Object object2) {
        return Assert.strictEqual(object, object2, null);
    }

    public static boolean notStrictEqual(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notStrictEqual").getNot().getStrict().equal(object2).getResult();
    }

    public static boolean notStrictEqual(Object object, Object object2) {
        return Assert.notStrictEqual(object, object2, null);
    }

    public static boolean deepEqual(Object object, Object object2, String string) {
        return Assert.expect(object, string, "deepEqual").getDeep().equal(object2).getResult();
    }

    public static boolean deepEqual(Object object, Object object2) {
        return Assert.deepEqual(object, object2, null);
    }

    public static boolean notDeepEqual(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notDeepEqual").getNot().getDeep().equal(object2).getResult();
    }

    public static boolean notDeepEqual(Object object, Object object2) {
        return Assert.notDeepEqual(object, object2, null);
    }

    public static boolean isTrue(Object object, String string) {
        return Assert.expect(object, string, "isTrue").getTRUE().getResult();
    }

    public static boolean isTrue(Object object) {
        return Assert.isTrue(object, null);
    }

    public static boolean isNotTrue(Object object, String string) {
        return Assert.expect(object, string, "isNotTrue").getNot().getTRUE().getResult();
    }

    public static boolean isNotTrue(Object object) {
        return Assert.isNotTrue(object, null);
    }

    public static boolean isFalse(Object object, String string) {
        return Assert.expect(object, string, "isFalse").getFALSE().getResult();
    }

    public static boolean isFalse(Object object) {
        return Assert.isFalse(object, null);
    }

    public static boolean isNotFalse(Object object, String string) {
        return Assert.expect(object, string, "isNotFalse").getNot().getFALSE().getResult();
    }

    public static boolean isNotFalse(Object object) {
        return Assert.isNotFalse(object, null);
    }

    public static boolean isNull(Object object, String string) {
        return Assert.expect(object, string, "isNull").getNULL().getResult();
    }

    public static boolean isNull(Object object) {
        return Assert.isNull(object, null);
    }

    public static boolean isNotNull(Object object, String string) {
        return Assert.expect(object, string, "isNotNull").getNot().getNULL().getResult();
    }

    public static boolean isNotNull(Object object) {
        return Assert.isNotNull(object, null);
    }

    public static boolean exists(Object object, String string) {
        return Assert.expect(object, string, "exists").getExists().getResult();
    }

    public static boolean exists(Object object) {
        return Assert.exists(object, null);
    }

    public static boolean notExists(Object object, String string) {
        return Assert.expect(object, string, "notExists").getNot().getExists().getResult();
    }

    public static boolean notExists(Object object) {
        return Assert.notExists(object, null);
    }

    public static boolean isFunction(Object object, String string) {
        return Assert.expect(object, string, "isFunction").a("function").getResult();
    }

    public static boolean isFunction(Object object) {
        return Assert.isFunction(object, null);
    }

    public static boolean isNotFunction(Object object, String string) {
        return Assert.expect(object, string, "isNotFunction").getNot().a("function").getResult();
    }

    public static boolean isNotFunction(Object object) {
        return Assert.isNotFunction(object, null);
    }

    public static boolean isMap(Object object, String string) {
        return Assert.expect(object, string, "isMap").a(Map.class).getResult();
    }

    public static boolean isMap(Object object) {
        return Assert.isMap(object, null);
    }

    public static boolean isNotMap(Object object, String string) {
        return Assert.expect(object, string, "isNotMap").getNot().a(Map.class).getResult();
    }

    public static boolean isNotMap(Object object) {
        return Assert.isNotMap(object, null);
    }

    public static boolean isList(Object object, String string) {
        return Assert.expect(object, string, "isList").a(List.class).getResult();
    }

    public static boolean isList(Object object) {
        return Assert.isList(object, null);
    }

    public static boolean isNotList(Object object, String string) {
        return Assert.expect(object, string, "isNotList").getNot().a(List.class).getResult();
    }

    public static boolean isNotList(Object object) {
        return Assert.isNotList(object, null);
    }

    public static boolean isObject(Object object, String string) {
        return Assert.expect(object, string, "isObject").an(Object.class).getResult();
    }

    public static boolean isObject(Object object) {
        return Assert.isObject(object, null);
    }

    public static boolean isObject(byte by, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)by, "isObject");
    }

    public static boolean isObject(byte by) {
        return Assert.isObject(by, null);
    }

    public static boolean isObject(short s, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)s, "isObject");
    }

    public static boolean isObject(short s) {
        return Assert.isObject(s, null);
    }

    public static boolean isObject(int n, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)n, "isObject");
    }

    public static boolean isObject(int n) {
        return Assert.isObject(n, null);
    }

    public static boolean isObject(long l, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)l, "isObject");
    }

    public static boolean isObject(long l) {
        return Assert.isObject(l, null);
    }

    public static boolean isObject(float f, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)Float.valueOf(f), "isObject");
    }

    public static boolean isObject(float f) {
        return Assert.isObject(f, null);
    }

    public static boolean isObject(double d, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)d, "isObject");
    }

    public static boolean isObject(double d) {
        return Assert.isObject(d, null);
    }

    public static boolean isObject(boolean bl, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)bl, "isObject");
    }

    public static boolean isObject(boolean bl) {
        return Assert.isObject(bl, null);
    }

    public static boolean isObject(char c, String string) {
        return Assert.doAssert(false, Assert.prefixMessage(string, "expected ${this} to be an object"), null, (Object)Character.valueOf(c), "isObject");
    }

    public static boolean isObject(char c) {
        return Assert.isObject(c, null);
    }

    public static boolean isNotObject(Object object, String string) {
        return Assert.expect(object, string, "isNotObject").getNot().an(Object.class).getResult();
    }

    public static boolean isNotObject(Object object) {
        return Assert.isNotObject(object, null);
    }

    public static boolean isNotObject(byte by, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)by, "isNotObject");
    }

    public static boolean isNotObject(byte by) {
        return Assert.isNotObject(by, null);
    }

    public static boolean isNotObject(short s, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)s, "isNotObject");
    }

    public static boolean isNotObject(short s) {
        return Assert.isNotObject(s, null);
    }

    public static boolean isNotObject(int n, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)n, "isNotObject");
    }

    public static boolean isNotObject(int n) {
        return Assert.isNotObject(n, null);
    }

    public static boolean isNotObject(long l, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)l, "isNotObject");
    }

    public static boolean isNotObject(long l) {
        return Assert.isNotObject(l, null);
    }

    public static boolean isNotObject(float f, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)Float.valueOf(f), "isNotObject");
    }

    public static boolean isNotObject(float f) {
        return Assert.isNotObject(f, null);
    }

    public static boolean isNotObject(double d, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)d, "isNotObject");
    }

    public static boolean isNotObject(double d) {
        return Assert.isNotObject(d, null);
    }

    public static boolean isNotObject(boolean bl, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)bl, "isNotObject");
    }

    public static boolean isNotObject(boolean bl) {
        return Assert.isNotObject(bl, null);
    }

    public static boolean isNotObject(char c, String string) {
        return Assert.doAssert(true, Assert.prefixMessage(string, "expected ${this} not to be an object"), null, (Object)Character.valueOf(c), "isNotObject");
    }

    public static boolean isNotObject(char c) {
        return Assert.isNotObject(c, null);
    }

    public static boolean isArray(Object object, String string) {
        return Assert.expect(object, string, "isArray").a("array").getResult();
    }

    public static boolean isArray(Object object) {
        return Assert.isArray(object, null);
    }

    public static boolean isNotArray(Object object, String string) {
        return Assert.expect(object, string, "isNotArray").getNot().a("array").getResult();
    }

    public static boolean isNotArray(Object object) {
        return Assert.isNotArray(object, null);
    }

    public static boolean isString(Object object, String string) {
        return Assert.expect(object, string, "isString").a("java.lang.String").getResult();
    }

    public static boolean isString(Object object) {
        return Assert.isString(object, null);
    }

    public static boolean isNotString(Object object, String string) {
        return Assert.expect(object, string, "isNotString").getNot().a("java.lang.String").getResult();
    }

    public static boolean isNotString(Object object) {
        return Assert.isNotString(object, null);
    }

    public static boolean isNumber(Object object, String string) {
        return Assert.expect(object, string, "isNumber").a("java.lang.Number").getResult();
    }

    public static boolean isNumber(Object object) {
        return Assert.isNumber(object, null);
    }

    public static boolean isNotNumber(Object object, String string) {
        return Assert.expect(object, string, "isNotNumber").getNot().a("java.lang.Number").getResult();
    }

    public static boolean isNotNumber(Object object) {
        return Assert.isNotNumber(object, null);
    }

    public static boolean isBoolean(Object object, String string) {
        return Assert.expect(object, string, "isBoolean").a("java.lang.Boolean").getResult();
    }

    public static boolean isBoolean(Object object) {
        return Assert.isBoolean(object, null);
    }

    public static boolean isNotBoolean(Object object, String string) {
        return Assert.expect(object, string, "isNotBoolean").getNot().a("java.lang.Boolean").getResult();
    }

    public static boolean isNotBoolean(Object object) {
        return Assert.isNotBoolean(object, null);
    }

    public static boolean typeOf(Object object, Object object2, String string) {
        return Assert.expect(object, string, "typeOf").a(object2).getResult();
    }

    public static boolean typeOf(Object object, Object object2) {
        return Assert.typeOf(object, object2, null);
    }

    public static boolean notTypeOf(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notTypeOf").getNot().a(object2).getResult();
    }

    public static boolean notTypeOf(Object object, Object object2) {
        return Assert.notTypeOf(object, object2, null);
    }

    public static boolean instanceOf(Object object, Object object2, String string) {
        return Assert.expect(object, string, "instanceOf").getTo().getBe().instanceOf(object2).getResult();
    }

    public static boolean instanceOf(Object object, Object object2) {
        return Assert.instanceOf(object, object2, null);
    }

    public static boolean notInstanceOf(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notInstanceOf").getTo().getNot().getBe().instanceOf(object2).getResult();
    }

    public static boolean notInstanceOf(Object object, Object object2) {
        return Assert.notInstanceOf(object, object2, null);
    }

    public static boolean include(Object object, Object object2, String string) {
        return Assert.expect(object, string, "include").include(object2).getResult();
    }

    public static boolean include(Object object, Object object2) {
        return Assert.include(object, object2, null);
    }

    public static boolean notInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notInclude").getNot().include(object2).getResult();
    }

    public static boolean notInclude(Object object, Object object2) {
        return Assert.notInclude(object, object2, null);
    }

    public static boolean deepInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "deepInclude").getDeep().include(object2).getResult();
    }

    public static boolean deepInclude(Object object, Object object2) {
        return Assert.deepInclude(object, object2, null);
    }

    public static boolean notDeepInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notDeepInclude").getNot().getDeep().include(object2).getResult();
    }

    public static boolean notDeepInclude(Object object, Object object2) {
        return Assert.notDeepInclude(object, object2, null);
    }

    public static boolean strictInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "strictInclude").getStrict().include(object2).getResult();
    }

    public static boolean strictInclude(Object object, Object object2) {
        return Assert.strictInclude(object, object2, null);
    }

    public static boolean notStrictInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notStrictInclude").getNot().getStrict().include(object2).getResult();
    }

    public static boolean notStrictInclude(Object object, Object object2) {
        return Assert.notStrictInclude(object, object2, null);
    }

    public static boolean nestedInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "nestedInclude").getNested().include(object2).getResult();
    }

    public static boolean nestedInclude(Object object, Object object2) {
        return Assert.nestedInclude(object, object2, null);
    }

    public static boolean notNestedInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notNestedInclude").getNot().getNested().include(object2).getResult();
    }

    public static boolean notNestedInclude(Object object, Object object2) {
        return Assert.notNestedInclude(object, object2, null);
    }

    public static boolean deepNestedInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "deepNestedInclude").getDeep().getNested().include(object2).getResult();
    }

    public static boolean deepNestedInclude(Object object, Object object2) {
        return Assert.deepNestedInclude(object, object2, null);
    }

    public static boolean notDeepNestedInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notDeepNestedInclude").getNot().getDeep().getNested().include(object2).getResult();
    }

    public static boolean notDeepNestedInclude(Object object, Object object2) {
        return Assert.notDeepNestedInclude(object, object2, null);
    }

    public static boolean strictNestedInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "strictNestedInclude").getStrict().getNested().include(object2).getResult();
    }

    public static boolean strictNestedInclude(Object object, Object object2) {
        return Assert.strictNestedInclude(object, object2, null);
    }

    public static boolean notStrictNestedInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notStrictNestedInclude").getNot().getStrict().getNested().include(object2).getResult();
    }

    public static boolean notStrictNestedInclude(Object object, Object object2) {
        return Assert.notStrictNestedInclude(object, object2, null);
    }

    public static boolean ownInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "ownInclude").getOwn().include(object2).getResult();
    }

    public static boolean ownInclude(Object object, Object object2) {
        return Assert.ownInclude(object, object2, null);
    }

    public static boolean notOwnInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notOwnInclude").getNot().getOwn().include(object2).getResult();
    }

    public static boolean notOwnInclude(Object object, Object object2) {
        return Assert.notOwnInclude(object, object2, null);
    }

    public static boolean deepOwnInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "deepOwnInclude").getDeep().getOwn().include(object2).getResult();
    }

    public static boolean deepOwnInclude(Object object, Object object2) {
        return Assert.deepOwnInclude(object, object2, null);
    }

    public static boolean notDeepOwnInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notDeepOwnInclude").getNot().getDeep().getOwn().include(object2).getResult();
    }

    public static boolean notDeepOwnInclude(Object object, Object object2) {
        return Assert.notDeepOwnInclude(object, object2, null);
    }

    public static boolean strictOwnInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "strictOwnInclude").getStrict().getOwn().include(object2).getResult();
    }

    public static boolean strictOwnInclude(Object object, Object object2) {
        return Assert.strictOwnInclude(object, object2, null);
    }

    public static boolean notStrictOwnInclude(Object object, Object object2, String string) {
        return Assert.expect(object, string, "notStrictOwnInclude").getNot().getStrict().getOwn().include(object2).getResult();
    }

    public static boolean notStrictOwnInclude(Object object, Object object2) {
        return Assert.notStrictOwnInclude(object, object2, null);
    }

    public static boolean match(String string, Pattern pattern, String string2) {
        return Assert.expect(string, string2, "match").match(pattern).getResult();
    }

    public static boolean match(String string, Pattern pattern) {
        return Assert.match(string, pattern, null);
    }

    public static boolean match(String string, String string2, String string3) {
        return Assert.expect(string, string3, "match").match(string2).getResult();
    }

    public static boolean match(String string, String string2) {
        return Assert.match(string, string2, null);
    }

    public static boolean notMatch(String string, Pattern pattern, String string2) {
        return Assert.expect(string, string2, "notMatch").getNot().match(pattern).getResult();
    }

    public static boolean notMatch(String string, Pattern pattern) {
        return Assert.notMatch(string, pattern, null);
    }

    public static boolean notMatch(String string, String string2, String string3) {
        return Assert.expect(string, string3, "notMatch").getNot().match(string2).getResult();
    }

    public static boolean notMatch(String string, String string2) {
        return Assert.notMatch(string, string2, null);
    }

    public static boolean property(Object object, String string, String string2) {
        return Assert.expect(object, string2, "property").getTo().getHave().property(string).getResult();
    }

    public static boolean property(Object object, String string) {
        return Assert.property(object, string, null);
    }

    public static boolean notProperty(Object object, String string, String string2) {
        return Assert.expect(object, string2, "notProperty").getTo().getNot().getHave().property(string).getResult();
    }

    public static boolean notProperty(Object object, String string) {
        return Assert.notProperty(object, string, null);
    }

    public static boolean propertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "propertyVal").getTo().getHave().property(string, object2).getResult();
    }

    public static boolean propertyVal(Object object, String string, Object object2) {
        return Assert.propertyVal(object, string, object2, null);
    }

    public static boolean notPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notPropertyVal").getTo().getNot().getHave().property(string, object2).getResult();
    }

    public static boolean notPropertyVal(Object object, String string, Object object2) {
        return Assert.notPropertyVal(object, string, object2, null);
    }

    public static boolean deepPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "deepPropertyVal").getTo().getHave().getDeep().property(string, object2).getResult();
    }

    public static boolean deepPropertyVal(Object object, String string, Object object2) {
        return Assert.deepPropertyVal(object, string, object2, null);
    }

    public static boolean notDeepPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notDeepPropertyVal").getTo().getNot().getHave().getDeep().property(string, object2).getResult();
    }

    public static boolean notDeepPropertyVal(Object object, String string, Object object2) {
        return Assert.notDeepPropertyVal(object, string, object2, null);
    }

    public static boolean strictPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "strictPropertyVal").getTo().getHave().getStrict().property(string, object2).getResult();
    }

    public static boolean strictPropertyVal(Object object, String string, Object object2) {
        return Assert.strictPropertyVal(object, string, object2, null);
    }

    public static boolean notStrictPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notStrictPropertyVal").getTo().getNot().getHave().getStrict().property(string, object2).getResult();
    }

    public static boolean notStrictPropertyVal(Object object, String string, Object object2) {
        return Assert.notStrictPropertyVal(object, string, object2, null);
    }

    public static boolean ownProperty(Object object, String string, String string2) {
        return Assert.expect(object, string2, "ownProperty").getTo().getHave().getOwn().property(string).getResult();
    }

    public static boolean ownProperty(Object object, String string) {
        return Assert.ownProperty(object, string, null);
    }

    public static boolean notOwnProperty(Object object, String string, String string2) {
        return Assert.expect(object, string2, "notOwnProperty").getTo().getNot().getHave().getOwn().property(string).getResult();
    }

    public static boolean notOwnProperty(Object object, String string) {
        return Assert.notOwnProperty(object, string, null);
    }

    public static boolean ownPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "ownPropertyVal").getTo().getHave().getOwn().property(string, object2).getResult();
    }

    public static boolean ownPropertyVal(Object object, String string, Object object2) {
        return Assert.ownPropertyVal(object, string, object2, null);
    }

    public static boolean notOwnPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notOwnPropertyVal").getTo().getNot().getHave().getOwn().property(string, object2).getResult();
    }

    public static boolean notOwnPropertyVal(Object object, String string, Object object2) {
        return Assert.notOwnPropertyVal(object, string, object2, null);
    }

    public static boolean deepOwnPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "deepOwnPropertyVal").getTo().getHave().getDeep().getOwn().property(string, object2).getResult();
    }

    public static boolean deepOwnPropertyVal(Object object, String string, Object object2) {
        return Assert.deepOwnPropertyVal(object, string, object2, null);
    }

    public static boolean notDeepOwnPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notDeepOwnPropertyVal").getTo().getNot().getHave().getDeep().getOwn().property(string, object2).getResult();
    }

    public static boolean notDeepOwnPropertyVal(Object object, String string, Object object2) {
        return Assert.notDeepOwnPropertyVal(object, string, object2, null);
    }

    public static boolean strictOwnPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "strictOwnPropertyVal").getTo().getHave().getStrict().getOwn().property(string, object2).getResult();
    }

    public static boolean strictOwnPropertyVal(Object object, String string, Object object2) {
        return Assert.strictOwnPropertyVal(object, string, object2, null);
    }

    public static boolean notStrictOwnPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notStrictOwnPropertyVal").getTo().getNot().getHave().getStrict().getOwn().property(string, object2).getResult();
    }

    public static boolean notStrictOwnPropertyVal(Object object, String string, Object object2) {
        return Assert.notStrictOwnPropertyVal(object, string, object2, null);
    }

    public static boolean nestedProperty(Object object, String string, String string2) {
        return Assert.expect(object, string2, "nestedProperty").getTo().getHave().getNested().property(string).getResult();
    }

    public static boolean nestedProperty(Object object, String string) {
        return Assert.nestedProperty(object, string, null);
    }

    public static boolean notNestedProperty(Object object, String string, String string2) {
        return Assert.expect(object, string2, "notNestedProperty").getTo().getNot().getHave().getNested().property(string).getResult();
    }

    public static boolean notNestedProperty(Object object, String string) {
        return Assert.notNestedProperty(object, string, null);
    }

    public static boolean nestedPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "nestedPropertyVal").getTo().getHave().getNested().property(string, object2).getResult();
    }

    public static boolean nestedPropertyVal(Object object, String string, Object object2) {
        return Assert.nestedPropertyVal(object, string, object2, null);
    }

    public static boolean notNestedPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notNestedPropertyVal").getTo().getNot().getHave().getNested().property(string, object2).getResult();
    }

    public static boolean notNestedPropertyVal(Object object, String string, Object object2) {
        return Assert.notNestedPropertyVal(object, string, object2, null);
    }

    public static boolean deepNestedPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "deepNestedPropertyVal").getTo().getHave().getDeep().getNested().property(string, object2).getResult();
    }

    public static boolean deepNestedPropertyVal(Object object, String string, Object object2) {
        return Assert.deepNestedPropertyVal(object, string, object2, null);
    }

    public static boolean notDeepNestedPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notDeepNestedPropertyVal").getTo().getNot().getHave().getDeep().getNested().property(string, object2).getResult();
    }

    public static boolean notDeepNestedPropertyVal(Object object, String string, Object object2) {
        return Assert.notDeepNestedPropertyVal(object, string, object2, null);
    }

    public static boolean strictNestedPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "strictNestedPropertyVal").getTo().getHave().getStrict().getNested().property(string, object2).getResult();
    }

    public static boolean strictNestedPropertyVal(Object object, String string, Object object2) {
        return Assert.strictNestedPropertyVal(object, string, object2, null);
    }

    public static boolean notStrictNestedPropertyVal(Object object, String string, Object object2, String string2) {
        return Assert.expect(object, string2, "notStrictNestedPropertyVal").getTo().getNot().getHave().getStrict().getNested().property(string, object2).getResult();
    }

    public static boolean notStrictNestedPropertyVal(Object object, String string, Object object2) {
        return Assert.notStrictNestedPropertyVal(object, string, object2, null);
    }

    public static boolean lengthOf(Object object, int n, String string) {
        return Assert.expect(object, string, "lengthOf").getTo().getHave().lengthOf(n).getResult();
    }

    public static boolean lengthOf(Object object, int n) {
        return Assert.lengthOf(object, n, null);
    }

    public static boolean isEmpty(Object object, String string) {
        return Assert.expect(object, string, "isEmpty").getEmpty().getResult();
    }

    public static boolean isEmpty(Object object) {
        return Assert.isEmpty(object, null);
    }

    public static boolean empty(Object object, String string) {
        return Assert.expect(object, string, "empty").getEmpty().getResult();
    }

    public static boolean empty(Object object) {
        return Assert.empty(object, null);
    }

    public static boolean isNotEmpty(Object object, String string) {
        return Assert.expect(object, string, "isNotEmpty").getNot().getEmpty().getResult();
    }

    public static boolean isNotEmpty(Object object) {
        return Assert.isNotEmpty(object, null);
    }

    public static boolean notEmpty(Object object, String string) {
        return Assert.expect(object, string, "notEmpty").getNot().getEmpty().getResult();
    }

    public static boolean notEmpty(Object object) {
        return Assert.notEmpty(object, null);
    }

    private static Assertion expect(Object object, String string, String string2) {
        return AssertionFactory.instance().get(object, string, Assert.class.getName() + "." + string2);
    }

    private static boolean doAssert(BooleanSupplier booleanSupplier, Object object, Object object2, Object object3, String string) {
        return Assert.expect(null, null, string).doAssert(booleanSupplier, object, (Object)"[ negation message unavailable ]", object2, object3);
    }

    private static boolean doAssert(boolean bl, Object object, Object object2, Object object3, String string) {
        return Assert.expect(null, null, string).doAssert(bl, object, (Object)"[ negation message unavailable ]", object2, object3);
    }

    private static Object prefixMessage(String string, String string2) {
        return (Misc.emptyOrNull(string) ? "" : string + ": ") + string2;
    }
}

