/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.assertions;

import de.qfs.lib.assertions.AssertionUtil;
import de.qfs.lib.notifications.NotificationName;
import de.qfs.lib.notifications.Notifier;
import de.qfs.lib.util.Reflector;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;

public interface Assertion
extends Cloneable {
    public static final Object NO_ARG = new Object();

    default public Assertion self() {
        try {
            return (Assertion)Reflector.get(this, "thisAssertion", true);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("self() must not be called on the default implementation, if no property 'thisAssertion' exists");
        }
    }

    default public Object flag(String string) {
        return this.self().flag(string);
    }

    default public void flag(String string, Object object) {
        this.self().flag(string, object);
    }

    default public void _ssfi(Class clazz, String string) {
        if (this.flag("ssfi") == null) {
            this.flag("ssfi", clazz.getName() + "." + string);
        }
    }

    default public Boolean getResult() {
        if (this.flag("result") == null) {
            throw new IllegalStateException("Assertion incomplete");
        }
        return AssertionUtil.flagAsBoolean(this.self(), "result");
    }

    default public Boolean result() {
        return this.getResult();
    }

    default public Object _obj() {
        return this.self().flag("object");
    }

    default public void _obj(Object object) {
        this.self().flag("object", object);
    }

    default public String _inspect(Object object) {
        return AssertionUtil.objDisplay(object);
    }

    default public boolean doAssert(BooleanSupplier booleanSupplier) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(booleanSupplier, null, null, null, this._obj());
    }

    default public boolean doAssert(boolean bl, Object object) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(() -> bl, object, object, null, this._obj());
    }

    default public boolean doAssert(boolean bl, Object object, Object object2) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(() -> bl, object, object2, null, this._obj());
    }

    default public boolean doAssert(boolean bl, Object object, Object object2, Object object3) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(() -> bl, object, object2, object3, this._obj());
    }

    default public boolean doAssert(boolean bl, Object object, Object object2, Object object3, Object object4) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(() -> bl, object, object2, object3, object4);
    }

    default public boolean doAssert(boolean bl) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(() -> bl, null, null, null, this._obj());
    }

    default public boolean doAssert(BooleanSupplier booleanSupplier, Object object) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(booleanSupplier, object, object, null, this._obj());
    }

    default public boolean doAssert(BooleanSupplier booleanSupplier, Object object, Object object2) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(booleanSupplier, object, object2, null, this._obj());
    }

    default public boolean doAssert(BooleanSupplier booleanSupplier, Object object, Object object2, Object object3) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(booleanSupplier, object, object2, object3, this._obj());
    }

    default public boolean doAssert(BooleanSupplier booleanSupplier, Object object, Object object2, Object object3, Object object4) {
        this._ssfi(Assertion.class, "doAssert");
        return this.self().doAssert(booleanSupplier, object, object2, object3, object4);
    }

    default public Assertion getTo() {
        return this.self();
    }

    default public Assertion getBe() {
        return this.self();
    }

    default public Assertion getBeen() {
        return this.self();
    }

    default public Assertion getIs() {
        return this.self();
    }

    default public Assertion getThat() {
        return this.self();
    }

    default public Assertion getWhich() {
        return this.self();
    }

    default public Assertion getAnd() {
        return this.self();
    }

    default public Assertion getHas() {
        return this.self();
    }

    default public Assertion getHave() {
        return this.self();
    }

    default public Assertion getWith() {
        return this.self();
    }

    default public Assertion getAt() {
        return this.self();
    }

    default public Assertion getOf() {
        return this.self();
    }

    default public Assertion getSame() {
        return this.self();
    }

    default public Assertion getBut() {
        return this.self();
    }

    default public Assertion getDoes() {
        return this.self();
    }

    default public Assertion getStill() {
        return this.self();
    }

    default public Assertion getAlso() {
        return this.self();
    }

    default public Assertion getNot() {
        Assertion assertion = this.self();
        assertion.flag("negate", true);
        return assertion;
    }

    default public Assertion getDeep() {
        Assertion assertion = this.self();
        assertion.flag("deep", true);
        return assertion;
    }

    default public Assertion getStrict() {
        Assertion assertion = this.self();
        assertion.flag("strict", true);
        return assertion;
    }

    default public Assertion getStrictly() {
        return this.getStrict();
    }

    default public Assertion getNested() {
        Assertion assertion = this.self();
        assertion.flag("nested", true);
        return assertion;
    }

    default public Assertion getOwn() {
        Assertion assertion = this.self();
        assertion.flag("own", true);
        return assertion;
    }

    default public Assertion getOrdered() {
        Assertion assertion = this.self();
        assertion.flag("ordered", true);
        return assertion;
    }

    default public Assertion getAny() {
        Assertion assertion = this.self();
        assertion.flag("any", true);
        assertion.flag("all", false);
        return assertion;
    }

    default public Assertion getAll() {
        Assertion assertion = this.self();
        assertion.flag("all", true);
        assertion.flag("any", false);
        return assertion;
    }

    default public Assertion an(Object object) {
        return this.an(object, null);
    }

    default public Assertion an(Object object, String string) {
        this._ssfi(Assertion.class, "an");
        return this.self().an(object, string);
    }

    default public Assertion a(Object object) {
        return this.a(object, null);
    }

    default public Assertion a(Object object, String string) {
        this._ssfi(Assertion.class, "a");
        return this.an(object, string);
    }

    default public Assertion instanceOf(Object object) {
        return this.instanceOf(object, null);
    }

    default public Assertion instanceOf(Object object, String string) {
        this._ssfi(Assertion.class, "instanceOf");
        return this.an(object, string);
    }

    default public Assertion getInclude() {
        return this.self().getInclude();
    }

    default public Assertion getIncludes() {
        return this.getInclude();
    }

    default public Assertion getContain() {
        return this.getInclude();
    }

    default public Assertion getContains() {
        return this.getInclude();
    }

    default public Assertion include(Object object) {
        return this.include(object, null);
    }

    default public Assertion include(Object object, String string) {
        this._ssfi(Assertion.class, "include");
        return this.self().include(object, string);
    }

    default public Assertion includes(Object object) {
        return this.includes(object, null);
    }

    default public Assertion includes(Object object, String string) {
        this._ssfi(Assertion.class, "includes");
        return this.include(object, string);
    }

    default public Assertion contain(Object object) {
        return this.contain(object, null);
    }

    default public Assertion contain(Object object, String string) {
        this._ssfi(Assertion.class, "contain");
        return this.include(object, string);
    }

    default public Assertion contains(Object object) {
        return this.contains(object, null);
    }

    default public Assertion contains(Object object, String string) {
        this._ssfi(Assertion.class, "contains");
        return this.include(object, string);
    }

    default public Assertion getOk() {
        this._ssfi(Assertion.class, "getOk");
        return this.self().getOk();
    }

    default public Assertion getTRUE() {
        this._ssfi(Assertion.class, "getTRUE");
        return this.self().getTRUE();
    }

    default public Assertion getFALSE() {
        this._ssfi(Assertion.class, "getFALSE");
        return this.self().getFALSE();
    }

    default public Assertion getNULL() {
        this._ssfi(Assertion.class, "getNULL");
        return this.self().getNULL();
    }

    default public Assertion getExists() {
        this._ssfi(Assertion.class, "getExists");
        return this.self().getExists();
    }

    default public Assertion getEmpty() {
        this._ssfi(Assertion.class, "getEmpty");
        return this.self().getExists();
    }

    default public Assertion equal(Object object) {
        return this.equal(object, null);
    }

    default public Assertion equal(Object object, String string) {
        this._ssfi(Assertion.class, "equal");
        return this.self().equal(object, string);
    }

    default public Assertion eq(Object object) {
        return this.eq(object, null);
    }

    default public Assertion eq(Object object, String string) {
        this._ssfi(Assertion.class, "eq");
        return this.equal(object, string);
    }

    default public Assertion eql(Object object) {
        return this.eql(object, null);
    }

    default public Assertion eql(Object object, String string) {
        this._ssfi(Assertion.class, "eql");
        return this.self().eql(object, string);
    }

    default public Assertion eqls(Object object) {
        return this.eqls(object, null);
    }

    default public Assertion eqls(Object object, String string) {
        this._ssfi(Assertion.class, "eqls");
        return this.eql(object, string);
    }

    default public Assertion property(String string) {
        return this.property(string, NO_ARG, null);
    }

    default public Assertion property(String string, Object object) {
        return this.property(string, object, null);
    }

    default public Assertion property(String string, Object object, String string2) {
        this._ssfi(Assertion.class, "property");
        return this.self().property(string, object, string2);
    }

    default public Assertion getLength() {
        return this.getLengthOf();
    }

    default public Assertion getLengthOf() {
        return this.self().getLengthOf();
    }

    default public Assertion length(int n) {
        return this.length(n, null);
    }

    default public Assertion length(int n, String string) {
        this._ssfi(Assertion.class, "length");
        return this.lengthOf(n, string);
    }

    default public Assertion lengthOf(int n) {
        return this.lengthOf(n, null);
    }

    default public Assertion lengthOf(int n, String string) {
        this._ssfi(Assertion.class, "lengthOf");
        return this.self().lengthOf(n, string);
    }

    default public Assertion match(String string) {
        return this.match(string, null);
    }

    default public Assertion match(String string, String string2) {
        this._ssfi(Assertion.class, "match");
        return this.match(Pattern.compile(string), string2);
    }

    default public Assertion match(Pattern pattern) {
        return this.match(pattern, null);
    }

    default public Assertion match(Pattern pattern, String string) {
        this._ssfi(Assertion.class, "match");
        return this.self().match(pattern, string);
    }

    default public Assertion matches(String string) {
        return this.matches(string, null);
    }

    default public Assertion matches(String string, String string2) {
        this._ssfi(Assertion.class, "matches");
        return this.match(string, string2);
    }

    default public Assertion matches(Pattern pattern) {
        return this.matches(pattern, null);
    }

    default public Assertion matches(Pattern pattern, String string) {
        this._ssfi(Assertion.class, "matches");
        return this.match(pattern, string);
    }

    public static final class Notifications {
        public static final Notifier NOTIFIER = Notifier.instance("de.qfs.lib.assertions.Assertion.Notifications");
        public static final int POST_LEVEL = 1;
        @NotificationName
        public static final String ASSERTION_MADE = "de.qfs.lib.assertions.Assertion.Notifications.assertion made";
        @NotificationName
        public static final String ERROR_THROWN = "de.qfs.lib.assertions.Assertion.Notifications.error thrown";
        static final String SKIP_NOTIFICATION_FLAG = "skipNotification";
    }
}

