/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.assertions;

import de.qfs.lib.assertions.Assertion;
import de.qfs.lib.assertions.BaseAssertion;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonWriter;
import de.qfs.lib.json.WriterConfig;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public class AssertionUtil {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.assertions.AssertionUtil");
    static final SimpleDateFormat ISO_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static Set nonTransferredFags;
    private static Map<Class<?>, Object> openedClasses;

    public static Object flag(Assertion assertion, String string) {
        return assertion.flag(string);
    }

    public static boolean flagAsBoolean(Assertion assertion, String string) {
        return Boolean.TRUE.equals(assertion.flag(string));
    }

    public static String flagAsString(Assertion assertion, String string) {
        return (String)assertion.flag(string);
    }

    public static boolean test(Assertion assertion, BooleanSupplier booleanSupplier) {
        boolean bl = AssertionUtil.flagAsBoolean(assertion, "negate");
        boolean bl2 = booleanSupplier.getAsBoolean();
        return bl ? !bl2 : bl2;
    }

    public static String getMessage(Assertion assertion, Object object, Object object2, Object object3, Object object4) {
        Object object5 = AssertionUtil.flag(assertion, "object");
        object4 = AssertionUtil.getActual(assertion, object4);
        Object object6 = AssertionUtil.flag(assertion, "message");
        String string = AssertionUtil.getEffectiveMessage(assertion, object, object2).replaceAll("#\\{this}", Matcher.quoteReplacement(AssertionUtil.objDisplay(object5))).replaceAll("#\\{act}", Matcher.quoteReplacement(AssertionUtil.objDisplay(object4))).replaceAll("#\\{exp}", Matcher.quoteReplacement(AssertionUtil.objDisplay(object3)));
        return Misc.emptyOrNull(object6) ? string : object6 + ": " + string;
    }

    @NonNull
    private static String getEffectiveMessage(Assertion assertion, Object object, Object object2) {
        Object object3;
        boolean bl = AssertionUtil.flagAsBoolean(assertion, "negate");
        Object object4 = object3 = bl ? object2 : object;
        if (object3 instanceof Supplier) {
            object3 = ((Supplier)object3).get();
        }
        if (object3 == null) {
            object3 = "";
        }
        return String.valueOf(object3);
    }

    public static String objDisplay(Object object) {
        String string = AssertionUtil.inspect(object);
        if (object == null) {
            return "null";
        }
        if (object instanceof Date) {
            return AssertionUtil.noQuotes(AssertionUtil.objDisplay(() -> Json.value(ISO_FORMATTER.format((Date)object))));
        }
        if (object instanceof Pattern) {
            return "/" + AssertionUtil.noQuotes(object.toString()) + "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            stringBuilder.append("[");
            for (int i = 0; i < n; ++i) {
                Object object2;
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append((object2 = Array.get(object, i)) == object ? "(this Array)" : AssertionUtil.objDisplay(object2));
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String noQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String inspect(Object object) {
        return Json.value(object).toString(new WriterConfig(){

            @Override
            public JsonWriter createWriter(Writer writer) {
                return new InspectWriter(writer);
            }
        });
    }

    public static Object getActual(Assertion assertion, Object object) {
        return object == null ? AssertionUtil.flag(assertion, "object") : object;
    }

    public static String getOperator(Assertion assertion, Object object, Object object2, Object object3) {
        String string = AssertionUtil.flagAsString(assertion, "operator");
        if (!Misc.emptyOrNull(string)) {
            return string;
        }
        String string2 = AssertionUtil.getEffectiveMessage(assertion, object, object2);
        if (Misc.emptyOrNull(string2)) {
            return null;
        }
        if (string2.contains(" have ")) {
            return null;
        }
        boolean bl = AssertionUtil.isCollectionType(object3);
        if (string2.contains(" not ")) {
            return bl ? "notDeepStrictEqual" : "notStrictEqual";
        }
        return bl ? "deepStrictEqual" : "strictEqual";
    }

    private static boolean isCollectionType(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Collections) {
            return true;
        }
        return object.getClass().isArray();
    }

    public static Object getProperty(@NonNull Object object, @NonNull String string, boolean bl) throws NoSuchFieldException {
        if (object == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        if (object instanceof Map && ((Map)object).containsKey(string)) {
            return ((Map)object).get(string);
        }
        if (object instanceof Set && ((Set)object).contains(string)) {
            return Boolean.TRUE;
        }
        try {
            if (object instanceof Class) {
                return Reflector.get((Class)object, string, true, bl);
            }
            return Reflector.get(object, object.getClass(), string, true, bl);
        }
        catch (Throwable throwable) {
            String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
            for (String string3 : new String[]{string, "get" + string2, "is" + string2}) {
                try {
                    if (object instanceof Class) {
                        return Reflector.call((Class)object, string3, (Class[])null, null, true, bl);
                    }
                    return Reflector.call(object, string3, (Class[])null, null, true, bl);
                }
                catch (Throwable throwable2) {
                }
            }
            throw new NoSuchFieldException("No such field: " + string);
        }
    }

    public static void maybeSetMessage(Assertion assertion, Object object) {
        if (Misc.emptyOrNull(AssertionUtil.flag(assertion, "message"))) {
            assertion.flag("message", object);
        }
    }

    @NonNull
    public static String type(Object object) {
        return object == null ? "null" : object.getClass().getName();
    }

    public static void transferFlags(@NonNull BaseAssertion baseAssertion, @NonNull Assertion assertion, boolean bl) {
        if (baseAssertion == null) {
            throw new IllegalArgumentException("assertion is marked non-null but is null");
        }
        if (assertion == null) {
            throw new IllegalArgumentException("newAssertion is marked non-null but is null");
        }
        baseAssertion.flags.forEach((string, object) -> {
            if (bl || !nonTransferredFags.contains(string)) {
                assertion.flag((String)string, object);
            }
        });
    }

    public static void transferFlags(@NonNull BaseAssertion baseAssertion, @NonNull Assertion assertion) {
        if (baseAssertion == null) {
            throw new IllegalArgumentException("assertion is marked non-null but is null");
        }
        if (assertion == null) {
            throw new IllegalArgumentException("newAssertion is marked non-null but is null");
        }
        AssertionUtil.transferFlags(baseAssertion, assertion, true);
    }

    static LinkedList<Object> parsePath(String string) {
        String string2 = string.replaceAll("([^\\\\])\\[", "$1.[");
        Matcher matcher = Pattern.compile("(\\\\\\.|[^.]+)+").matcher(string2);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (matcher.find()) {
            String string3 = matcher.group(0);
            Matcher matcher2 = Pattern.compile("\\[(\\d+)]").matcher(string3);
            if (matcher2.matches()) {
                linkedList.add(Integer.parseInt(matcher2.group(1)));
                continue;
            }
            linkedList.add(string3.replaceAll("\\\\([.\\[\\]])", "$1"));
        }
        return linkedList;
    }

    public static PathInfo getPathInfo(Object object, String string) {
        boolean bl;
        Object object2;
        LinkedList<Object> linkedList = AssertionUtil.parsePath(string);
        Object object3 = null;
        if (linkedList.size() > 1) {
            try {
                object3 = AssertionUtil.internalGetPathValue(object, linkedList, linkedList.size() - 1);
            }
            catch (IndexOutOfBoundsException | NoSuchFieldException exception) {
                if (AssertionUtil.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getPathInfo(Object,String)", 475).add("ex", exception)).log();
                }
            }
        } else {
            object3 = object;
        }
        Object object4 = linkedList.getLast();
        try {
            if (object3 == null) {
                object2 = null;
                bl = false;
            } else {
                object2 = AssertionUtil.internalGetPathValue(object3, linkedList.subList(linkedList.size() - 1, linkedList.size()), 1);
                bl = true;
            }
        }
        catch (IndexOutOfBoundsException | NoSuchFieldException exception) {
            if (AssertionUtil.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getPathInfo(Object,String)", 493).add("ex", exception)).log();
            }
            object2 = null;
            bl = false;
        }
        return new PathInfo(object3, object4, object2, bl);
    }

    private static Object internalGetPathValue(Object object, List<Object> list, int n) throws NoSuchFieldException, IndexOutOfBoundsException {
        Object object2 = object;
        int n2 = 0;
        for (Object object3 : list) {
            if (object2 != null) {
                if (object3 instanceof Integer) {
                    int n3 = (Integer)object3;
                    if (object2 instanceof List) {
                        object2 = ((List)object2).get(n3);
                    } else if (object2.getClass().isArray()) {
                        object2 = Array.get(object2, n3);
                    } else if (object2 instanceof Collection) {
                        Iterator iterator = ((Collection)object2).iterator();
                        for (int i = 0; i < n3; ++i) {
                            iterator.next();
                        }
                        object2 = iterator.next();
                    } else {
                        object2 = null;
                    }
                } else {
                    object2 = AssertionUtil.getProperty(object2, (String)object3, true);
                }
                if (n2 == n - 1) {
                    return object2;
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean deepEql(Object object, Object object2) {
        return AssertionUtil.deepEql(object, object2, new MemoizeMap());
    }

    private static boolean deepEql(Object object, Object object2, MemoizeMap memoizeMap) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        Boolean bl = AssertionUtil.simpleEqual(object, object2);
        if (bl != null) {
            return bl;
        }
        return AssertionUtil.extensiveDeepEqual(object, object2, memoizeMap);
    }

    private static Boolean simpleEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object.equals(object2)) {
            return true;
        }
        Boolean bl = AssertionUtil.numberEqual(object, object2);
        if (bl != null) {
            return bl;
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return false;
        }
        return null;
    }

    private static Boolean numberEqual(Object object, Object object2) {
        object = AssertionUtil.objectToNumber(object);
        object2 = AssertionUtil.objectToNumber(object2);
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                if (((Double)object).isInfinite()) {
                    return ((Double)object2).isInfinite();
                }
                if (((Double)object2).isInfinite()) {
                    return false;
                }
                if (((Double)object).isNaN()) {
                    return ((Double)object2).isNaN();
                }
                if (((Double)object2).isNaN()) {
                    return false;
                }
            } else if (object2 instanceof Float) {
                if (((Double)object).isInfinite()) {
                    return ((Float)object2).isInfinite();
                }
                if (((Float)object2).isInfinite()) {
                    return false;
                }
                if (((Double)object).isNaN()) {
                    return ((Float)object2).isNaN();
                }
                if (((Float)object2).isNaN()) {
                    return false;
                }
            }
        } else if (object instanceof Float) {
            if (object2 instanceof Float) {
                if (((Float)object).isInfinite()) {
                    return ((Float)object2).isInfinite();
                }
                if (((Float)object2).isInfinite()) {
                    return false;
                }
                if (((Float)object).isNaN()) {
                    return ((Float)object2).isNaN();
                }
                if (((Float)object2).isNaN()) {
                    return false;
                }
            }
        } else if (object2 instanceof Double || object2 instanceof Float) {
            return AssertionUtil.numberEqual(object2, object);
        }
        if (object instanceof Double || object instanceof Float) {
            double d = ((Number)object).doubleValue();
            if (object2 instanceof Double || object2 instanceof Float) {
                if (object instanceof Float || object2 instanceof Float) {
                    return ((Number)object).floatValue() == ((Number)object2).floatValue();
                }
                return d == ((Number)object2).doubleValue();
            }
            if (object2 instanceof Number) {
                long l = ((Number)object).longValue();
                if (d != (double)l) {
                    return false;
                }
                return l == ((Number)object2).longValue();
            }
            return false;
        }
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return ((Number)object).longValue() == ((Number)object2).longValue();
            }
            return false;
        }
        if (object2 instanceof Number) {
            return AssertionUtil.numberEqual(object2, object);
        }
        return null;
    }

    private static Object objectToNumber(Object object) {
        if (object instanceof Number) {
            return object;
        }
        try {
            return Long.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException2) {
                return object;
            }
        }
    }

    private static boolean extensiveDeepEqual(Object object, Object object2, MemoizeMap memoizeMap) {
        Boolean bl = memoizeMap.compare(object, object2);
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = memoizeMap.compare(object2, object);
        if (bl2 != null) {
            return bl2;
        }
        memoizeMap.set(object, object2, true);
        boolean bl3 = AssertionUtil.extensiveDeepEqualByType(object, object2, memoizeMap);
        memoizeMap.set(object, object2, bl3);
        return bl3;
    }

    private static boolean extensiveDeepEqualByType(Object object, Object object2, MemoizeMap memoizeMap) {
        if (object instanceof String) {
            if (object2 instanceof String) {
                return object.equals(object2);
            }
            if (object2 instanceof char[]) {
                return AssertionUtil.deepEql(new String((char[])object2), object, memoizeMap);
            }
            if (object2 instanceof Character || object2 instanceof CharSequence) {
                return AssertionUtil.deepEql(object2.toString(), object, memoizeMap);
            }
            return false;
        }
        if (object instanceof char[]) {
            return AssertionUtil.deepEql(new String((char[])object), object2, memoizeMap);
        }
        if (object instanceof Character || object instanceof CharSequence) {
            return AssertionUtil.deepEql(object.toString(), object2, memoizeMap);
        }
        object = AssertionUtil.arrayToList(object);
        object2 = AssertionUtil.arrayToList(object2);
        if (object instanceof Iterable) {
            if (object2 instanceof Iterable) {
                Iterator iterator = ((Iterable)object).iterator();
                Iterator iterator2 = ((Iterable)object2).iterator();
                while (iterator.hasNext()) {
                    if (!iterator2.hasNext()) {
                        return false;
                    }
                    boolean bl = AssertionUtil.deepEql(iterator.next(), iterator2.next(), memoizeMap);
                    if (bl) continue;
                    return false;
                }
                return !iterator2.hasNext();
            }
            return false;
        }
        Map<Object, Object> map = AssertionUtil.objectToMap(object);
        Map<Object, Object> map2 = AssertionUtil.objectToMap(object2);
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object object3 = entry.getKey();
            if (!map2.containsKey(object3)) {
                return false;
            }
            boolean bl = AssertionUtil.deepEql(entry.getValue(), map2.get(object3), memoizeMap);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static Object arrayToList(Object object) {
        if (!object.getClass().isArray()) {
            return object;
        }
        int n = Array.getLength(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(Array.get(object, i));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Map<Object, Object> objectToMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            AssertionUtil.openModule(clazz);
            for (Field field : clazz.getDeclaredFields()) {
                String string = field.getName();
                if (string.startsWith("this$") || string.endsWith(".this$1") || string.startsWith("_") || string.startsWith("$")) continue;
                boolean bl = field.isAccessible();
                try {
                    if (!bl) {
                        field.setAccessible(true);
                    }
                    hashMap.put(string, field.get(object));
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (AssertionUtil.logger.level < 5) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "objectToMap(Object)", 756).add("Could not access ")).add(string)).add(" of ")).add(object)).log();
                }
                finally {
                    if (!bl) {
                        field.setAccessible(false);
                    }
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void openModule(Class clazz) {
        if (!Misc.IS_JAVA_VERSION_AT_LEAST_9) {
            return;
        }
        Map<Class<?>, Object> map = openedClasses;
        synchronized (map) {
            if (openedClasses.containsKey(clazz)) {
                return;
            }
            openedClasses.put(clazz, null);
        }
        Reflector.openModule(clazz, AssertionUtil.class);
    }

    static {
        ISO_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
        nonTransferredFags = Misc.setOf("object", "ssfi", "lockSsfi", "message");
        openedClasses = new WeakHashMap();
    }

    static class MemoizeMap
    extends WeakHashMap<Object, WeakHashMap<Object, Boolean>> {
        MemoizeMap() {
        }

        public Boolean compare(Object object, Object object2) {
            WeakHashMap weakHashMap = (WeakHashMap)this.get(object);
            if (weakHashMap != null) {
                return (Boolean)weakHashMap.get(object2);
            }
            return null;
        }

        public void set(Object object, Object object2, boolean bl) {
            WeakHashMap<Object, Boolean> weakHashMap = (WeakHashMap<Object, Boolean>)this.get(object);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<Object, Boolean>();
                this.put(object, weakHashMap);
            }
            weakHashMap.put(object2, bl);
        }
    }

    public static class PathInfo {
        final Object parent;
        final Object name;
        final Object value;
        final boolean exists;

        @Generated
        public PathInfo(Object object, Object object2, Object object3, boolean bl) {
            this.parent = object;
            this.name = object2;
            this.value = object3;
            this.exists = bl;
        }

        @Generated
        public Object getParent() {
            return this.parent;
        }

        @Generated
        public Object getName() {
            return this.name;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean isExists() {
            return this.exists;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PathInfo)) {
                return false;
            }
            PathInfo pathInfo = (PathInfo)object;
            if (!pathInfo.canEqual(this)) {
                return false;
            }
            if (this.isExists() != pathInfo.isExists()) {
                return false;
            }
            Object object2 = this.getParent();
            Object object3 = pathInfo.getParent();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            Object object4 = this.getName();
            Object object5 = pathInfo.getName();
            if (object4 == null ? object5 != null : !object4.equals(object5)) {
                return false;
            }
            Object object6 = this.getValue();
            Object object7 = pathInfo.getValue();
            return !(object6 == null ? object7 != null : !object6.equals(object7));
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof PathInfo;
        }

        @Generated
        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isExists() ? 79 : 97);
            Object object = this.getParent();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            Object object2 = this.getName();
            n = n * 59 + (object2 == null ? 43 : object2.hashCode());
            Object object3 = this.getValue();
            n = n * 59 + (object3 == null ? 43 : object3.hashCode());
            return n;
        }

        @Generated
        public String toString() {
            return "AssertionUtil.PathInfo(parent=" + this.getParent() + ", name=" + this.getName() + ", value=" + this.getValue() + ", exists=" + this.isExists() + ")";
        }
    }

    static class InspectWriter
    extends JsonWriter {
        public static final char[] QUOTE_REPLACEMENT = new char[]{'\\', '\''};
        public static final Pattern SIMPLE_KEY_MATCHER = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");

        public InspectWriter(Writer writer) {
            super(writer);
        }

        @Override
        protected void writeString(String string) throws IOException {
            this.writer.write(39);
            this.writeJsonString(string);
            this.writer.write(39);
        }

        @Override
        protected void writeMemberName(String string) throws IOException {
            if (SIMPLE_KEY_MATCHER.matcher(string).matches()) {
                this.writer.write(string);
            } else {
                this.writeString(string);
            }
        }

        @Override
        protected void writeArrayOpen() throws IOException {
            this.writer.write("[ ");
        }

        @Override
        protected void writeArrayClose() throws IOException {
            this.writer.write(" ]");
        }

        @Override
        protected void writeArraySeparator() throws IOException {
            this.writer.write(", ");
        }

        @Override
        protected void writeObjectOpen() throws IOException {
            this.writer.write("{ ");
        }

        @Override
        protected void writeObjectClose() throws IOException {
            this.writer.write(" }");
        }

        @Override
        protected void writeMemberSeparator() throws IOException {
            this.writer.write(": ");
        }

        @Override
        protected void writeObjectSeparator() throws IOException {
            this.writer.write(", ");
        }

        @Override
        protected void writeJsonString(String string) throws IOException {
            int n = string.length();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                char[] cArray = c == '\"' ? null : (c == '\'' ? QUOTE_REPLACEMENT : InspectWriter.getReplacementChars(c));
                if (cArray == null) continue;
                this.writer.write(string, n2, i - n2);
                this.writer.write(cArray);
                n2 = i + 1;
            }
            this.writer.write(string, n2, n - n2);
        }
    }
}

