/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.RegistrationHelper;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;

public class DialogConfigWrapper
extends ConfigWrapper
implements ComponentListener {
    private static Logger logger = new Logger("de.qfs.lib.config.DialogConfigWrapper");
    private static final Logger fsLogger = new Logger("de.qfs.lib.config.ForceSize");
    protected Dialog dialog;
    protected RegistrationHelper regHelper = new RegistrationHelper();

    public DialogConfigWrapper() {
        this.setConfigurableName("dialog");
    }

    @Override
    public void setClient(Object object) {
        if (DialogConfigWrapper.logger.level >= 7) {
            logger.log(7, "setClient(Object)", DialogConfigWrapper.logger.level < 8 ? "" : "client: " + object);
        }
        this.dialog = (Dialog)object;
    }

    @Override
    public Properties getConfigurableState() {
        if (DialogConfigWrapper.logger.level >= 7) {
            logger.log(7, "getConfigurableState()", "");
        }
        Properties properties = new Properties();
        Point point = this.dialog.getLocation();
        Dimension dimension = this.dialog.getSize();
        GraphicsConfiguration graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(point.x, point.y);
        Rectangle rectangle = null;
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            properties.put("gcx", "" + rectangle.x);
            properties.put("gcy", "" + rectangle.y);
        }
        properties.put("x", "" + point.x);
        properties.put("y", "" + point.y);
        properties.put("width", "" + dimension.width);
        properties.put("height", "" + dimension.height);
        if (DialogConfigWrapper.logger.level >= 9) {
            logger.log(9, "getConfigurableState()", "state: " + properties);
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        if (DialogConfigWrapper.logger.level >= 7) {
            logger.log(7, "setConfigurableState(Properties)", DialogConfigWrapper.logger.level < 8 ? "" : "state: " + properties);
        }
        String string = properties.getProperty("x");
        String string2 = properties.getProperty("y");
        String string3 = properties.getProperty("width");
        String string4 = properties.getProperty("height");
        String string5 = properties.getProperty("gcx");
        String string6 = properties.getProperty("gcy");
        if (DialogConfigWrapper.logger.level >= 9) {
            logger.log(9, "setConfigurableState(Properties)", "x: " + string + ", y: " + string2 + ", width: " + string3 + ", height: " + string4 + ", gcx: " + string5 + ", gcy: " + string6);
        }
        if (string == null || string2 == null || string3 == null || string4 == null) {
            if (DialogConfigWrapper.logger.level >= 3) {
                logger.log(3, "setConfigurableState(Properties)", "Invalid state: x: " + string + ", y: " + string2 + ", width: " + string3 + ", height: " + string4);
            }
            return;
        }
        GraphicsConfiguration graphicsConfiguration = null;
        try {
            if (string5 != null && string6 != null) {
                graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(Integer.parseInt(string5), Integer.parseInt(string6));
                if (DialogConfigWrapper.logger.level >= 9) {
                    logger.build("setConfigurableState(Properties)").add("gc: ").add(graphicsConfiguration).add(", bounds: ").add(graphicsConfiguration.getBounds()).log(9);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(3, "setConfigurableState(Properties)", numberFormatException);
        }
        try {
            Dimension dimension = new Dimension(Integer.parseInt(string3), Integer.parseInt(string4));
            Point point = new Point(Integer.parseInt(string), Integer.parseInt(string2));
            if (graphicsConfiguration != null) {
                Rectangle rectangle = graphicsConfiguration.getBounds();
                point.x += rectangle.x;
                point.y += rectangle.y;
            } else {
                graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(point.x, point.y);
            }
            point = SwingUtil.getLocationInsideGraphicsConfiguration(new Rectangle(point.x, point.y, dimension.width, dimension.height), graphicsConfiguration);
            if (DialogConfigWrapper.logger.level >= 9) {
                logger.build("setConfigurableState(Properties)").add("constrained pos: ").add(point).log(9);
            }
            this.dialog.addWindowListener(new ForceSize(point, dimension));
            this.restore(dimension, point);
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(3, "setConfigurableState(Properties)", numberFormatException);
        }
    }

    @Override
    public final void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (DialogConfigWrapper.logger.level >= 7) {
            Logger.Builder builder = logger.build("registrationChanged(Configuration,String,boolean,boolean)");
            (DialogConfigWrapper.logger.level < 8 ? builder : builder.add("config: ").add(configuration).add(", name: ").add(string).add(", registered: ").add(bl).add(", valuesKept: ").add(bl2)).log(7);
        }
        int n = this.regHelper.registrationChanged(configuration, bl);
        if (DialogConfigWrapper.logger.level >= 9) {
            logger.build("registrationChanged(Configuration,String,boolean,boolean)").add("ret: ").add(n).log(9);
        }
        this.registrationChanged(configuration, string, bl, bl2, n);
    }

    protected void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2, int n) {
        if (DialogConfigWrapper.logger.level >= 7) {
            Logger.Builder builder = logger.build("registrationChanged(Configuration,String,boolean,boolean,int)");
            (DialogConfigWrapper.logger.level < 8 ? builder : builder.add("config: ").add(configuration).add(", name: ").add(string).add(", registered: ").add(bl).add(", valuesKept: ").add(bl2).add(", helperState: ").add(n)).log(7);
        }
        if (this.dialog != null) {
            if (n == 1) {
                this.dialog.removeComponentListener(this);
                this.dialog.addComponentListener(this);
            } else if (n == -1) {
                this.dialog.removeComponentListener(this);
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (DialogConfigWrapper.logger.level >= 7) {
            Logger.Builder builder = logger.build("componentMoved(ComponentEvent)");
            (DialogConfigWrapper.logger.level < 8 ? builder : builder.add("e: ").add(componentEvent)).log(7);
        }
        this.regHelper.stateChanged(this);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (DialogConfigWrapper.logger.level >= 7) {
            Logger.Builder builder = logger.build("componentResized(ComponentEvent)");
            (DialogConfigWrapper.logger.level < 8 ? builder : builder.add("e: ").add(componentEvent)).log(7);
        }
        this.regHelper.stateChanged(this);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    protected void restore(Dimension dimension, Point point) {
        if (DialogConfigWrapper.logger.level >= 7) {
            logger.log(7, "restore(Dimension,Point)", DialogConfigWrapper.logger.level < 8 ? "" : "size: " + dimension + ", location: " + point);
        }
        this.dialog.setLocation(point);
        this.dialog.pack();
        this.dialog.setSize(dimension);
        this.dialog.validate();
    }

    private class ForceSize
    extends WindowAdapter {
        private Point location;
        private Dimension size;

        public ForceSize(Point point, Dimension dimension) {
            if (fsLogger.level >= 7) {
                fsLogger.log(7, "ForceSize(Point,Dimension)", fsLogger.level < 8 ? "" : "location: " + point + ", size: " + dimension);
            }
            this.location = point;
            this.size = dimension;
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (fsLogger.level >= 7) {
                fsLogger.log(7, "windowOpened(WindowEvent)", "");
            }
            Dimension dimension = DialogConfigWrapper.this.dialog.getSize();
            Point point = DialogConfigWrapper.this.dialog.getLocation();
            if (!dimension.equals(this.size)) {
                if (fsLogger.level >= 9) {
                    fsLogger.log(9, "windowOpened(WindowEvent)", "Size mismatch: " + dimension);
                }
                DialogConfigWrapper.this.dialog.setSize(this.size);
                dimension = DialogConfigWrapper.this.dialog.getSize();
                if (!dimension.equals(this.size)) {
                    if (fsLogger.level >= 9) {
                        fsLogger.log(9, "windowOpened(WindowEvent)", "Still size mismatch: " + dimension);
                    }
                    DialogConfigWrapper.this.dialog.setSize(2 * this.size.width - dimension.width, 2 * this.size.height - dimension.height);
                }
            }
            if (!point.equals(this.location)) {
                if (fsLogger.level >= 9) {
                    fsLogger.log(9, "windowOpened(WindowEvent)", "Position mismatch: " + point);
                }
                DialogConfigWrapper.this.dialog.setLocation(this.location);
                point = DialogConfigWrapper.this.dialog.getLocation();
                if (!point.equals(this.location)) {
                    if (fsLogger.level >= 9) {
                        fsLogger.log(9, "windowOpened(WindowEvent)", "Still position mismatch: " + point);
                    }
                    DialogConfigWrapper.this.dialog.setLocation(2 * this.location.x - point.x, 2 * this.location.y - point.y);
                }
            }
            DialogConfigWrapper.this.dialog.removeWindowListener(this);
        }
    }
}

