/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.RegistrationHelper;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.Properties;
import javax.swing.SwingUtilities;
import lombok.Generated;

public class FrameConfigWrapper
extends ConfigWrapper
implements ComponentListener,
WindowStateListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.FrameConfigWrapper");
    private static final Logger fsLogger = new Logger("de.qfs.lib.config.ForceSize");
    private static final long MIN_DELAY = 450L;
    protected Frame frame;
    private long lastSet = 0L;
    private int maximized = -1;
    private Rectangle normalState = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    protected RegistrationHelper regHelper = new RegistrationHelper();

    public FrameConfigWrapper() {
        if (FrameConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "FrameConfigWrapper()", 111).log();
        }
        this.setConfigurableName("frame");
    }

    @Override
    protected void setClient(Object object) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setClient(Object)", 126).addDetail("client", object)).log();
        }
        this.frame = (Frame)object;
    }

    @Override
    public Properties getConfigurableState() {
        if (FrameConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getConfigurableState()", 142).log();
        }
        Properties properties = new Properties();
        Point point = this.frame.getLocation();
        GraphicsConfiguration graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(point.x, point.y);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            properties.put("gcx", "" + rectangle.x);
            properties.put("gcy", "" + rectangle.y);
        }
        if (this.normalState.x == Integer.MIN_VALUE) {
            properties.put("x", "" + (point.x - rectangle.x));
            properties.put("y", "" + (point.y - rectangle.y));
        } else {
            properties.put("x", "" + (this.normalState.x - rectangle.x));
            properties.put("y", "" + (this.normalState.y - rectangle.y));
        }
        if (this.normalState.width == Integer.MIN_VALUE) {
            Dimension dimension = this.frame.getSize();
            properties.put("width", "" + dimension.width);
            properties.put("height", "" + dimension.height);
        } else {
            properties.put("width", "" + this.normalState.width);
            properties.put("height", "" + this.normalState.height);
        }
        properties.put("maximized", "" + (this.frame.getExtendedState() & 6));
        if (FrameConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getConfigurableState()", 170).add("state", properties)).log();
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        block25: {
            GraphicsConfiguration graphicsConfiguration;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            block24: {
                if (FrameConfigWrapper.logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableState(Properties)", 181).addDetail("state", properties)).log();
                }
                String string6 = properties.getProperty("gcx");
                String string7 = properties.getProperty("gcy");
                string5 = properties.getProperty("x");
                string4 = properties.getProperty("y");
                string3 = properties.getProperty("width");
                string2 = properties.getProperty("height");
                string = properties.getProperty("maximized");
                if (FrameConfigWrapper.logger.level >= 7) {
                    logger.dumpStack(7, "setConfigurableState(Properties)", "x: " + string5 + ", y: " + string4 + ", width: " + string3 + ", height: " + string2 + ", max: " + string + ", gcx: " + string6 + ", gcy: " + string7);
                }
                if (string5 == null || string4 == null || string3 == null || string2 == null) {
                    if (FrameConfigWrapper.logger.level >= 3) {
                        logger.log(5, "setConfigurableState(Properties)", "Invalid state: x: " + string5 + ", y: " + string4 + ", width: " + string3 + ", height: " + string2);
                    }
                    return;
                }
                graphicsConfiguration = null;
                try {
                    if (string6 != null && string7 != null) {
                        graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(Integer.parseInt(string6), Integer.parseInt(string7));
                        if (FrameConfigWrapper.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 212).add("gc", graphicsConfiguration)).add(", bounds: ")).add("gc.getBounds()", graphicsConfiguration.getBounds())).log();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (FrameConfigWrapper.logger.level < 3) break block24;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 215).add("ex", numberFormatException)).log();
                }
            }
            this.lastSet = System.currentTimeMillis();
            if (FrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 219).add("Timestamp lastSet: ")).add(this.lastSet)).log();
            }
            try {
                Dimension dimension = new Dimension(Integer.parseInt(string3), Integer.parseInt(string2));
                Point point = new Point(Integer.parseInt(string5), Integer.parseInt(string4));
                if (graphicsConfiguration != null) {
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    point.x += rectangle.x;
                    point.y += rectangle.y;
                } else {
                    graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(point.x, point.y);
                }
                point = SwingUtil.getLocationInsideGraphicsConfiguration(new Rectangle(point.x, point.y, dimension.width, dimension.height), graphicsConfiguration);
                this.normalState.x = point.x;
                this.normalState.y = point.y;
                this.normalState.width = dimension.width;
                this.normalState.height = dimension.height;
                int n = 0;
                if (string != null) {
                    n = Integer.parseInt(string);
                    this.maximized = n & 6;
                } else {
                    this.maximized = -1;
                }
                int n2 = this.frame.getExtendedState();
                if (FrameConfigWrapper.logger.level >= 8) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "setConfigurableState(Properties)", 250).add("expanded: x: ")).add(this.normalState.x)).add(", y: ")).add(this.normalState.y)).add(", width: ")).add(this.normalState.width)).add(", height: ")).add(this.normalState.height)).add(", maximized: ")).add(this.maximized)).add(", fstate: ")).add(n2)).add(", flags: ")).add(n)).log();
                }
                this.frame.setLocation(this.normalState.x, this.normalState.y);
                this.frame.setSize(this.normalState.width, this.normalState.height);
                if (FrameConfigWrapper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 258).add("frame.getLocation()", this.frame.getLocation())).log();
                }
                if (FrameConfigWrapper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 259).add("frame.getSize()", this.frame.getSize())).log();
                }
                if (n == 6) {
                    if ((n2 & 6) == 2) {
                        if ((this.frame.getExtendedState() & 6) != 6) {
                            final int n3 = n2 | 6;
                            final int n4 = this.frame.getSize().height;
                            this.frame.setExtendedState(n3);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (logger.level >= 7) {
                                        logger.lvlBuild(7, "setConfigurableState(Properties).Runnable.run()", 270).log();
                                    }
                                    if (FrameConfigWrapper.this.frame.getSize().height <= n4) {
                                        if (logger.level >= 8) {
                                            ((LevelAwareLogBuilder)logger.lvlBuild(8, "setConfigurableState(Properties).Runnable.run()", 272).add("Need to adjust max both state once again.")).log();
                                        }
                                        FrameConfigWrapper.this.frame.setExtendedState(n3 & 0xFFFFFFF9);
                                        FrameConfigWrapper.this.frame.setExtendedState(n3);
                                    }
                                }
                            });
                        } else {
                            this.frame.setExtendedState(n2 & 0xFFFFFFF9 | n);
                        }
                    } else {
                        this.frame.setExtendedState(n2 | 6);
                    }
                } else {
                    this.frame.setExtendedState(n2 & 0xFFFFFFF9 | n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (FrameConfigWrapper.logger.level < 3) break block25;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 292).add("ex", numberFormatException)).log();
            }
        }
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registrationChanged(Configuration,String,boolean,boolean)", 313).addDetail("config", configuration)).addDetail("name", string)).addDetail("registered", bl)).addDetail("valuesKept", bl2)).log();
        }
        int n = this.regHelper.registrationChanged(configuration, bl);
        if (this.frame != null) {
            if (n == 1) {
                this.frame.addComponentListener(this);
                this.frame.addWindowStateListener(this);
            } else if (n == -1) {
                this.frame.removeComponentListener(this);
                this.frame.removeWindowStateListener(this);
            }
        }
    }

    @Override
    public void windowStateChanged(WindowEvent windowEvent) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "windowStateChanged(WindowEvent)", 342).addDetail("e", windowEvent)).log();
        }
        if (System.currentTimeMillis() - this.lastSet < 450L) {
            if (FrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "windowStateChanged(WindowEvent)", 345).add("Too early")).log();
            }
            return;
        }
        int n = this.maximized;
        this.maximized = windowEvent.getNewState() & 6;
        if (FrameConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "windowStateChanged(WindowEvent)", 351).add("maximized", this.maximized)).log();
        }
        if (n == 6 && this.maximized == 2) {
            if (FrameConfigWrapper.logger.level >= 8) {
                ((LevelAwareLogBuilder)logger.lvlBuild(8, "windowStateChanged(WindowEvent)", 354).add("expanded: Don't store maximized state as to be fixed with following resize event.")).log();
            }
            return;
        }
        if (this.maximized != n) {
            Configuration.instance().stateChanged(this);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentMoved(ComponentEvent)", 376).addDetail("e", componentEvent)).log();
        }
        if (System.currentTimeMillis() - this.lastSet < 450L) {
            if (FrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "componentMoved(ComponentEvent)", 379).add("Too early")).log();
            }
            return;
        }
        Point point = this.frame.getLocation();
        if (!(point.x != point.y || point.x <= -10 || point.x > 0 || this.normalState.x <= 10 && this.normalState.x >= -10 || this.normalState.y <= 10 && this.normalState.y >= -10)) {
            if (FrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "componentMoved(ComponentEvent)", 388).add("Ignore moved events to origin when result of a hopp because of maximisation.")).log();
            }
            return;
        }
        this.maximized = this.frame.getExtendedState() & 6;
        if (FrameConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "componentMoved(ComponentEvent)", 395).add("pos", point)).log();
        }
        if ((this.maximized & 2) == 0) {
            this.normalState.x = point.x;
        }
        if ((this.maximized & 4) == 0) {
            this.normalState.y = point.y;
        }
        Configuration.instance().stateChanged(this);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentResized(ComponentEvent)", 417).addDetail("e", componentEvent)).log();
        }
        Dimension dimension = this.frame.getSize();
        if (FrameConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "componentResized(ComponentEvent)", 420).add("size", dimension)).log();
        }
        if (System.currentTimeMillis() - this.lastSet < 450L) {
            if (FrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "componentResized(ComponentEvent)", 423).add("Too early")).log();
            }
            return;
        }
        this.maximized = this.frame.getExtendedState() & 6;
        if (FrameConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "componentResized(ComponentEvent)", 428).add("maximized", this.maximized)).log();
        }
        if ((this.maximized & 2) == 0) {
            this.normalState.width = dimension.width;
        }
        if ((this.maximized & 4) == 0) {
            this.normalState.height = dimension.height;
        }
        Configuration.instance().stateChanged(this);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentHidden(ComponentEvent)", 447).addDetail("e", componentEvent)).log();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentShown(ComponentEvent)", 460).addDetail("e", componentEvent)).log();
        }
    }

    protected void restore(Dimension dimension, Point point) {
        if (FrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "restore(Dimension,Point)", 477).addDetail("size", dimension)).addDetail("location", point)).log();
        }
        this.frame.setLocation(point);
        this.frame.pack();
        this.frame.setSize(dimension);
        this.frame.validate();
    }

    private class ForceSize
    extends WindowAdapter {
        private Point location;
        private Dimension size;

        public ForceSize(Point point, Dimension dimension) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ForceSize.ForceSize(Point,Dimension)", 521).addDetail("location", point)).addDetail("size", dimension)).log();
            }
            if (fsLogger.level >= 7) {
                fsLogger.log(7, "ForceSize(Point,Dimension)", fsLogger.level < 8 ? "" : "location: " + point + ", size: " + dimension);
            }
            this.location = point;
            this.size = dimension;
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ForceSize.windowOpened(WindowEvent)", 543).addDetail("e", windowEvent)).log();
            }
            if (fsLogger.level >= 7) {
                fsLogger.log(7, "windowOpened(WindowEvent)", "");
            }
            Dimension dimension = FrameConfigWrapper.this.frame.getSize();
            Point point = FrameConfigWrapper.this.frame.getLocation();
            if (!dimension.equals(this.size)) {
                if (fsLogger.level >= 9) {
                    fsLogger.log(9, "windowOpened(WindowEvent)", "Size mismatch: " + dimension);
                }
                FrameConfigWrapper.this.frame.setSize(this.size);
                dimension = FrameConfigWrapper.this.frame.getSize();
                if (!dimension.equals(this.size)) {
                    if (fsLogger.level >= 9) {
                        fsLogger.log(9, "windowOpened(WindowEvent)", "Still size mismatch: " + dimension);
                    }
                    FrameConfigWrapper.this.frame.setSize(2 * this.size.width - dimension.width, 2 * this.size.height - dimension.height);
                }
            }
            if (!point.equals(this.location)) {
                if (fsLogger.level >= 9) {
                    fsLogger.log(9, "windowOpened(WindowEvent)", "Position mismatch: " + point);
                }
                FrameConfigWrapper.this.frame.setLocation(this.location);
                point = FrameConfigWrapper.this.frame.getLocation();
                if (!point.equals(this.location)) {
                    if (fsLogger.level >= 9) {
                        fsLogger.log(9, "windowOpened(WindowEvent)", "Still position mismatch: " + point);
                    }
                    FrameConfigWrapper.this.frame.setLocation(2 * this.location.x - point.x, 2 * this.location.y - point.y);
                }
            }
            FrameConfigWrapper.this.frame.removeWindowListener(this);
        }
    }
}

