/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.RegistrationHelper;
import de.qfs.lib.gui.EventQueueMark;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.JSplitPane;
import lombok.Generated;

public class JSplitPaneConfigWrapper
extends ConfigWrapper
implements PropertyChangeListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.JSplitPaneConfigWrapper");
    protected JSplitPane pane;
    protected boolean registered;
    private int targetLocation = -1;
    private double relTargetLocation = -1.0;
    private boolean override = true;
    private RegistrationHelper regHelper = new RegistrationHelper();
    private EventQueueMark mark = new EventQueueMark();

    public JSplitPaneConfigWrapper() {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "JSplitPaneConfigWrapper()", 108).log();
        }
        this.setConfigurableName("splitpane");
    }

    public JSplitPaneConfigWrapper(JSplitPane jSplitPane, String string, int n) {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "JSplitPaneConfigWrapper(JSplitPane,String,int)", 122).addDetail("client", jSplitPane)).addDetail("name", string)).addDetail("defaultLocation", n)).log();
        }
        this.setConfigurableName(string);
        this.targetLocation = n;
        if (JSplitPaneConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "JSplitPaneConfigWrapper(JSplitPane,String,int)", 127).add("Setting defaultLocation: ")).add(n)).add(", myName: ")).add(string)).log();
        }
        this.mark.activate(300);
        jSplitPane.setDividerLocation(n);
        jSplitPane.addComponentListener(new SizeListener());
        this.setClient(jSplitPane);
    }

    public JSplitPaneConfigWrapper(JSplitPane jSplitPane, String string, double d) {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "JSplitPaneConfigWrapper(JSplitPane,String,double)", 144).addDetail("client", jSplitPane)).addDetail("name", string)).addDetail("relDefaultLocation", d)).log();
        }
        this.setConfigurableName(string);
        this.relTargetLocation = d;
        if (JSplitPaneConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "JSplitPaneConfigWrapper(JSplitPane,String,double)", 149).add("Setting relTargetLocation: ")).add(d)).add(", myName: ")).add(string)).log();
        }
        this.mark.activate(300);
        if (d >= 0.0 && d <= 1.0) {
            jSplitPane.setDividerLocation(d);
        }
        jSplitPane.addComponentListener(new SizeListener());
        this.setClient(jSplitPane);
    }

    @Override
    protected void setClient(Object object) {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setClient(Object)", 169).addDetail("client", object)).log();
        }
        if (JSplitPaneConfigWrapper.logger.level >= 8) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "setClient(Object)", 171).add("myName: ")).add(this.getConfigurableName())).log();
        }
        this.pane = (JSplitPane)object;
        this.pane.addPropertyChangeListener(this);
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "setClient(Object).Runnable.run()", 176).log();
                }
                JSplitPaneConfigWrapper.this.removeCanvas();
            }
        });
    }

    @Override
    public Properties getConfigurableState() {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getConfigurableState()", 193).log();
        }
        if (JSplitPaneConfigWrapper.logger.level >= 8) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "getConfigurableState()", 195).add("myName: ")).add(this.getConfigurableName())).log();
        }
        Properties properties = new Properties();
        if (this.targetLocation < 0 && this.relTargetLocation >= 0.0) {
            properties.put("divider", "" + this.relTargetLocation);
        } else if (this.targetLocation >= 0) {
            properties.put("divider", "" + this.targetLocation);
        } else {
            properties.put("divider", "" + this.pane.getDividerLocation());
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        block9: {
            if (JSplitPaneConfigWrapper.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableState(Properties)", 214).addDetail("state", properties)).log();
            }
            if (JSplitPaneConfigWrapper.logger.level >= 8) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "setConfigurableState(Properties)", 216).add("myName: ")).add(this.getConfigurableName())).log();
            }
            String string = properties.getProperty("divider");
            if (JSplitPaneConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 219).add("pos", string)).log();
            }
            if (string == null) {
                if (JSplitPaneConfigWrapper.logger.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 221).add("Invalid state: divider: ")).add(string)).log();
                }
                return;
            }
            try {
                this.targetLocation = Integer.parseInt(string);
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (logger.level >= 7) {
                            logger.lvlBuild(7, "setConfigurableState(Properties).Runnable.run()", 229).log();
                        }
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties).Runnable.run()", 230).add("Setting targetLocation: ")).add(JSplitPaneConfigWrapper.this.targetLocation)).add(", myName: ")).add(JSplitPaneConfigWrapper.this.getConfigurableName())).log();
                        }
                        JSplitPaneConfigWrapper.this.mark.activate(300);
                        JSplitPaneConfigWrapper.this.pane.setDividerLocation(JSplitPaneConfigWrapper.this.targetLocation);
                        JSplitPaneConfigWrapper.this.removeCanvas();
                    }
                });
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.relTargetLocation = Double.valueOf(string);
                    SwingUtil.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (logger.level >= 7) {
                                logger.lvlBuild(7, "setConfigurableState(Properties).Runnable.run()", 243).log();
                            }
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties).Runnable.run()", 244).add("Setting relTargetLocation: ")).add(JSplitPaneConfigWrapper.this.relTargetLocation)).add(", myName: ")).add(JSplitPaneConfigWrapper.this.getConfigurableName())).log();
                            }
                            JSplitPaneConfigWrapper.this.mark.activate(300);
                            if (JSplitPaneConfigWrapper.this.relTargetLocation >= 0.0 && JSplitPaneConfigWrapper.this.relTargetLocation <= 1.0) {
                                JSplitPaneConfigWrapper.this.pane.setDividerLocation(JSplitPaneConfigWrapper.this.relTargetLocation);
                            }
                        }
                    });
                }
                catch (NumberFormatException numberFormatException2) {
                    if (JSplitPaneConfigWrapper.logger.level < 3) break block9;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 254).add("ex2", numberFormatException2)).log();
                }
            }
        }
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registrationChanged(Configuration,String,boolean,boolean)", 277).addDetail("config", configuration)).addDetail("name", string)).addDetail("registered", bl)).addDetail("valuesKept", bl2)).log();
        }
        this.regHelper.registrationChanged(configuration, bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "propertyChange(PropertyChangeEvent)", 297).addDetail("e", propertyChangeEvent)).log();
        }
        if (JSplitPaneConfigWrapper.logger.level >= 8) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "propertyChange(PropertyChangeEvent)", 299).add("myName: ")).add(this.getConfigurableName())).add(", propertyName: ")).add(propertyChangeEvent.getPropertyName())).log();
        }
        if (propertyChangeEvent.getPropertyName().endsWith("ividerLocation")) {
            if (!this.pane.isShowing() && (this.targetLocation >= 0 || this.relTargetLocation >= 0.0)) {
                if (this.targetLocation >= 0) {
                    if (JSplitPaneConfigWrapper.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "propertyChange(PropertyChangeEvent)", 305).add("Setting targetLocation: ")).add(this.targetLocation)).add(", myName: ")).add(this.getConfigurableName())).log();
                    }
                    if (this.override) {
                        this.pane.setDividerLocation(this.targetLocation);
                        this.override = false;
                    }
                } else {
                    if (JSplitPaneConfigWrapper.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "propertyChange(PropertyChangeEvent)", 313).add("Setting relTargetLocation: ")).add(this.relTargetLocation)).add(", myName: ")).add(this.getConfigurableName())).log();
                    }
                    if (this.override) {
                        if (this.relTargetLocation <= 1.0) {
                            this.pane.setDividerLocation(this.relTargetLocation);
                        }
                        this.override = false;
                    }
                }
            } else if (!this.mark.isActive()) {
                this.targetLocation = this.pane.getDividerLocation();
                if (JSplitPaneConfigWrapper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "propertyChange(PropertyChangeEvent)", 325).add("divider: ")).add(this.targetLocation)).log();
                }
                if (this.registered) {
                    this.regHelper.stateChanged(this);
                }
            } else if (JSplitPaneConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "propertyChange(PropertyChangeEvent)", 330).add("Mark active")).log();
            }
            this.removeCanvas();
        }
    }

    private void removeCanvas() {
        if (JSplitPaneConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "removeCanvas()", 402).log();
        }
        if (this.pane != null && Boolean.getBoolean("de.qfs.lib.FixSplitPaneCanvas") && this.pane.getToolkit().getClass().getName().indexOf(".motif.") > 0) {
            Component[] componentArray = this.pane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i].getClass().getName().indexOf(".BasicSplitPaneUI$") <= 0) continue;
                this.pane.remove(componentArray[i]);
            }
        }
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SizeListener.SizeListener()", 347).log();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "SizeListener.componentResized(ComponentEvent)", 358).addDetail("e", componentEvent)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "SizeListener.componentResized(ComponentEvent)", 360).add("myName: ")).add(JSplitPaneConfigWrapper.this.getConfigurableName())).add(", targetLocation: ")).add(JSplitPaneConfigWrapper.this.targetLocation)).log();
            }
            if (JSplitPaneConfigWrapper.this.targetLocation >= 0) {
                if (JSplitPaneConfigWrapper.this.pane.getDividerLocation() != JSplitPaneConfigWrapper.this.targetLocation) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "SizeListener.componentResized(ComponentEvent)", 364).add("setting targetLocation: ")).add(JSplitPaneConfigWrapper.this.targetLocation)).add(", myName: ")).add(JSplitPaneConfigWrapper.this.getConfigurableName())).log();
                    }
                    JSplitPaneConfigWrapper.this.mark.activate(300);
                    JSplitPaneConfigWrapper.this.pane.setDividerLocation(JSplitPaneConfigWrapper.this.targetLocation);
                }
            } else {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "SizeListener.componentResized(ComponentEvent)", 371).add("setting relTargetLocation: ")).add(JSplitPaneConfigWrapper.this.relTargetLocation)).add(", myName: ")).add(JSplitPaneConfigWrapper.this.getConfigurableName())).log();
                }
                JSplitPaneConfigWrapper.this.mark.activate(300);
                if (JSplitPaneConfigWrapper.this.relTargetLocation >= 0.0 && JSplitPaneConfigWrapper.this.relTargetLocation <= 1.0) {
                    JSplitPaneConfigWrapper.this.pane.setDividerLocation(JSplitPaneConfigWrapper.this.relTargetLocation);
                }
            }
        }
    }
}

