/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.DialogConfigWrapper;
import de.qfs.lib.gui.EventQueueMark;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.util.Properties;
import lombok.Generated;

public class RelativeDialogConfigWrapper
extends DialogConfigWrapper {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.RelativeDialogConfigWrapper");
    protected Window master;
    protected Point location;
    protected String reference;
    protected EventQueueMark mark;
    protected boolean constrain;
    protected boolean storeSize;
    protected boolean forceMinSize;
    protected boolean waitForMaster = true;

    public RelativeDialogConfigWrapper(Dialog dialog, String string, boolean bl, boolean bl2) {
        this(dialog, string, bl, bl2, true);
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RelativeDialogConfigWrapper(Dialog,String,boolean,boolean)", 114).addDetail("dialog", dialog)).addDetail("name", string)).addDetail("constrain", bl)).addDetail("storeSize", bl2)).log();
        }
    }

    public RelativeDialogConfigWrapper(Dialog dialog, String string, boolean bl, boolean bl2, boolean bl3) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RelativeDialogConfigWrapper(Dialog,String,boolean,boolean,boolean)", 126).addDetail("dialog", dialog)).addDetail("name", string)).addDetail("constrain", bl)).addDetail("storeSize", bl2)).addDetail("forceMinSize", bl3)).log();
        }
        this.dialog = dialog;
        this.constrain = bl;
        this.storeSize = bl2;
        this.forceMinSize = bl3;
        this.setConfigurableName(string);
        this.getLocation();
    }

    public final Window getMaster() {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getMaster()", 149).log();
        }
        return this.master;
    }

    public void setMaster(Window window) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMaster(Window)", 162).addDetail("window", window)).log();
        }
        if (this.master != null) {
            this.master.removeComponentListener(this);
        }
        this.master = window;
        if (this.master != null) {
            this.master.removeComponentListener(this);
            this.master.addComponentListener(this);
        }
        if (this.master == null || "Absolute".equalsIgnoreCase(this.reference)) {
            this.getLocation();
            this.regHelper.stateChanged(this);
        } else {
            this.setLocation(this.dialog.getSize());
        }
    }

    public final boolean isForceMinSize() {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "isForceMinSize()", 188).log();
        }
        return this.forceMinSize;
    }

    public final void setForceMinSize(boolean bl) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setForceMinSize(boolean)", 201).addDetail("forceMinSize", bl)).log();
        }
        this.forceMinSize = bl;
    }

    public final boolean isWaitForMaster() {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "isWaitForMaster()", 214).log();
        }
        return this.waitForMaster;
    }

    public final void setWaitForMaster(boolean bl) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setWaitForMaster(boolean)", 227).addDetail("waitForMaster", bl)).log();
        }
        this.waitForMaster = bl;
    }

    @Override
    public Properties getConfigurableState() {
        Object object;
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getConfigurableState()", 243).log();
        }
        Properties properties = new Properties();
        properties.put("reference", this.reference);
        Point point = new Point(this.location);
        if ("Absolute".equalsIgnoreCase(this.reference) || this.master == null) {
            object = SwingUtil.getClosestGraphicsConfiguration(point.x, point.y);
            Rectangle rectangle = null;
            if (object != null) {
                rectangle = SwingUtil.getUsableBounds((GraphicsConfiguration)object);
                point.x -= rectangle.x;
                point.y -= rectangle.y;
                properties.put("gcx", "" + rectangle.x);
                properties.put("gcy", "" + rectangle.y);
            }
        }
        properties.put("x", "" + point.x);
        properties.put("y", "" + point.y);
        if (this.storeSize) {
            object = this.dialog.getSize();
            properties.put("width", "" + ((Dimension)object).width);
            properties.put("height", "" + ((Dimension)object).height);
        }
        if (RelativeDialogConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getConfigurableState()", 267).add("state", properties)).log();
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        String string;
        String string2;
        Dimension dimension;
        block30: {
            block28: {
                String string3;
                block27: {
                    String string4;
                    if (RelativeDialogConfigWrapper.logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableState(Properties)", 278).addDetail("state", properties)).log();
                    }
                    if ((string4 = properties.getProperty("x")) != null) {
                        try {
                            this.location.x = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (RelativeDialogConfigWrapper.logger.level < 3) break block27;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 285).add("ex", numberFormatException)).log();
                        }
                    }
                }
                if ((string3 = properties.getProperty("y")) != null) {
                    try {
                        this.location.y = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (RelativeDialogConfigWrapper.logger.level < 3) break block28;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 293).add("ex", numberFormatException)).log();
                    }
                }
            }
            if (properties.containsKey("reference")) {
                this.reference = properties.getProperty("reference");
            }
            dimension = this.dialog.getSize();
            if (RelativeDialogConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 302).add("size", dimension)).log();
            }
            if (this.storeSize) {
                block29: {
                    string2 = properties.getProperty("width");
                    if (string2 != null) {
                        try {
                            dimension.width = this.forceMinSize ? Math.max(dimension.width, Integer.parseInt(string2)) : Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (RelativeDialogConfigWrapper.logger.level < 3) break block29;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 313).add("ex", numberFormatException)).log();
                        }
                    }
                }
                if ((string = properties.getProperty("height")) != null) {
                    try {
                        dimension.height = this.forceMinSize ? Math.max(dimension.height, Integer.parseInt(string)) : Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (RelativeDialogConfigWrapper.logger.level < 3) break block30;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 326).add("ex", numberFormatException)).log();
                    }
                }
            }
        }
        if ("Absolute".equalsIgnoreCase(this.reference)) {
            Cloneable cloneable;
            GraphicsConfiguration graphicsConfiguration;
            block31: {
                string2 = properties.getProperty("gcx");
                string = properties.getProperty("gcy");
                graphicsConfiguration = null;
                try {
                    if (string2 != null && string != null) {
                        graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(Integer.parseInt(string2), Integer.parseInt(string));
                        if (RelativeDialogConfigWrapper.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 339).add("gc", graphicsConfiguration)).log();
                        }
                        if (RelativeDialogConfigWrapper.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 340).add(", bounds: ")).add("SwingUtil.getUsableBounds(gc)", SwingUtil.getUsableBounds(graphicsConfiguration))).log();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (RelativeDialogConfigWrapper.logger.level < 3) break block31;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 343).add("ex", numberFormatException)).log();
                }
            }
            if (graphicsConfiguration != null) {
                cloneable = SwingUtil.getUsableBounds(graphicsConfiguration);
                this.location.x += cloneable.x;
                this.location.y += cloneable.y;
            } else {
                graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(this.location.x, this.location.y);
            }
            cloneable = SwingUtil.getLocationInsideGraphicsConfiguration(new Rectangle(this.location.x, this.location.y, dimension.width, dimension.height), graphicsConfiguration);
            if (RelativeDialogConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 354).add("pos", cloneable)).log();
            }
            this.location.x = ((Point)cloneable).x;
            this.location.y = ((Point)cloneable).y;
        }
        if (this.master != null || !this.waitForMaster) {
            this.setLocation(dimension);
        } else {
            this.restore(dimension, null);
        }
    }

    @Override
    protected void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2, int n) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registrationChanged(Configuration,String,boolean,boolean,int)", 384).addDetail("config", configuration)).addDetail("name", string)).addDetail("registered", bl)).addDetail("valuesKept", bl2)).addDetail("helperState", n)).log();
        }
        if (this.master != null) {
            if (n == 1) {
                this.master.removeComponentListener(this);
                this.master.addComponentListener(this);
            } else if (n == -1) {
                this.master.removeComponentListener(this);
            }
        }
        super.registrationChanged(configuration, string, bl, bl2, n);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentMoved(ComponentEvent)", 411).addDetail("e", componentEvent)).log();
        }
        if (componentEvent.getSource() == this.master) {
            this.getLocation();
            return;
        }
        if (componentEvent.getSource() == this.dialog) {
            if (this.mark != null && this.mark.isActive()) {
                return;
            }
            this.getLocation();
            super.componentMoved(componentEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentResized(ComponentEvent)", 435).addDetail("e", componentEvent)).log();
        }
        if (this.storeSize && componentEvent.getSource() == this.dialog) {
            super.componentResized(componentEvent);
        }
    }

    @Override
    protected void restore(final Dimension dimension, final Point point) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "restore(Dimension,Point)", 456).addDetail("size", dimension)).addDetail("location", point)).log();
        }
        if (this.mark == null) {
            this.mark = new EventQueueMark();
        }
        this.mark.activate(200);
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Cloneable cloneable;
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "restore(Dimension,Point).Runnable.run()", 464).log();
                }
                RelativeDialogConfigWrapper.this.dialog.pack();
                if (RelativeDialogConfigWrapper.this.forceMinSize) {
                    cloneable = RelativeDialogConfigWrapper.this.dialog.getSize();
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "restore(Dimension,Point).Runnable.run()", 468).add("csize", cloneable)).log();
                    }
                    dimension.width = Math.max(cloneable.width, dimension.width);
                    dimension.height = Math.max(cloneable.height, dimension.height);
                }
                RelativeDialogConfigWrapper.this.dialog.setSize(dimension);
                RelativeDialogConfigWrapper.this.dialog.validate();
                if (point != null) {
                    cloneable = point;
                    if (RelativeDialogConfigWrapper.this.constrain) {
                        GraphicsConfiguration graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(((Point)cloneable).x, ((Point)cloneable).y);
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "restore(Dimension,Point).Runnable.run()", 479).add("gc", graphicsConfiguration)).log();
                        }
                        if (graphicsConfiguration == null) {
                            Dimension dimension2 = RelativeDialogConfigWrapper.this.dialog.getToolkit().getScreenSize();
                            Rectangle rectangle = new Rectangle(0, 0, dimension2.width, dimension2.height);
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "restore(Dimension,Point).Runnable.run()", 483).add("bounds", rectangle)).log();
                            }
                            ((Point)cloneable).x = Math.min(((Point)cloneable).x, rectangle.x + rectangle.width - dimension.width);
                            ((Point)cloneable).y = Math.min(((Point)cloneable).y, rectangle.y + rectangle.height - dimension.height);
                            ((Point)cloneable).x = Math.max(((Point)cloneable).x, rectangle.x);
                            ((Point)cloneable).y = Math.max(((Point)cloneable).y, rectangle.y);
                        } else {
                            Rectangle rectangle = new Rectangle(((Point)cloneable).x, ((Point)cloneable).y, dimension.width, dimension.height);
                            cloneable = SwingUtil.getLocationInsideGraphicsConfiguration(rectangle, graphicsConfiguration);
                        }
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "restore(Dimension,Point).Runnable.run()", 492).add("pos", cloneable)).log();
                        }
                    }
                    RelativeDialogConfigWrapper.this.dialog.setLocation((Point)cloneable);
                }
            }
        });
        this.mark.activate();
    }

    protected void setLocation(Dimension dimension) {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLocation(Dimension)", 509).addDetail("size", dimension)).log();
        }
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLocation(Dimension)", 511).add("location", this.location)).log();
        }
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLocation(Dimension)", 512).add("reference", this.reference)).log();
        }
        Point point = new Point(this.location);
        if ("Absolute".equalsIgnoreCase(this.reference) || this.master == null) {
            this.restore(dimension, point);
            return;
        }
        Point point2 = this.master.getLocation();
        Dimension dimension2 = this.master.getSize();
        if (RelativeDialogConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setLocation(Dimension)", 522).add("mPos", point2)).add("mSize", dimension2)).log();
        }
        if ("Northwest".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x, point2.y);
        } else if ("Northeast".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x + dimension2.width, point2.y);
        } else if ("Southwest".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x, point2.y + dimension2.height);
        } else if ("Southeast".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x + dimension2.width, point2.y + dimension2.height);
        } else if ("Center".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x + dimension2.width / 2, point2.y + dimension2.height / 2);
        }
        this.restore(dimension, point);
    }

    protected void getLocation() {
        if (RelativeDialogConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getLocation()", 544).log();
        }
        this.location = this.dialog.getLocation();
        if (this.master == null) {
            this.reference = "Absolute";
            return;
        }
        Dimension dimension = this.dialog.getSize();
        Point point = new Point(this.location.x + dimension.width / 2, this.location.y + dimension.height / 2);
        Point point2 = this.master.getLocation();
        Dimension dimension2 = this.master.getSize();
        double d = Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
        this.reference = "Northwest";
        Point point3 = new Point(this.location.x - point2.x, this.location.y - point2.y);
        double d2 = Math.sqrt((point.x - point2.x - dimension2.width) * (point.x - point2.x - dimension2.width) + (point.y - point2.y) * (point.y - point2.y));
        if (d2 < d) {
            d = d2;
            this.reference = "Northeast";
            point3 = new Point(this.location.x - point2.x - dimension2.width, this.location.y - point2.y);
        }
        if ((d2 = Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y - dimension2.height) * (point.y - point2.y - dimension2.height))) < d) {
            d = d2;
            this.reference = "Southwest";
            point3 = new Point(this.location.x - point2.x, this.location.y - point2.y - dimension2.height);
        }
        if ((d2 = Math.sqrt((point.x - point2.x - dimension2.width) * (point.x - point2.x - dimension2.width) + (point.y - point2.y - dimension2.height) * (point.y - point2.y - dimension2.height))) < d) {
            d = d2;
            this.reference = "Southeast";
            point3 = new Point(this.location.x - point2.x - dimension2.width, this.location.y - point2.y - dimension2.height);
        }
        if ((d2 = Math.sqrt((point.x - point2.x - dimension2.width / 2) * (point.x - point2.x - dimension2.width / 2) + (point.y - point2.y - dimension2.height / 2) * (point.y - point2.y - dimension2.height / 2))) < d) {
            d = d2;
            this.reference = "Center";
            point3 = new Point(this.location.x - point2.x - dimension2.width / 2, this.location.y - point2.y - dimension2.height / 2);
        }
        this.location = point3;
    }
}

