/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.AppendableTextContainer;
import de.qfs.lib.gui.Borders;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.ui.FlatScrollPane;
import de.qfs.lib.util.DelayedAction;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import lombok.Generated;

public abstract class AbstractTextView
extends FlatScrollPane
implements Configurable,
DocumentListener,
FocusListener,
AppendableTextContainer {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.AbstractTextView");
    private int limit = -1;
    protected Border defaultBorder;
    protected Border focusBorder;
    protected JTextComponent textArea;
    protected int lfIndex = -1;
    protected KeyAdapter scrollListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 && keyEvent.getModifiers() == 0) {
                SwingUtil.scrollDownLine(AbstractTextView.this);
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 40 && keyEvent.getModifiers() == 0) {
                SwingUtil.scrollUpLine(AbstractTextView.this);
                keyEvent.consume();
            }
        }
    };
    private String configurableName = "AbstractTextView";
    private boolean scrollOnAppend = true;
    private boolean lineWrap = true;
    private DelayedAction enforceLimitAction = new DelayedAction(500);

    public AbstractTextView() {
        this(null, null);
    }

    public AbstractTextView(String string) {
        this(string, null);
    }

    public AbstractTextView(String string, Document document) {
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "AbstractTextView(String,Document)", 177).addDetail("contents", string)).addDetail("doc", document)).log();
        }
        this.textArea = new JTextArea(document, string, 0, 0){

            @Override
            public boolean isManagingFocus() {
                return false;
            }
        };
        this.textArea.setEditable(false);
        this.textArea.addFocusListener(this);
        this.textArea.getDocument().addDocumentListener(this);
        this.setViewportView(this.textArea);
        this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLoweredBevelBorder());
        this.focusBorder = BorderFactory.createCompoundBorder(Borders.STIPPLE, BorderFactory.createLoweredBevelBorder());
        this.setBorder(null);
        this.textArea.addKeyListener(this.scrollListener);
    }

    public abstract JTextComponent getTextArea();

    @Override
    public void clear() {
        if (AbstractTextView.logger.level >= 7) {
            logger.lvlBuild(7, "clear()", 225).log();
        }
        this.textArea.setText(null);
        this.lfIndex = -1;
    }

    @Override
    public abstract void append(String var1);

    @Override
    public abstract void append(String var1, SimpleAttributeSet var2);

    @Override
    public abstract void clearCurrentLine();

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLimit(int)", 286).addDetail("limit", n)).log();
        }
        this.limit = n;
        this.enforceLimit();
    }

    public final boolean isScrollOnAppend() {
        return this.scrollOnAppend;
    }

    public final void setScrollOnAppend(boolean bl) {
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setScrollOnAppend(boolean)", 314).addDetail("scrollOnAppend", bl)).log();
        }
        if (bl != this.scrollOnAppend) {
            this.scrollOnAppend = bl;
        }
    }

    public abstract boolean getLineWrap();

    public abstract void setLineWrap(boolean var1);

    public abstract void destroy();

    @Override
    public final String getConfigurableName() {
        return this.configurableName;
    }

    @Override
    public final void setConfigurableName(String string) {
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableName(String)", 379).addDetail("configurableName", string)).log();
        }
        this.configurableName = string;
    }

    @Override
    public Properties getConfigurableState() {
        Properties properties = new Properties();
        properties.put("scrollOnAppend", "" + this.scrollOnAppend);
        properties.put("wrapLines", "" + this.lineWrap);
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        if (properties.containsKey("scrollOnAppend")) {
            this.scrollOnAppend = Boolean.valueOf(properties.getProperty("scrollOnAppend"));
        }
        if (properties.containsKey("wrapLines")) {
            this.setLineWrap(Boolean.valueOf(properties.getProperty("wrapLines")));
        }
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "insertUpdate(DocumentEvent)", 461).addDetail("e", documentEvent)).log();
        }
        if (this.isShowing()) {
            Point point = this.getViewport().getViewPosition();
            if (!this.scrollOnAppend) {
                int n = this.textArea.getDocument().getLength();
                int n2 = this.textArea.getCaretPosition();
                int n3 = documentEvent.getOffset();
                int n4 = documentEvent.getLength();
                if (n2 > 0 && (n2 == n || n2 == n3 && n3 + n4 == n)) {
                    this.textArea.setCaretPosition(n2 - 1);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            if (AbstractTextView.this.textArea == null) {
                                return;
                            }
                            int n = AbstractTextView.this.textArea.getDocument().getLength();
                            AbstractTextView.this.textArea.setCaretPosition(n);
                            try {
                                Rectangle rectangle = AbstractTextView.this.textArea.modelToView(n);
                                if (rectangle != null) {
                                    rectangle.x = 0;
                                    AbstractTextView.this.textArea.scrollRectToVisible(rectangle);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                if (logger.level < 1) break block4;
                                ((LevelAwareLogBuilder)logger.lvlBuild(1, "insertUpdate(DocumentEvent).Runnable.run()", 495).add("ex", badLocationException)).log();
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeUpdate(DocumentEvent)", 513).addDetail("e", documentEvent)).log();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        int n;
        if (AbstractTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "changedUpdate(DocumentEvent)", 526).addDetail("e", documentEvent)).log();
        }
        if (!this.scrollOnAppend && (n = this.textArea.getDocument().getLength()) > 0 && this.textArea.getCaretPosition() == n) {
            this.textArea.setCaretPosition(n - 1);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setBorder(this.focusBorder);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(this.defaultBorder);
    }

    protected void enforceLimit() {
        if (AbstractTextView.logger.level >= 7) {
            logger.lvlBuild(7, "enforceLimit()", 581).log();
        }
        if (this.limit > 0 && !this.enforceLimitAction.isActionPending()) {
            this.enforceLimitAction.perform(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            block5: {
                                if (AbstractTextView.this.textArea != null && AbstractTextView.this.textArea.getDocument() != null) {
                                    int n = AbstractTextView.this.textArea.getDocument().getLength();
                                    if (logger.level >= 5) {
                                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "enforceLimit().Runnable.run().Runnable.run()", 597).add("len", n)).log();
                                    }
                                    if (n > AbstractTextView.this.limit) {
                                        try {
                                            int n2 = n - AbstractTextView.this.limit;
                                            AbstractTextView.this.textArea.getDocument().remove(0, n2);
                                            AbstractTextView.this.lfIndex -= n2;
                                        }
                                        catch (BadLocationException badLocationException) {
                                            if (logger.level < 1) break block5;
                                            ((LevelAwareLogBuilder)logger.lvlBuild(1, "enforceLimit().Runnable.run().Runnable.run()", 606).add("ex", badLocationException)).log();
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
    }
}

