/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class AugmentedTextActions {
    public static TextAction upOrStartAction = new UpOrStartAction("upOrStart", false);
    public static TextAction selectionUpOrStartAction = new UpOrStartAction("selectionUpOrStart", true);
    public static TextAction downOrEndAction = new DownOrEndAction("downOrEnd", false);
    public static TextAction selectionDownOrEndAction = new DownOrEndAction("selectionDownOrEnd", true);
    public static TextAction endLineOrNextAction = new EndLineOrNextAction("endLineOrNext", false);
    public static TextAction selectionEndLineOrNextAction = new EndLineOrNextAction("selectionEndLineOrNext", true);
    public static TextAction beginLineOrPreviousAction = new BeginLineOrPreviousAction("beginLineOrPrevious", false);
    public static TextAction selectionBeginLineOrPreviousAction = new BeginLineOrPreviousAction("selectionBeginLineOrPrevious", true);

    private static Action getTextAction(JTextComponent jTextComponent, String string) {
        for (Action action : jTextComponent.getActions()) {
            if (action.getValue("Name") != string) continue;
            return action;
        }
        return null;
    }

    private static void performTextAction(JTextComponent jTextComponent, String string, ActionEvent actionEvent) {
        Action action = AugmentedTextActions.getTextAction(jTextComponent, string);
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
    }

    private static class EndLineOrNextAction
    extends TextAction {
        private boolean select;

        EndLineOrNextAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getCaretPosition();
            try {
                if (Utilities.getRowEnd(jTextComponent, n) == n) {
                    int n2 = Utilities.getRowEnd(jTextComponent, Math.min(jTextComponent.getDocument().getLength(), n + 1));
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.select) {
                AugmentedTextActions.performTextAction(jTextComponent, "selection-end-line", actionEvent);
            } else {
                AugmentedTextActions.performTextAction(jTextComponent, "caret-end-line", actionEvent);
            }
        }
    }

    private static class BeginLineOrPreviousAction
    extends TextAction {
        private boolean select;

        BeginLineOrPreviousAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getCaretPosition();
            try {
                if (Utilities.getRowStart(jTextComponent, n) == n) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(Utilities.getRowStart(jTextComponent, n - 1));
                    } else {
                        jTextComponent.setCaretPosition(Utilities.getRowStart(jTextComponent, n - 1));
                    }
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.select) {
                AugmentedTextActions.performTextAction(jTextComponent, "selection-begin-line", actionEvent);
            } else {
                AugmentedTextActions.performTextAction(jTextComponent, "caret-begin-line", actionEvent);
            }
        }
    }

    private static class UpOrStartAction
    extends TextAction {
        private boolean select;

        UpOrStartAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getCaretPosition();
            try {
                if (Utilities.getPositionAbove(jTextComponent, n, 0) == -1) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(0);
                    } else {
                        jTextComponent.setCaretPosition(0);
                    }
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.select) {
                AugmentedTextActions.performTextAction(jTextComponent, "selection-up", actionEvent);
            } else {
                AugmentedTextActions.performTextAction(jTextComponent, "caret-up", actionEvent);
            }
        }
    }

    private static class DownOrEndAction
    extends TextAction {
        private boolean select;

        DownOrEndAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = jTextComponent.getCaretPosition();
            try {
                if (Utilities.getPositionBelow(jTextComponent, n, 0) == n) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(jTextComponent.getDocument().getLength());
                    } else {
                        jTextComponent.setCaretPosition(jTextComponent.getDocument().getLength());
                    }
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.select) {
                AugmentedTextActions.performTextAction(jTextComponent, "selection-down", actionEvent);
            } else {
                AugmentedTextActions.performTextAction(jTextComponent, "caret-down", actionEvent);
            }
        }
    }
}

