/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.RegistrationHelper;
import de.qfs.lib.gui.TableModelSorter;
import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import de.qfs.lib.log.Logger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.table.TableModel;

public class DefaultTableModelSorter
implements TableModelSorter,
Configurable {
    private static Logger logger = new Logger("de.qfs.lib.gui.DefaultTableModelSorter");
    protected List listeners = new ArrayList();
    protected int column = -1;
    protected boolean ascending;
    protected boolean autoAscending = true;
    protected String configurableName;
    private RegistrationHelper regHelper = new RegistrationHelper();
    private boolean sortNullFirst;

    public DefaultTableModelSorter() {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "DefaultTableModelSorter(TableModel)", "");
        }
    }

    public DefaultTableModelSorter(String string) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "DefaultTableModelSorter(TableModel,String)", DefaultTableModelSorter.logger.level < 8 ? "" : "name: " + string);
        }
        this.configurableName = string;
    }

    @Override
    public final void setSortColumn(int n) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "setSortColumn(int)", DefaultTableModelSorter.logger.level < 8 ? "" : "column: " + n);
        }
        if (this.autoAscending) {
            this.ascending = this.column == n ? !this.ascending : true;
        }
        this.column = n;
        this.fireSortOrderChanged(new TableModelSorterEvent(this, n, this.ascending));
    }

    @Override
    public final int getSortColumn() {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "getSortColumn()", "");
        }
        return this.column;
    }

    @Override
    public final void setSortAscending(boolean bl) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "setSortAscending(boolean)", DefaultTableModelSorter.logger.level < 8 ? "" : "ascending: " + bl);
        }
        this.ascending = bl;
        this.fireSortOrderChanged(new TableModelSorterEvent(this, this.column, bl));
    }

    @Override
    public final boolean isSortAscending() {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "isSortAscending()", "");
        }
        return this.ascending;
    }

    public final void setAutoAscending(boolean bl) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "setAutoAscending(boolean)", DefaultTableModelSorter.logger.level < 8 ? "" : "auto: " + bl);
        }
        this.autoAscending = bl;
    }

    public final boolean isAutoAscending() {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "isAutoAscending()", "");
        }
        return this.autoAscending;
    }

    public final boolean isSortNullFirst() {
        return this.sortNullFirst;
    }

    public final void setSortNullFirst(boolean bl) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "setSortNullFirst(boolean)", DefaultTableModelSorter.logger.level < 8 ? "" : "sortNullFirst: " + bl);
        }
        this.sortNullFirst = bl;
    }

    @Override
    public int compare(TableModel tableModel, int n, int n2) {
        if (tableModel == null || this.column < 0 || this.column >= tableModel.getColumnCount()) {
            return 0;
        }
        Class<?> clazz = tableModel.getColumnClass(this.column);
        Object object = tableModel.getValueAt(n, this.column);
        Object object2 = tableModel.getValueAt(n2, this.column);
        int n3 = object == null ? (object2 == null ? 0 : (this.sortNullFirst ? -1 : 1)) : (object2 == null ? (this.sortNullFirst ? 1 : -1) : (clazz == String.class ? Collator.getInstance().compare((String)object, (String)object2) : (Comparable.class.isAssignableFrom(clazz) ? ((Comparable)object).compareTo(object2) : Collator.getInstance().compare(object.toString(), object2.toString()))));
        return this.ascending ? n3 : -n3;
    }

    @Override
    public void addTableModelSorterListener(TableModelSorterListener tableModelSorterListener) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "addTableModelSorterListener(TableModelSorterListener)", "listener: " + tableModelSorterListener);
        }
        this.listeners.add(tableModelSorterListener);
    }

    @Override
    public void removeTableModelSorterListener(TableModelSorterListener tableModelSorterListener) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "removeTableModelSorterListener(TableModelSorterListener)", "listener: " + tableModelSorterListener);
        }
        this.listeners.remove(tableModelSorterListener);
    }

    protected void fireSortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "fireSortOrderChanged(TableModelSorterEvent)", DefaultTableModelSorter.logger.level < 8 ? "" : "e: " + tableModelSorterEvent);
        }
        TableModelSorterListener[] tableModelSorterListenerArray = this.listeners.toArray(new TableModelSorterListener[0]);
        for (int i = tableModelSorterListenerArray.length - 1; i >= 0; --i) {
            tableModelSorterListenerArray[i].sortOrderChanged(tableModelSorterEvent);
        }
        this.regHelper.stateChanged(this);
    }

    @Override
    public final String getConfigurableName() {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "getConfigurableName()", "");
        }
        return this.configurableName;
    }

    @Override
    public final void setConfigurableName(String string) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "setConfigurableName(String)", DefaultTableModelSorter.logger.level < 8 ? "" : "name: " + string);
        }
        this.configurableName = string;
    }

    @Override
    public Properties getConfigurableState() {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "getConfigurableState()", "");
        }
        Properties properties = new Properties();
        properties.put("column", "" + this.column);
        properties.put("ascending", "" + this.ascending);
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "setConfigurableState(Properties)", DefaultTableModelSorter.logger.level < 8 ? "" : "state: " + properties);
        }
        String string = properties.getProperty("column");
        String string2 = properties.getProperty("ascending");
        if (DefaultTableModelSorter.logger.level >= 9) {
            logger.log(9, "setConfigurableState(Properties)", "column: " + string + ", ascending: " + string2);
        }
        if (string == null || string2 == null) {
            if (DefaultTableModelSorter.logger.level >= 3) {
                logger.log(3, "setConfigurableState(Properties)", "Invalid state: column: " + string + ", ascending: " + string2);
            }
            return;
        }
        try {
            boolean bl = this.autoAscending;
            this.autoAscending = false;
            this.ascending = Boolean.valueOf(string2);
            this.setSortColumn(Integer.parseInt(string));
            this.autoAscending = bl;
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(3, "setConfigurableState(Properties)", numberFormatException);
        }
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (DefaultTableModelSorter.logger.level >= 7) {
            logger.log(7, "registrationChanged(Configuration,String,boolean,boolean)", DefaultTableModelSorter.logger.level < 8 ? "" : "name: " + string + ", registered: " + bl);
        }
        this.regHelper.registrationChanged(configuration, bl);
    }
}

