/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DelayedAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import lombok.Generated;

public abstract class DelayedMouseListener
extends MouseAdapter {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.DelayedMouseListener");
    public static final int DEFAULT_DELAY = 300;
    private DelayedAction delayedAction;

    public DelayedMouseListener() {
        this(300);
        if (DelayedMouseListener.logger.level >= 7) {
            logger.lvlBuild(7, "DelayedMouseListener()", 86).log();
        }
    }

    public DelayedMouseListener(int n) {
        if (DelayedMouseListener.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "DelayedMouseListener(int)", 97).addDetail("delay", n)).log();
        }
        this.delayedAction = new DelayedAction(n);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (DelayedMouseListener.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mousePressed(MouseEvent)", 119).addDetail("e", mouseEvent)).log();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (DelayedMouseListener.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mouseReleased(MouseEvent)", 128).addDetail("e", mouseEvent)).log();
        }
        if (this.delayedAction == null) {
            return;
        }
        if (this.delayedAction.isActionPending()) {
            this.delayedAction.cancel();
        }
        if (mouseEvent.getClickCount() > 1) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x40) != 0 || (mouseEvent.getModifiersEx() & 0x80) != 0 || (mouseEvent.getModifiersEx() & 0x200) != 0 || (mouseEvent.getModifiersEx() & 0x20) != 0 || (mouseEvent.getModifiersEx() & 0x100) != 0) {
            return;
        }
        this.delayedAction.perform(new RunHelper(mouseEvent));
    }

    protected abstract void delayedMouseReleased(MouseEvent var1);

    public void cleanup() {
        if (DelayedMouseListener.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 178).log();
        }
        if (this.delayedAction != null) {
            this.delayedAction.cancel();
            this.delayedAction = null;
        }
    }

    @Generated
    public DelayedMouseListener setDelayedAction(DelayedAction delayedAction) {
        if (DelayedMouseListener.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDelayedAction(DelayedAction)", 75).addDetail("delayedAction", delayedAction)).log();
        }
        this.delayedAction = delayedAction;
        return this;
    }

    private class RunHelper
    implements Runnable {
        private MouseEvent event;

        public RunHelper(MouseEvent mouseEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RunHelper.RunHelper(MouseEvent)", 209).addDetail("event", mouseEvent)).log();
            }
            this.event = mouseEvent;
        }

        @Override
        public void run() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunHelper.run()", 222).log();
            }
            DelayedMouseListener.this.delayedMouseReleased(this.event);
        }
    }
}

