/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;

public class EventModifiers
implements Cloneable {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.EventModifiers");
    private static final int MAX_MOUSE_BUTTONS = 20;
    private boolean leftMouseButtonDown;
    private boolean middleMouseButtonDown;
    private boolean rightMouseButtonDown;
    private boolean shiftDown;
    private boolean ctrlDown;
    private boolean metaDown;
    private boolean altDown;
    private boolean altGrDown;
    boolean[] mouseButtonsDown;

    public EventModifiers(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiers(int)", 68).addDetail("swingModifiers", n)).log();
        }
        this.mouseButtonsDown = new boolean[20];
        this.setFlagsBasedOnSwingModifiers(n);
    }

    public boolean isLeftMouseButtonDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isLeftMouseButtonDown()", 82).log();
        }
        return this.leftMouseButtonDown || this.isMouseButtonDown(0);
    }

    public boolean isMiddleMouseButtonDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isMiddleMouseButtonDown()", 90).log();
        }
        return this.middleMouseButtonDown || this.isMouseButtonDown(1);
    }

    public boolean isRightMouseButtonDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isRightMouseButtonDown()", 98).log();
        }
        return this.rightMouseButtonDown || this.isMouseButtonDown(2);
    }

    public boolean isMouseButtonDown(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isMouseButtonDown(int)", 109).addDetail("index", n)).log();
        }
        if (this.mouseButtonsDown != null && n < this.mouseButtonsDown.length && this.mouseButtonsDown[n]) {
            return true;
        }
        switch (n) {
            case 0: {
                return this.leftMouseButtonDown;
            }
            case 1: {
                return this.middleMouseButtonDown;
            }
            case 2: {
                return this.rightMouseButtonDown;
            }
        }
        return false;
    }

    private void setFlagsBasedOnSwingModifiers(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFlagsBasedOnSwingModifiers(int)", 139).addDetail("swingModifiers", n)).log();
        }
        this.setFlagsBasedOnLegacySwingModifiers(n);
        this.setFlagsBasedOnExtendedSwingModifiers(n);
    }

    private void setFlagsBasedOnLegacySwingModifiers(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFlagsBasedOnLegacySwingModifiers(int)", 148).addDetail("swingModifiers", n)).log();
        }
        if ((n & 1) > 0) {
            this.shiftDown = true;
        }
        if ((n & 2) > 0) {
            this.ctrlDown = true;
        }
        if ((n & 4) > 0) {
            this.metaDown = true;
        }
        if ((n & 8) > 0) {
            this.altDown = true;
        }
        if ((n & 0x20) > 0) {
            this.altGrDown = true;
        }
        if ((n & 0x10) > 0) {
            this.leftMouseButtonDown = true;
        } else if ((n & 4) > 0) {
            this.rightMouseButtonDown = true;
            this.metaDown = false;
        } else if ((n & 8) > 0) {
            this.middleMouseButtonDown = true;
            this.altDown = false;
        }
    }

    private void setFlagsBasedOnExtendedSwingModifiers(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFlagsBasedOnExtendedSwingModifiers(int)", 180).addDetail("swingModifiers", n)).log();
        }
        if ((n & 0x40) > 0) {
            this.shiftDown = true;
        }
        if ((n & 0x80) > 0) {
            this.ctrlDown = true;
        }
        if ((n & 0x100) > 0) {
            this.metaDown = true;
        }
        if ((n & 0x200) > 0) {
            this.altDown = true;
        }
        if ((n & 0x2000) > 0) {
            this.altGrDown = true;
        }
        if ((n & 0x400) > 0) {
            this.leftMouseButtonDown = true;
        }
        if ((n & 0x800) > 0) {
            this.middleMouseButtonDown = true;
        }
        if ((n & 0x1000) > 0) {
            this.rightMouseButtonDown = true;
        }
        for (int i = 3; i < this.mouseButtonsDown.length; ++i) {
            if ((n & 1 << i + 11) <= 0) continue;
            this.mouseButtonsDown[i] = true;
        }
    }

    public int asSwingModifiers() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "asSwingModifiers()", 221).log();
        }
        int n = 0;
        if (this.isShiftDown()) {
            n |= 0x40;
            n |= 1;
        }
        if (this.isCtrlDown()) {
            n |= 0x80;
            n |= 2;
        }
        if (this.isMetaDown()) {
            n |= 0x100;
            n |= 4;
        }
        if (this.isAltDown()) {
            n |= 0x200;
            n |= 8;
        }
        if (this.isAltGrDown()) {
            n |= 0x2000;
            n |= 0x20;
        }
        if (this.isLeftMouseButtonDown()) {
            n |= 0x400;
            n |= 0x10;
        }
        if (this.isMiddleMouseButtonDown()) {
            n |= 0x800;
            n |= 8;
        }
        if (this.isRightMouseButtonDown()) {
            n |= 0x1000;
            n |= 4;
        }
        if (this.mouseButtonsDown != null) {
            for (int i = 3; i < 20 && i < this.mouseButtonsDown.length; ++i) {
                if (!this.mouseButtonsDown[i]) continue;
                n |= 1 << i + 11;
            }
        }
        return n;
    }

    @NonNull
    public EventModifiers keyModifiers() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "keyModifiers()", 284).log();
        }
        EventModifiers eventModifiers = EventModifiers.cloneModifiers(this);
        EventModifiers.removeMouseButtonModifiers(eventModifiers);
        return eventModifiers;
    }

    @NonNull
    public EventModifiers mouseButtonModifiers() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "mouseButtonModifiers()", 302).log();
        }
        EventModifiers eventModifiers = EventModifiers.cloneModifiers(this);
        EventModifiers.removeKeyModifiers(eventModifiers);
        return eventModifiers;
    }

    private static void removeMouseButtonModifiers(@NonNull EventModifiers eventModifiers) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeMouseButtonModifiers(EventModifiers)", 319).addDetail("eventModifiers", eventModifiers)).log();
        }
        if (eventModifiers == null) {
            throw new IllegalArgumentException("eventModifiers is marked non-null but is null");
        }
        eventModifiers.leftMouseButtonDown = false;
        eventModifiers.middleMouseButtonDown = false;
        eventModifiers.rightMouseButtonDown = false;
        eventModifiers.mouseButtonsDown = new boolean[20];
    }

    private static void removeKeyModifiers(@NonNull EventModifiers eventModifiers) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeKeyModifiers(EventModifiers)", 330).addDetail("eventModifiers", eventModifiers)).log();
        }
        if (eventModifiers == null) {
            throw new IllegalArgumentException("eventModifiers is marked non-null but is null");
        }
        eventModifiers.shiftDown = false;
        eventModifiers.ctrlDown = false;
        eventModifiers.metaDown = false;
        eventModifiers.altDown = false;
        eventModifiers.altGrDown = false;
    }

    @NonNull
    private static EventModifiers cloneModifiers(@NonNull EventModifiers eventModifiers) {
        EventModifiers eventModifiers2;
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "cloneModifiers(EventModifiers)", 343).addDetail("original", eventModifiers)).log();
        }
        if (eventModifiers == null) {
            throw new IllegalArgumentException("original is marked non-null but is null");
        }
        try {
            eventModifiers2 = (EventModifiers)eventModifiers.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException);
        }
        return eventModifiers2;
    }

    @NonNull
    public static EventModifiers keyModifiers(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "keyModifiers(int)", 368).addDetail("swingModifiers", n)).log();
        }
        return new EventModifiers(n).keyModifiers();
    }

    @NonNull
    public static EventModifiers mouseButtonModifiers(int n) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mouseButtonModifiers(int)", 382).addDetail("swingModifiers", n)).log();
        }
        return new EventModifiers(n).mouseButtonModifiers();
    }

    @Generated
    private static boolean[] $default$mouseButtonsDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "$default$mouseButtonsDown()", 32).log();
        }
        return new boolean[20];
    }

    @Generated
    public static EventModifiersBuilder builder() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "builder()", 32).log();
        }
        return new EventModifiersBuilder();
    }

    @Generated
    public String toString() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "toString()", 29).log();
        }
        return "EventModifiers(leftMouseButtonDown=" + this.isLeftMouseButtonDown() + ", middleMouseButtonDown=" + this.isMiddleMouseButtonDown() + ", rightMouseButtonDown=" + this.isRightMouseButtonDown() + ", shiftDown=" + this.isShiftDown() + ", ctrlDown=" + this.isCtrlDown() + ", metaDown=" + this.isMetaDown() + ", altDown=" + this.isAltDown() + ", altGrDown=" + this.isAltGrDown() + ", mouseButtonsDown=" + Arrays.toString(this.mouseButtonsDown) + ")";
    }

    @Generated
    public EventModifiers(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean[] blArray) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiers(boolean,boolean,boolean,boolean,boolean,boolean,boolean,boolean,boolean[])", 30).addDetail("leftMouseButtonDown", bl)).addDetail("middleMouseButtonDown", bl2)).addDetail("rightMouseButtonDown", bl3)).addDetail("shiftDown", bl4)).addDetail("ctrlDown", bl5)).addDetail("metaDown", bl6)).addDetail("altDown", bl7)).addDetail("altGrDown", bl8)).addDetail("mouseButtonsDown", blArray)).log();
        }
        this.leftMouseButtonDown = bl;
        this.middleMouseButtonDown = bl2;
        this.rightMouseButtonDown = bl3;
        this.shiftDown = bl4;
        this.ctrlDown = bl5;
        this.metaDown = bl6;
        this.altDown = bl7;
        this.altGrDown = bl8;
        this.mouseButtonsDown = blArray;
    }

    @Generated
    public boolean equals(Object object) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "equals(Object)", 31).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof EventModifiers)) {
            return false;
        }
        EventModifiers eventModifiers = (EventModifiers)object;
        if (!eventModifiers.canEqual(this)) {
            return false;
        }
        if (this.isLeftMouseButtonDown() != eventModifiers.isLeftMouseButtonDown()) {
            return false;
        }
        if (this.isMiddleMouseButtonDown() != eventModifiers.isMiddleMouseButtonDown()) {
            return false;
        }
        if (this.isRightMouseButtonDown() != eventModifiers.isRightMouseButtonDown()) {
            return false;
        }
        if (this.isShiftDown() != eventModifiers.isShiftDown()) {
            return false;
        }
        if (this.isCtrlDown() != eventModifiers.isCtrlDown()) {
            return false;
        }
        if (this.isMetaDown() != eventModifiers.isMetaDown()) {
            return false;
        }
        if (this.isAltDown() != eventModifiers.isAltDown()) {
            return false;
        }
        if (this.isAltGrDown() != eventModifiers.isAltGrDown()) {
            return false;
        }
        return Arrays.equals(this.mouseButtonsDown, eventModifiers.mouseButtonsDown);
    }

    @Generated
    protected boolean canEqual(Object object) {
        if (EventModifiers.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "canEqual(Object)", 31).addDetail("other", object)).log();
        }
        return object instanceof EventModifiers;
    }

    @Generated
    public int hashCode() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "hashCode()", 31).log();
        }
        int n = 1;
        n = n * 59 + (this.isLeftMouseButtonDown() ? 79 : 97);
        n = n * 59 + (this.isMiddleMouseButtonDown() ? 79 : 97);
        n = n * 59 + (this.isRightMouseButtonDown() ? 79 : 97);
        n = n * 59 + (this.isShiftDown() ? 79 : 97);
        n = n * 59 + (this.isCtrlDown() ? 79 : 97);
        n = n * 59 + (this.isMetaDown() ? 79 : 97);
        n = n * 59 + (this.isAltDown() ? 79 : 97);
        n = n * 59 + (this.isAltGrDown() ? 79 : 97);
        n = n * 59 + Arrays.hashCode(this.mouseButtonsDown);
        return n;
    }

    @Generated
    public boolean isShiftDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isShiftDown()", 42).log();
        }
        return this.shiftDown;
    }

    @Generated
    public boolean isCtrlDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isCtrlDown()", 43).log();
        }
        return this.ctrlDown;
    }

    @Generated
    public boolean isMetaDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isMetaDown()", 44).log();
        }
        return this.metaDown;
    }

    @Generated
    public boolean isAltDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isAltDown()", 45).log();
        }
        return this.altDown;
    }

    @Generated
    public boolean isAltGrDown() {
        if (EventModifiers.logger.level >= 7) {
            logger.lvlBuild(7, "isAltGrDown()", 46).log();
        }
        return this.altGrDown;
    }

    @Generated
    public static class EventModifiersBuilder {
        @Generated
        private boolean leftMouseButtonDown;
        @Generated
        private boolean middleMouseButtonDown;
        @Generated
        private boolean rightMouseButtonDown;
        @Generated
        private boolean shiftDown;
        @Generated
        private boolean ctrlDown;
        @Generated
        private boolean metaDown;
        @Generated
        private boolean altDown;
        @Generated
        private boolean altGrDown;
        @Generated
        private boolean mouseButtonsDown$set;
        @Generated
        private boolean[] mouseButtonsDown$value;

        @Generated
        EventModifiersBuilder() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "EventModifiersBuilder.EventModifiersBuilder()", 32).log();
            }
        }

        @Generated
        public EventModifiersBuilder leftMouseButtonDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.leftMouseButtonDown(boolean)", 32).addDetail("leftMouseButtonDown", bl)).log();
            }
            this.leftMouseButtonDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder middleMouseButtonDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.middleMouseButtonDown(boolean)", 32).addDetail("middleMouseButtonDown", bl)).log();
            }
            this.middleMouseButtonDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder rightMouseButtonDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.rightMouseButtonDown(boolean)", 32).addDetail("rightMouseButtonDown", bl)).log();
            }
            this.rightMouseButtonDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder shiftDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.shiftDown(boolean)", 32).addDetail("shiftDown", bl)).log();
            }
            this.shiftDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder ctrlDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.ctrlDown(boolean)", 32).addDetail("ctrlDown", bl)).log();
            }
            this.ctrlDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder metaDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.metaDown(boolean)", 32).addDetail("metaDown", bl)).log();
            }
            this.metaDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder altDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.altDown(boolean)", 32).addDetail("altDown", bl)).log();
            }
            this.altDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder altGrDown(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.altGrDown(boolean)", 32).addDetail("altGrDown", bl)).log();
            }
            this.altGrDown = bl;
            return this;
        }

        @Generated
        public EventModifiersBuilder mouseButtonsDown(boolean[] blArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventModifiersBuilder.mouseButtonsDown(boolean[])", 32).addDetail("mouseButtonsDown", blArray)).log();
            }
            this.mouseButtonsDown$value = blArray;
            this.mouseButtonsDown$set = true;
            return this;
        }

        @Generated
        public EventModifiers build() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "EventModifiersBuilder.build()", 32).log();
            }
            boolean[] blArray = this.mouseButtonsDown$value;
            if (!this.mouseButtonsDown$set) {
                blArray = EventModifiers.$default$mouseButtonsDown();
            }
            return new EventModifiers(this.leftMouseButtonDown, this.middleMouseButtonDown, this.rightMouseButtonDown, this.shiftDown, this.ctrlDown, this.metaDown, this.altDown, this.altGrDown, blArray);
        }

        @Generated
        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "EventModifiersBuilder.toString()", 32).log();
            }
            return "EventModifiers.EventModifiersBuilder(leftMouseButtonDown=" + this.leftMouseButtonDown + ", middleMouseButtonDown=" + this.middleMouseButtonDown + ", rightMouseButtonDown=" + this.rightMouseButtonDown + ", shiftDown=" + this.shiftDown + ", ctrlDown=" + this.ctrlDown + ", metaDown=" + this.metaDown + ", altDown=" + this.altDown + ", altGrDown=" + this.altGrDown + ", mouseButtonsDown$value=" + Arrays.toString(this.mouseButtonsDown$value) + ")";
        }
    }
}

