/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;

public class Grid
extends JPanel {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.Grid");
    protected int lines = 0;
    protected GridBagLayout layout = new GridBagLayout();
    protected int horDist = 5;
    protected int verDist = 5;
    private Component glue;
    protected double totalWeight;

    public Grid() {
        this.setLayout(this.layout);
    }

    public Grid(int n, int n2) {
        this();
        this.horDist = n;
        this.verDist = n2;
    }

    public Grid(Component[][] componentArray) {
        this();
        for (int i = 0; i < componentArray.length; ++i) {
            this.addLine(componentArray[i]);
        }
    }

    public void addLine(Component[] componentArray) {
        if (Grid.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addLine(Component[])", 148).addDetail("line", componentArray)).log();
        }
        Component component = componentArray.length > 1 ? this.makeLine(componentArray) : componentArray[0];
        this.add(component, 0.0);
    }

    public void addLine(Component[] componentArray, double d) {
        if (Grid.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addLine(Component[],double)", 168).addDetail("line", componentArray)).addDetail("weighty", d)).log();
        }
        Component component = componentArray.length > 1 ? this.makeLine(componentArray) : componentArray[0];
        this.add(component, d);
    }

    public void addGrid(Component[][] componentArray) {
        int n;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        int n2 = 0;
        for (n = 0; n < componentArray.length; ++n) {
            if (componentArray[n].length <= n2) continue;
            n2 = componentArray[n].length;
        }
        n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            int n3 = 0;
            gridBagConstraints.gridy = n++;
            for (int j = 0; j < componentArray[i].length; ++j) {
                gridBagConstraints.gridx = n3++;
                if (j < componentArray[i].length - 1) {
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.gridwidth = 1;
                } else {
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.gridwidth = 0;
                }
                gridBagLayout.setConstraints(componentArray[i][j], gridBagConstraints);
                jPanel.add(componentArray[i][j]);
                if (j >= componentArray[i].length - 1 || this.horDist <= 0) continue;
                Component component = Box.createHorizontalStrut(this.horDist);
                gridBagConstraints.gridx = n3++;
                gridBagLayout.setConstraints(component, gridBagConstraints);
                jPanel.add(component);
            }
            if (i >= componentArray.length - 1 || this.verDist <= 0) continue;
            Component component = Box.createVerticalStrut(this.verDist);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jPanel.add(component);
        }
        this.add((Component)jPanel, 0.0);
    }

    public void add(Component component, double d) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        if (this.lines > 0 && this.verDist > 0) {
            Component component2 = Box.createVerticalStrut(this.verDist);
            gridBagConstraints.fill = 2;
            this.layout.setConstraints(component2, gridBagConstraints);
            this.add(component2);
        }
        gridBagConstraints.fill = d > 0.0 ? 1 : 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = d;
        this.layout.setConstraints(component, gridBagConstraints);
        this.add(component);
        ++this.lines;
        this.totalWeight += d;
    }

    public void addGlue() {
        if (this.glue == null) {
            this.glue = Box.createVerticalGlue();
            this.add(this.glue, 1.0);
        }
    }

    public void removeGlue() {
        if (this.glue != null) {
            this.remove(this.glue);
            this.glue = null;
            this.totalWeight -= 1.0;
        }
    }

    public final int getHorizontalDistance() {
        return this.horDist;
    }

    public final void setHorizontalDistance(int n) {
        this.horDist = n;
    }

    public final int getVerticalDistance() {
        return this.verDist;
    }

    public final void setVerticalDistance(int n) {
        this.verDist = n;
    }

    public final boolean needGlue() {
        return this.glue == null && this.totalWeight < 1.0E-4;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.lines = 0;
    }

    protected Component makeLine(Component[] componentArray) {
        Component component;
        int n;
        Box box = Box.createHorizontalBox();
        int n2 = 0;
        boolean bl = true;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component.getMinimumSize().width > n2) {
                n2 = component.getMinimumSize().width;
            }
            if (component.getMaximumSize().width >= 30000) {
                bl = false;
            }
            box.add(component);
            if (n >= componentArray.length - 1 || this.horDist <= 0) continue;
            Component component2 = Box.createHorizontalStrut(this.horDist);
            box.add(component2);
        }
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setPreferredSize(new Dimension(n2, component.getPreferredSize().height));
            if (!bl) continue;
            ((JComponent)component).setMaximumSize(new Dimension(Integer.MAX_VALUE, component.getMaximumSize().height));
        }
        return box;
    }
}

