/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.ModalDialog;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.notifications.Observer;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import lombok.Generated;
import lombok.NonNull;

public abstract class Message {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.Message");
    public static final int YESFORALL_OPTION = 3;
    public static final int NOFORALL_OPTION = 4;
    public static final int CANCELFORALL_OPTION = 5;
    public static final int SHOW_LOG_OPTION = 1;
    public static final String NOTIFY_SHOWING_DIALOG = "showingDialog";
    public static final String NOTIFY_HIDING_DIALOG = "hidingDialog";
    static MapResourceBundle rb = new MapResourceBundle();
    private static boolean customDialogs;
    private static List<HyperlinkListener> hyperlinkListeners;

    private Message() {
    }

    public static final ResourceBundle getResources() {
        return rb;
    }

    public static final void setResources(ResourceBundle resourceBundle) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setResources(ResourceBundle)", 290).addDetail("resources", resourceBundle)).log();
        }
        rb = resourceBundle == null ? new MapResourceBundle() : new MapResourceBundle(resourceBundle);
    }

    public static final void addResources(ResourceBundle resourceBundle) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addResources(ResourceBundle)", 307).addDetail("resources", resourceBundle)).log();
        }
        rb.addResources(resourceBundle);
    }

    public static List<HyperlinkListener> getHyperlinkListeners() {
        return hyperlinkListeners;
    }

    public static void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addHyperlinkListener(HyperlinkListener)", 338).addDetail("listener", hyperlinkListener)).log();
        }
        hyperlinkListeners.add(hyperlinkListener);
    }

    public static int showYesNo(Component component, Object object, String string, int n, Icon icon) {
        return Message.showYesNo(component, object, string, n, icon, 0);
    }

    public static int showYesNo(Component component, Object object, String string, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showYesNo(Component,Object,String,int,Icon,int)", 392).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        if (customDialogs) {
            return Message.showAsDialog("yesno", component, object, string, n, icon, n2);
        }
        Object[] objectArray = new Object[]{rb.getString("dialog.yes.name", "Yes"), rb.getString("dialog.no.name", "No")};
        if (objectArray[0].equals(object2 = Message.show(component, object, string, 0, n, icon, objectArray, objectArray[0], n2))) {
            return 0;
        }
        if (objectArray[1].equals(object2)) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoForAll(Component component, Object object, String string, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showYesNoForAll(Component,Object,String,int,Icon,int)", 433).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        if (customDialogs) {
            return Message.showAsDialog("yesnoforall", component, object, string, n, icon, n2);
        }
        Object[] objectArray = new Object[]{rb.getString("dialog.yes.name", "Yes"), rb.getString("dialog.yesforall.name", "YesForAll"), rb.getString("dialog.no.name", "No"), rb.getString("dialog.noforall.name", "NoForAll")};
        if (objectArray[0].equals(object2 = Message.show(component, object, string, 0, n, icon, objectArray, objectArray[0], n2))) {
            return 0;
        }
        if (objectArray[2].equals(object2)) {
            return 1;
        }
        if (objectArray[1].equals(object2)) {
            return 3;
        }
        if (objectArray[3].equals(object2)) {
            return 4;
        }
        return -1;
    }

    public static int showYesNoForAllCancel(Component component, Object object, String string, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showYesNoForAllCancel(Component,Object,String,int,Icon,int)", 483).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        if (customDialogs) {
            return Message.showAsDialog("yesnoforallcancel", component, object, string, n, icon, n2);
        }
        Object[] objectArray = new Object[]{rb.getString("dialog.yes.name", "Yes"), rb.getString("dialog.yesforall.name", "YesForAll"), rb.getString("dialog.no.name", "No"), rb.getString("dialog.noforall.name", "NoForAll"), rb.getString("dialog.cancelforall.name", "CancelForAll")};
        if (objectArray[0].equals(object2 = Message.show(component, object, string, 0, n, icon, objectArray, objectArray[0], n2))) {
            return 0;
        }
        if (objectArray[2].equals(object2)) {
            return 1;
        }
        if (objectArray[1].equals(object2)) {
            return 3;
        }
        if (objectArray[3].equals(object2)) {
            return 4;
        }
        if (objectArray[4].equals(object2)) {
            return 5;
        }
        return -1;
    }

    public static int showYesNoCancel(Component component, Object object, String string, int n, Icon icon) {
        return Message.showYesNoCancel(component, object, string, n, icon, 0);
    }

    public static int showYesNoCancel(Component component, Object object, String string, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showYesNoCancel(Component,Object,String,int,Icon,int)", 562).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        if (customDialogs) {
            return Message.showAsDialog("yesnocancel", component, object, string, n, icon, n2);
        }
        Object[] objectArray = new Object[]{rb.getString("dialog.yes.name", "Yes"), rb.getString("dialog.no.name", "No"), rb.getString("dialog.cancel.name", "Cancel")};
        if (objectArray[0].equals(object2 = Message.show(component, object, string, 1, n, icon, objectArray, objectArray[0], n2))) {
            return 0;
        }
        if (objectArray[1].equals(object2)) {
            return 1;
        }
        if (objectArray[2].equals(object2)) {
            return 2;
        }
        return -1;
    }

    public static int showOKCancel(Component component, Object object, String string, int n, Icon icon) {
        return Message.showOKCancel(component, object, string, n, icon, 0);
    }

    public static int showOKCancel(Component component, Object object, String string, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showOKCancel(Component,Object,String,int,Icon,int)", 631).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        if (customDialogs) {
            return Message.showAsDialog("okcancel", component, object, string, n, icon, n2);
        }
        Object[] objectArray = new Object[]{rb.getString("dialog.ok.name", "OK"), rb.getString("dialog.cancel.name", "Cancel")};
        if (objectArray[0].equals(object2 = Message.show(component, object, string, 2, n, icon, objectArray, objectArray[0], n2))) {
            return 0;
        }
        if (objectArray[1].equals(object2)) {
            return 2;
        }
        return -1;
    }

    public static int showOK(Component component, Object object, String string, int n, Icon icon) {
        return Message.showOK(component, object, string, n, icon, 0);
    }

    public static int showOK(Component component, Object object, String string, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showOK(Component,Object,String,int,Icon,int)", 696).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        if (customDialogs) {
            return Message.showAsDialog("ok", component, object, string, n, icon, n2);
        }
        Object[] objectArray = new Object[]{rb.getString("dialog.ok.name", "OK")};
        if (objectArray[0].equals(object2 = Message.show(component, object, string, 2, n, icon, objectArray, objectArray[0], n2))) {
            return 0;
        }
        return -1;
    }

    public static int showCustom(Component component, Object object, String string, String string2, int n, Icon icon, int n2) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showCustom(Component,Object,String,String,int,Icon,int)", 735).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("overrideButtonRes", string2)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        String string3 = null;
        if (string2 != null) {
            string3 = rb.getString(string2 + ".dialog", null);
        }
        if (string3 != null) {
            return Message.showAsDialog(string3, component, object, string, n, icon, n2);
        }
        if (customDialogs) {
            return Message.showAsDialog("ok", component, object, string, n, icon, n2);
        }
        return Message.showOK(component, object, string, n, icon, n2);
    }

    public static int showMessageAndHighlight(Component component, String string) {
        return Message.showMessage(component, string, null, null, 0, true, null);
    }

    public static int showMessage(Component component, String string) {
        return Message.showMessage(component, string, null, 0);
    }

    public static int showMessageAndHighlight(Component component, String string, Object[] objectArray) {
        return Message.showMessage(component, string, null, objectArray, 0, true, null);
    }

    public static int showMessage(Component component, String string, Object[] objectArray) {
        return Message.showMessage(component, string, null, objectArray, 0, false, null);
    }

    public static int showMessage(Component component, String string, String string2, Object[] objectArray) {
        return Message.showMessage(component, string, string2, objectArray, 0, false, null);
    }

    public static int showMessage(Component component, String string, Object[] objectArray, int n) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showMessage(Component,String,Object[],int)", 909).addDetail("parent", component)).addDetail("resource", string)).addDetail("param", objectArray)).addDetail("timeout", n)).log();
        }
        return Message.showMessage(component, string, null, objectArray, n, false, null);
    }

    public static int showMessage(Component component, String string, String string2, Object[] objectArray, int n, boolean bl, String string3) {
        Object object;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showMessage(Component,String,String,Object[],int,boolean,String)", 941).addDetail("parent", component)).addDetail("resource", string)).addDetail("overrideButtonRes", string2)).addDetail("param", objectArray)).addDetail("timeout", n)).addDetail("doHighlight", bl)).addDetail("wrapTitleRes", string3)).log();
        }
        int n2 = 0;
        Object[] objectArray2 = null;
        Icon icon = null;
        n2 = rb.getInt(string + ".custom", 0);
        String string4 = rb.getString(string + ".message", null);
        if (string4 == null && n2 == 0) {
            string4 = "MISSING: " + string + ".message";
        }
        if (n2 > 0 && objectArray != null) {
            if (objectArray.length < n2) {
                throw new IllegalArgumentException("More custom objects needed than param array holds.");
            }
            objectArray2 = new Object[n2 + (string4 == null ? 0 : 1)];
            System.arraycopy(objectArray, 0, objectArray2, string4 == null ? 0 : 1, n2);
            if (objectArray.length > n2) {
                object = new Object[objectArray.length - n2];
                System.arraycopy(objectArray, n2, object, 0, objectArray.length - n2);
                objectArray = object;
            } else {
                objectArray = null;
            }
        }
        if (objectArray != null && objectArray.length > 0 && string4 != null) {
            object = new MessageFormat(string4);
            string4 = ((Format)object).format(objectArray);
        }
        if (objectArray2 != null && string4 != null) {
            objectArray2[0] = string4;
        }
        Object object2 = objectArray2 == null ? string4 : objectArray2;
        String string5 = rb.getString(string + ".title", string + ".title");
        if (string3 != null) {
            string5 = Message.format(string3 + ".title", new String[]{string5});
        }
        int n3 = ((String)(object = rb.getString(string + ".type", "error"))).equalsIgnoreCase("plain") ? -1 : (((String)object).equalsIgnoreCase("successful") ? 0 : (((String)object).equalsIgnoreCase("info") ? 1 : (((String)object).equalsIgnoreCase("question") ? 3 : (((String)object).equalsIgnoreCase("warning") ? 2 : 0))));
        icon = rb.getIcon(string + ".icon", null);
        if (bl) {
            if (Message.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "showMessage(Component,String,String,Object[],int,boolean,String)", 1015).add("Highlight parent component.")).log();
            }
            if (component instanceof OptionEdit) {
                ((OptionEdit)component).highlight(0, 0, n3, string4);
            } else if (Message.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "showMessage(Component,String,String,Object[],int,boolean,String)", 1020).add("No optionedit -> no highlight.")).log();
            }
            if (OptionEdit.isHighlightOnCheckOnly()) {
                return -1;
            }
        }
        String string6 = string2 != null ? rb.getString(string2 + ".dialog", null) : rb.getString(string + ".dialog", null);
        if (Message.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "showMessage(Component,String,String,Object[],int,boolean,String)", 1035).add("dlg", string6)).log();
        }
        if (string6 != null) {
            return Message.showAsDialog(string6, component, object2, string5, n3, icon, n);
        }
        String string7 = rb.getString(string + ".buttons", "ok");
        boolean bl2 = false;
        if (string7.startsWith("dialog:")) {
            bl2 = true;
            string7 = string7.substring(7);
        }
        if (bl2 && customDialogs) {
            return Message.showAsDialog(string7, component, object2, string5, n3, icon, n);
        }
        if (string7.equals("okcancel")) {
            return Message.showOKCancel(component, object2, string5, n3, icon, n);
        }
        if (string7.equals("yesno")) {
            return Message.showYesNo(component, object2, string5, n3, icon, n);
        }
        if (string7.equals("yesnocancel")) {
            return Message.showYesNoCancel(component, object2, string5, n3, icon, n);
        }
        if (string7.equals("yesnoforall")) {
            return Message.showYesNoForAll(component, object2, string5, n3, icon, n);
        }
        if (string7.equals("yesnoforallcancel")) {
            return Message.showYesNoForAllCancel(component, object2, string5, n3, icon, n);
        }
        if (string7.equals("custom")) {
            return Message.showCustom(component, string, object2, string5, n3, icon, n);
        }
        if (string7.equals("ok") || string7.isEmpty()) {
            return Message.showOK(component, object2, string5, n3, icon, n);
        }
        if (customDialogs) {
            return Message.showAsDialog(string, component, object2, string5, n3, icon, n);
        }
        return Message.showOK(component, object2, string5, n3, icon, n);
    }

    public static String format(String string, Object[] objectArray) {
        String string2 = rb.getString(string, null);
        if (objectArray == null || objectArray.length == 0) {
            return string2 == null ? string : string2;
        }
        String string3 = string2 == null ? string : string2;
        String string4 = new MessageFormat(string3).format(objectArray);
        if (!string.equals(string4)) {
            return string4;
        }
        if (string2 == null) {
            return string + "\n" + Misc.arrayToString(objectArray);
        }
        return string4;
    }

    public static String formatString(String string, Object ... objectArray) {
        return new MessageFormat(string).format(objectArray);
    }

    @NonNull
    public static String getResourceString(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("resource is marked non-null but is null");
        }
        return rb.getString(string, string);
    }

    @NonNull
    public static String getResourceString(@NonNull String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("resource is marked non-null but is null");
        }
        String string2 = Message.getResourceString(string);
        return Misc.emptyOrNull(string2) ? string2 : Message.format(string2, objectArray);
    }

    @Deprecated
    @NonNull
    public static String getRessourceString(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("resource is marked non-null but is null");
        }
        return rb.getString(string, string);
    }

    public static final void showCustomDialogs(boolean bl) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showCustomDialogs(boolean)", 1170).addDetail("custom", bl)).log();
        }
        customDialogs = bl;
    }

    public static boolean wasDialogClosedOrCanceled(int n) {
        return n == 2 || n == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object show(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2, int n3) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "show(Component,Object,String,int,int,Icon,Object[],Object,int)", 1240).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string)).addDetail("optionType", n)).addDetail("messageType", n2)).addDetail("icon", icon)).addDetail("options", objectArray)).addDetail("initialValue", object2)).addDetail("timeout", n3)).log();
        }
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        final JDialog jDialog = jOptionPane.createDialog(component, string);
        Message.setName(jDialog, n2);
        if (n3 > 0) {
            Timer timer = new Timer(n3, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jDialog.isShowing()) {
                        jDialog.setVisible(false);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        try {
            DefaultNotificationCenter.instance().postNotification(NOTIFY_SHOWING_DIALOG, jDialog);
            jDialog.show();
        }
        finally {
            DefaultNotificationCenter.instance().postNotification(NOTIFY_HIDING_DIALOG, jDialog);
        }
        jDialog.dispose();
        return jOptionPane.getValue();
    }

    private static int showCustom(Component component, String string, Object object, String string2, int n, Icon icon, int n2) {
        Object object2;
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showCustom(Component,String,Object,String,int,Icon,int)", 1292).addDetail("parent", component)).addDetail("resource", string)).addDetail("message", object)).addDetail("title", string2)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while ((object2 = rb.getString(string + ".button" + n3, null)) != null) {
            vector.addElement((String)object2);
            ++n3;
        }
        if (vector.size() == 0) {
            if (Message.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "showCustom(Component,String,Object,String,int,Icon,int)", 1310).add("Custom message but no button resources.")).log();
            }
            return Message.showOK(component, object, string2, n, icon, n2);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        object2 = Message.show(component, object, string2, 2, n, icon, objectArray, objectArray[0], n2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object2)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showAsDialog(String string, Component component, Object object, String string2, int n, Icon icon, int n2) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showAsDialog(String,Component,Object,String,int,Icon,int)", 1349).addDetail("name", string)).addDetail("parent", component)).addDetail("message", object)).addDetail("title", string2)).addDetail("messageType", n)).addDetail("icon", icon)).addDetail("timeout", n2)).log();
        }
        Window window = component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component));
        JOptionPane jOptionPane = new JOptionPane(object, n, -1, icon, null, null);
        Container container = new PaneUI(jOptionPane).createMessageArea();
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty("qflib.dialog.kind", "message");
        }
        ModalDialog modalDialog = new ModalDialog(string, window, container);
        modalDialog.init(rb);
        if (string2 != null) {
            modalDialog.setTitle(string2);
        }
        Message.setName(modalDialog, n);
        SwingUtil.closeOnEscape(modalDialog);
        final ModalDialog modalDialog2 = modalDialog;
        if (n2 > 0) {
            Timer timer = new Timer(n2, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (modalDialog2.isShowing()) {
                        modalDialog2.setVisible(false);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        try {
            DefaultNotificationCenter.instance().postNotification(NOTIFY_SHOWING_DIALOG, modalDialog);
            int n3 = modalDialog.doModal(component, true);
            return n3;
        }
        finally {
            DefaultNotificationCenter.instance().postNotification(NOTIFY_HIDING_DIALOG, modalDialog);
        }
    }

    private static void setName(Dialog dialog, int n) {
        switch (n) {
            case -1: {
                dialog.setName("Message.message");
            }
            case 1: {
                dialog.setName("Message.info");
            }
            case 3: {
                dialog.setName("Message.question");
            }
            case 2: {
                dialog.setName("Message.warning");
            }
            case 0: {
                dialog.setName("Message.error");
            }
        }
    }

    @NonNull
    public static JTextArea createMultilineMessage(String string) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createMultilineMessage(String)", 1544).addDetail("resource", string)).log();
        }
        JTextArea jTextArea = new JTextArea(Message.getResourceString(string + ".message2"));
        jTextArea.setEditable(false);
        jTextArea.setCursor(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        return jTextArea;
    }

    @Generated
    public static void setRb(MapResourceBundle mapResourceBundle) {
        if (Message.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setRb(MapResourceBundle)", 226).addDetail("rb", mapResourceBundle)).log();
        }
        rb = mapResourceBundle;
    }

    static {
        try {
            rb.fetchProperties("/de/qfs/lib/resources/properties/qflib", Message.class);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        hyperlinkListeners = new ArrayList<HyperlinkListener>();
    }

    public static class ParameterizedResource {
        private final String resource;
        private final String[] parameters;

        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ParameterizedResource.toString()", 1536).log();
            }
            return Message.format(this.resource, this.parameters);
        }

        @Generated
        public ParameterizedResource(String string, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ParameterizedResource.ParameterizedResource(String,String[])", 1531).addDetail("resource", string)).addDetail("parameters", stringArray)).log();
            }
            this.resource = string;
            this.parameters = stringArray;
        }

        @Generated
        public String getResource() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ParameterizedResource.getResource()", 1533).log();
            }
            return this.resource;
        }

        @Generated
        public String[] getParameters() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ParameterizedResource.getParameters()", 1534).log();
            }
            return this.parameters;
        }

        @Generated
        public boolean equals(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ParameterizedResource.equals(Object)", 1531).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof ParameterizedResource)) {
                return false;
            }
            ParameterizedResource parameterizedResource = (ParameterizedResource)object;
            if (!parameterizedResource.canEqual(this)) {
                return false;
            }
            String string = this.getResource();
            String string2 = parameterizedResource.getResource();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            return Arrays.deepEquals(this.getParameters(), parameterizedResource.getParameters());
        }

        @Generated
        protected boolean canEqual(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ParameterizedResource.canEqual(Object)", 1531).addDetail("other", object)).log();
            }
            return object instanceof ParameterizedResource;
        }

        @Generated
        public int hashCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ParameterizedResource.hashCode()", 1531).log();
            }
            int n = 1;
            String string = this.getResource();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            n = n * 59 + Arrays.deepHashCode(this.getParameters());
            return n;
        }
    }

    private static class PaneUI
    extends BasicOptionPaneUI {
        public PaneUI(JOptionPane jOptionPane) {
            this.optionPane = jOptionPane;
        }

        @Override
        public Container createMessageArea() {
            Container container = super.createMessageArea();
            JLabel jLabel = PaneUI.getIconLabel(container);
            if (jLabel != null) {
                Observer observer = notification -> jLabel.setIcon(this.getIcon());
                DefaultNotificationCenter.instance().addWeakObserver(observer, "user.theme.updatedUI");
                jLabel.putClientProperty("updateIconObserver", observer);
            }
            return container;
        }

        @Nullable
        private static JLabel getIconLabel(Container container) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "PaneUI.getIconLabel(Container)", 1484).addDetail("messageArea", container)).log();
            }
            for (Component component : container.getComponents()) {
                if (!(component instanceof JLabel)) continue;
                return (JLabel)component;
            }
            return null;
        }

        @Override
        protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "PaneUI.addMessageComponents(Container,GridBagConstraints,Object,int,boolean)", 1498).addDetail("container", container)).addDetail("cons", gridBagConstraints)).addDetail("msg", object)).addDetail("maxll", n)).addDetail("internallyCreated", bl)).log();
            }
            if (object instanceof String && ((String)object).length() > 6 && ((String)object).substring(0, 6).equalsIgnoreCase("<html>")) {
                object = ThemeSupport.extendHtmlWrapping("", (String)object);
                try {
                    JEditorPane jEditorPane = new JEditorPane("text/html", (String)object);
                    jEditorPane.setEditable(false);
                    for (HyperlinkListener hyperlinkListener : hyperlinkListeners) {
                        jEditorPane.addHyperlinkListener(hyperlinkListener);
                    }
                    jEditorPane.setForeground(UIManager.getColor("OptionPane.messageForeground"));
                    jEditorPane.setBackground(UIManager.getColor("OptionPane.messageBackground"));
                    super.addMessageComponents(container, gridBagConstraints, jEditorPane, n, true);
                }
                catch (Throwable throwable) {
                    if (logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "PaneUI.addMessageComponents(Container,GridBagConstraints,Object,int,boolean)", 1517).add("ex", throwable)).log();
                    }
                    super.addMessageComponents(container, gridBagConstraints, object, n, bl);
                }
            } else {
                super.addMessageComponents(container, gridBagConstraints, object, n, bl);
            }
        }
    }
}

