/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.AWTTreeAdapter;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.NotifyingJFrame;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import lombok.Generated;

public class QfFrame
extends NotifyingJFrame
implements ActionListener,
WindowListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.QfFrame");
    protected static final String[] defaultButtons = new String[]{"ok", "cancel"};
    protected String name;
    protected Component mainComponent;
    protected JPanel mainPanel;
    protected ButtonData[] buttons;
    JButton defaultButton;
    Component initialFocusTarget;
    protected GridBagLayout layout;
    protected JPanel panel;
    protected int minWidth;
    protected int minHeight;
    private boolean forceSize;
    private boolean maybeForceSize;

    public QfFrame(String string) {
        if (QfFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "QfFrame(String)", 258).addDetail("name", string)).log();
        }
        this.name = string;
    }

    public QfFrame(String string, Component component) {
        if (QfFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "QfFrame(String,Component)", 274).addDetail("name", string)).addDetail("com", component)).log();
        }
        this.name = string;
        this.mainComponent = component;
    }

    public void init(MapResourceBundle mapResourceBundle) {
        int n;
        String string;
        String string2;
        if (QfFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "init(MapResourceBundle)", 295).addDetail("rb", mapResourceBundle)).log();
        }
        if ((string2 = mapResourceBundle.getString(this.resName("title"), null)) != null) {
            this.setTitle(string2);
        }
        if ((string = mapResourceBundle.getString(this.resName("name"), null)) != null) {
            this.setName(string);
        } else {
            this.setName("QfFrame-" + this.name);
        }
        String[] stringArray = this.initButtonNames(mapResourceBundle);
        int n2 = stringArray == null ? 0 : stringArray.length;
        this.buttons = n2 == 0 ? null : new ButtonData[n2];
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            this.buttons[n] = this.initButton(stringArray[n], mapResourceBundle);
            this.buttons[n].button.addActionListener(this);
            box.add(this.buttons[n].button);
            if (n < n2 - 1) {
                box.add(Box.createHorizontalStrut(20));
            }
            box.add(Box.createHorizontalGlue());
            n3 = Math.max(n3, this.buttons[n].button.getPreferredSize().width);
            if (this.defaultButton != null || !this.buttons[n].deflt) continue;
            this.defaultButton = this.buttons[n].button;
        }
        if (this.buttons != null) {
            n = this.buttons[0].button.getPreferredSize().height;
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].button.setPreferredSize(new Dimension(n3, n));
            }
        }
        this.panel = new Grid();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.initComponent();
        if (this.mainComponent != null) {
            this.mainPanel.add(this.mainComponent, "Center");
        }
        ((Grid)this.panel).addLine(new Component[]{this.mainPanel}, 1.0);
        ((Grid)this.panel).addLine(new Component[]{Box.createVerticalStrut(10)});
        ((Grid)this.panel).addLine(new Component[]{box});
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panel.setMinimumSize(this.panel.getPreferredSize());
        this.setContentPane(this.panel);
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.minWidth = mapResourceBundle.getInt(this.resName("width"), -1);
        this.minHeight = mapResourceBundle.getInt(this.resName("height"), -1);
        this.forceSize = mapResourceBundle.getBoolean(this.resName("forcesize"), false);
        this.maybeForceSize = mapResourceBundle.getString(this.resName("forcesize"), null) == null;
        this.fixSize();
        SwingUtil.centerWindow(this);
        if (mapResourceBundle.getBoolean(this.resName("configure"), false)) {
            Configuration.instance().register(ConfigWrapper.makeWrapper(this, this.name + ".frame"));
        }
    }

    public void setMainComponent(Component component) {
        this.mainComponent = component;
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
            this.mainPanel.add(component, "Center");
            this.panel.revalidate();
            this.fixSize();
        }
    }

    public final void setInitialFocusTarget(Component component) {
        if (QfFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setInitialFocusTarget(Component)", 403).addDetail("initialFocusTarget", component)).log();
        }
        this.initialFocusTarget = component;
    }

    public void showFrame(boolean bl) {
        if (QfFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showFrame(boolean)", 419).addDetail("resetFocus", bl)).log();
        }
        if (this.initialFocusTarget != null || bl && this.buttons != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    QfFrame.this.requestFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QfFrame.this.requestFocus();
                            if (QfFrame.this.initialFocusTarget != null) {
                                if (logger.level >= 3) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "showFrame(boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 438).add("Requesting focus for ")).add(QfFrame.this.initialFocusTarget)).log();
                                }
                                QfFrame.this.initialFocusTarget.requestFocus();
                            } else {
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showFrame(boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 441).add("Calling focusNextComponent for ")).add(QfFrame.this.buttons[QfFrame.this.buttons.length - 1].button)).log();
                                }
                                FocusManager.getCurrentManager().focusNextComponent(QfFrame.this.buttons[QfFrame.this.buttons.length - 1].button);
                            }
                            if (logger.level >= 9) {
                                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "showFrame(boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 449).add("Focused window: ", keyboardFocusManager.getFocusedWindow())).log();
                                }
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "showFrame(boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 450).add("Focus owner: ", keyboardFocusManager.getFocusOwner())).log();
                                }
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showFrame(boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 451).add("Window's focus owner: ")).add("getFocusOwner()", QfFrame.this.getFocusOwner())).log();
                                }
                            }
                        }
                    });
                    QfFrame.this.removeWindowListener(this);
                }
            });
        }
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.setVisible(true);
    }

    public int getButtonCount() {
        return this.buttons == null ? 0 : this.buttons.length;
    }

    public JButton getButton(int n) throws IndexOutOfBoundsException {
        if (this.buttons == null) {
            throw new IndexOutOfBoundsException("no buttons");
        }
        return this.buttons[n].button;
    }

    public JButton getButton(String string) {
        if (this.buttons == null) {
            return null;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].name.equals(string)) continue;
            return this.buttons[i].button;
        }
        return null;
    }

    protected String[] initButtonNames(MapResourceBundle mapResourceBundle) {
        String string = mapResourceBundle.getString(this.resName("buttons"), null);
        if (string == null) {
            return defaultButtons;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected ButtonData initButton(String string, MapResourceBundle mapResourceBundle) {
        ButtonData buttonData = new ButtonData(string, mapResourceBundle);
        if (buttonData.focus) {
            this.setInitialFocusTarget(buttonData.button);
        }
        return buttonData;
    }

    protected void initComponent() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() instanceof JButton && (n = this.findButton((JButton)actionEvent.getSource())) >= 0 && this.buttons[n].close) {
            SwingUtil.deactivateInputContexts(this);
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        SwingUtil.deactivateInputContexts(this);
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    protected void fixSize() {
        int n;
        int n2;
        Object object;
        if (QfFrame.logger.level >= 7) {
            logger.lvlBuild(7, "fixSize()", 712).log();
        }
        this.pack();
        Dimension dimension = this.getSize();
        if (this.maybeForceSize) {
            object = new AWTTreeAdapter();
            Boolean bl = (Boolean)TreeUtil.visitTree((TreeAdapter)object, new SearchPaneVisitor(), this);
            boolean bl2 = this.forceSize = bl != null && bl != false;
        }
        if (this.forceSize && this.minWidth > 0 && this.minHeight > 0) {
            n2 = this.minWidth;
            n = this.minHeight;
        } else {
            n2 = Math.max(this.minWidth, dimension.width);
            n = Math.max(this.minHeight, dimension.height);
        }
        object = this.getToolkit().getScreenSize();
        n2 = Math.min(n2, ((Dimension)object).width);
        n = Math.min(n, ((Dimension)object).height);
        this.setSize(n2, n);
        this.pack();
        if (!this.forceSize) {
            dimension = this.getSize();
            n2 = Math.max(this.minWidth, dimension.width);
            n = Math.max(this.minHeight, dimension.height);
        }
        this.setSize(n2, n);
    }

    protected String resName(String string) {
        return "frame." + this.name + "." + string;
    }

    protected static String buttonResName(String string, String string2) {
        return "frame.button." + string + "." + string2;
    }

    protected int findButton(JButton jButton) {
        if (this.buttons == null) {
            return -1;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].button != jButton) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void dispose() {
        block8: {
            int n;
            Configuration.instance().unregisterAll(this.name + ".frame", true);
            SwingUtil.deactivateWindowTracking();
            JRootPane jRootPane = this.getRootPane();
            for (n = jRootPane.getKeyListeners().length - 1; n >= 0; --n) {
                jRootPane.removeKeyListener(jRootPane.getKeyListeners()[n]);
            }
            jRootPane.resetKeyboardActions();
            for (n = 0; n < this.getButtonCount(); ++n) {
                for (int i = this.getButton(n).getActionListeners().length - 1; i >= 0; --i) {
                    this.getButton(n).removeActionListener(this.getButton(n).getActionListeners()[i]);
                    this.getButton(n).resetKeyboardActions();
                }
            }
            this.buttons = null;
            for (n = this.getWindowStateListeners().length - 1; n >= 0; --n) {
                this.removeWindowStateListener(this.getWindowStateListeners()[n]);
            }
            for (n = this.getComponentListeners().length - 1; n >= 0; --n) {
                this.removeComponentListener(this.getComponentListeners()[n]);
            }
            for (n = this.getKeyListeners().length - 1; n >= 0; --n) {
                this.removeKeyListener(this.getKeyListeners()[n]);
            }
            SwingUtil.deactivateInputContexts(this);
            try {
                SwingUtil.cleanup(this);
            }
            catch (RuntimeException runtimeException) {
                if (QfFrame.logger.level < 3) break block8;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "dispose()", 855).add("ex", runtimeException)).log();
            }
        }
        super.dispose();
    }

    public static class SearchPaneVisitor {
        public SearchPaneVisitor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SearchPaneVisitor.SearchPaneVisitor()", 957).log();
            }
        }

        public Object visit(Object object) {
            return null;
        }

        public Object visit(JEditorPane jEditorPane) {
            if ("text/html".equals(jEditorPane.getContentType())) {
                throw new ReturnFromTraversalException(Boolean.TRUE);
            }
            return null;
        }
    }

    public static class ButtonData {
        public String name;
        public JButton button;
        public boolean close;
        public boolean deflt;
        public boolean focus;

        public ButtonData() {
        }

        public ButtonData(String string, MapResourceBundle mapResourceBundle) {
            this.name = string;
            String string2 = mapResourceBundle.getString(QfFrame.buttonResName(string, "label"), "MISSING: " + string);
            this.button = new JButton(string2);
            this.button.setName(mapResourceBundle.getString(QfFrame.buttonResName(string, "name"), "Button-" + string));
            this.button.setActionCommand(mapResourceBundle.getString(QfFrame.buttonResName(string, "action"), string));
            String string3 = mapResourceBundle.getString(QfFrame.buttonResName(string, "mnemonic"), null);
            if (string3 != null && string3.length() > 0) {
                this.button.setMnemonic(string3.charAt(0));
            }
            this.deflt = mapResourceBundle.getBoolean(QfFrame.buttonResName(string, "default"), false);
            if (!this.deflt) {
                this.button.setDefaultCapable(false);
            }
            this.close = mapResourceBundle.getBoolean(QfFrame.buttonResName(string, "close"), true);
            this.button.setEnabled(!mapResourceBundle.getBoolean(QfFrame.buttonResName(string, "disabled"), false));
            this.focus = mapResourceBundle.getBoolean(QfFrame.buttonResName(string, "focus"), false);
        }
    }
}

