/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.AbstractTextView;
import de.qfs.lib.gui.Borders;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import lombok.Generated;

public class RichTextView
extends AbstractTextView {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.RichTextView");
    private String configurableName = "RichTextView";
    protected boolean wrap = false;
    private StyledEditorKit nowrapEditorKit;
    private StyledEditorKit wrapEditorKit;
    private JPanel noWrapPanel;

    public RichTextView() {
        this(null, null);
    }

    public RichTextView(String string) {
        this(string, null);
    }

    public RichTextView(String string, StyledDocument styledDocument) {
        if (RichTextView.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RichTextView(String,StyledDocument)", 143).addDetail("contents", string)).addDetail("doc", styledDocument)).log();
        }
        this.textArea = new JTextPane(){

            @Override
            public boolean isManagingFocus() {
                return false;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBackground(UIManager.getColor("TerminalTextArea.background"));
                this.setBorder(new EmptyBorder(1, 2, 2, 2));
            }
        };
        this.nowrapEditorKit = (StyledEditorKit)((JTextPane)this.textArea).getEditorKit();
        this.wrapEditorKit = new WrapEditorKit();
        ((JTextPane)this.textArea).setEditorKit(this.nowrapEditorKit);
        if (styledDocument != null) {
            this.textArea.setDocument(styledDocument);
        }
        this.textArea.setText(string);
        this.textArea.setEditable(false);
        this.textArea.addFocusListener(this);
        this.textArea.getDocument().addDocumentListener(this);
        this.setVerticalScrollBarPolicy(22);
        this.getVerticalScrollBar().setUnitIncrement(this.textArea.getFontMetrics(this.textArea.getFont()).getHeight());
        this.getHorizontalScrollBar().setUnitIncrement(this.textArea.getFontMetrics(this.textArea.getFont()).getMaxAdvance());
        this.noWrapPanel = new JPanel();
        this.noWrapPanel.setLayout(new BorderLayout());
        this.setViewportView(this.noWrapPanel);
        this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLoweredBevelBorder());
        this.focusBorder = BorderFactory.createCompoundBorder(Borders.STIPPLE, BorderFactory.createLoweredBevelBorder());
        this.setBorder(null);
        this.textArea.addKeyListener(this.scrollListener);
        InputMap inputMap = this.textArea.getInputMap(0);
        SwingUtil.setTextActionsForInputMap(inputMap);
    }

    @Override
    public JTextPane getTextArea() {
        return (JTextPane)this.textArea;
    }

    @Override
    public void append(String string) {
        block7: {
            StyledDocument styledDocument;
            if (RichTextView.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "append(String)", 227).addDetail("text", string)).log();
            }
            if ((styledDocument = ((JTextPane)this.textArea).getStyledDocument()) != null) {
                try {
                    int n = styledDocument.getLength();
                    int n2 = string.lastIndexOf(10);
                    if (n2 > -1) {
                        this.lfIndex = n + n2;
                    }
                    styledDocument.insertString(n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    if (RichTextView.logger.level >= 1) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "append(String)", 239).add("e", badLocationException)).add("Error when appending text to terminal.")).log();
                    }
                }
                catch (Throwable throwable) {
                    if (RichTextView.logger.level < 1) break block7;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "append(String)", 241).add("t", throwable)).add("Error adding ")).add("text", string)).add(" to richtextview!")).log();
                }
            }
        }
        this.enforceLimit();
    }

    @Override
    public void append(String string, SimpleAttributeSet simpleAttributeSet) {
        block7: {
            StyledDocument styledDocument;
            if (RichTextView.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "append(String,SimpleAttributeSet)", 259).addDetail("text", string)).addDetail("attribs", simpleAttributeSet)).log();
            }
            if ((styledDocument = ((JTextPane)this.textArea).getStyledDocument()) != null) {
                try {
                    int n = styledDocument.getLength();
                    int n2 = string.lastIndexOf(10);
                    if (n2 > -1) {
                        this.lfIndex = n + n2;
                    }
                    styledDocument.insertString(styledDocument.getLength(), string, simpleAttributeSet);
                }
                catch (BadLocationException badLocationException) {
                    if (RichTextView.logger.level >= 1) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "append(String,SimpleAttributeSet)", 271).add("e", badLocationException)).add("Error when appending text to terminal.")).log();
                    }
                }
                catch (Throwable throwable) {
                    if (RichTextView.logger.level < 1) break block7;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "append(String,SimpleAttributeSet)", 273).add("t", throwable)).add("Error adding ")).add("text", string)).add("attribs", simpleAttributeSet)).add(" to richtextview!")).log();
                }
            }
        }
        this.enforceLimit();
    }

    @Override
    public void clearCurrentLine() {
        block6: {
            StyledDocument styledDocument;
            if (RichTextView.logger.level >= 7) {
                logger.lvlBuild(7, "clearCurrentLine()", 282).log();
            }
            if ((styledDocument = ((JTextPane)this.textArea).getStyledDocument()) != null) {
                try {
                    if (this.lfIndex >= 0) {
                        int n = this.lfIndex + 1;
                        styledDocument.remove(n, styledDocument.getLength() - n);
                    } else {
                        this.clear();
                    }
                }
                catch (Throwable throwable) {
                    if (RichTextView.logger.level < 1) break block6;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "clearCurrentLine()", 294).add("t", throwable)).add("Error when clearing text from terminal.")).log();
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.textArea != null) {
            this.textArea.getDocument().removeDocumentListener(this);
            this.textArea.setDocument(new JTextPane().getDocument());
            this.textArea = null;
        }
    }

    @Override
    public boolean getLineWrap() {
        return this.wrap;
    }

    @Override
    public void setLineWrap(boolean bl) {
        if (bl != this.wrap) {
            StyledDocument styledDocument = (StyledDocument)this.textArea.getDocument();
            final Point point = this.getViewport().getViewPosition();
            if (bl) {
                this.noWrapPanel.remove(this.textArea);
                ((JTextPane)this.textArea).setEditorKit(this.wrapEditorKit);
                this.setViewportView(this.textArea);
            } else {
                ((JTextPane)this.textArea).setEditorKit(this.nowrapEditorKit);
                this.noWrapPanel.add((Component)this.textArea, "Center");
                this.setViewportView(this.noWrapPanel);
            }
            this.textArea.setDocument(styledDocument);
            this.wrap = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (RichTextView.this.textArea == null) {
                        return;
                    }
                    RichTextView.this.getViewport().setViewPosition(point);
                }
            });
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
    }

    private class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public float getMinimumSpan(int n) {
            switch (n) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(n);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
    }

    private class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WrapColumnFactory.WrapColumnFactory()", 405).log();
            }
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new WrapLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }

    private class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        private WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WrapEditorKit.WrapEditorKit()", 392).log();
            }
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }
}

