/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.util.Misc;
import javax.swing.JLabel;

public class ThemeAwareJLabel
extends JLabel {
    String resourceName;
    String rawText;
    boolean initialized;

    public ThemeAwareJLabel(String string, String string2) {
        super(ThemeSupport.extendHtmlWrapping(string, string2));
        this.resourceName = string;
        this.rawText = Misc.equalOrNull(this.getText(), string2) ? null : string2;
        this.adjustTextColor();
        this.initialized = true;
    }

    @Override
    public void setText(String string) {
        if (!this.initialized) {
            super.setText(string);
            return;
        }
        super.setText(ThemeSupport.extendHtmlWrapping(this.resourceName, string));
        this.rawText = Misc.equalOrNull(this.getText(), string) ? null : string;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustTextColor();
        if (this.rawText != null) {
            super.setText(ThemeSupport.extendHtmlWrapping(this.resourceName, this.rawText));
        }
    }

    protected void adjustTextColor() {
    }
}

