/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class WindowsTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static Icon defaultIcon = new ImageIcon(WindowsTreeCellRenderer.class.getResource("/de/qfs/lib/resources/icons/stipple.gif"));
    private Icon icon = defaultIcon;
    int iconWidth;
    int iconHeight;
    private boolean hasFocus;
    boolean drawsFocusBorderAroundIcon;

    public WindowsTreeCellRenderer() {
        Object object;
        if (this.icon != null) {
            this.iconWidth = this.icon.getIconWidth();
            this.iconHeight = this.icon.getIconHeight();
        }
        this.drawsFocusBorderAroundIcon = (object = UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && (Boolean)object != false;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.hasFocus = bl4;
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4 && this.icon == null);
        return defaultTreeCellRenderer;
    }

    public void setBorderIcon(Icon icon) {
        this.icon = icon;
        this.iconWidth = icon.getIconWidth();
        this.iconHeight = icon.getIconHeight();
        if (this.iconWidth <= 0 || this.iconHeight <= 0) {
            icon = null;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.hasFocus && this.icon != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            Graphics graphics2 = graphics.create();
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (this.getIcon() != null) {
                n = this.getIcon().getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            graphics2.setClip(n, 0, n4 - n, 1);
            for (n2 = n; n2 < n4; n2 += this.iconWidth) {
                this.icon.paintIcon(this, graphics2, n2, 0);
            }
            graphics2.setClip(n, n5 - 1, n4 - n, 1);
            n3 = n5 - 1 - (n5 - 1) % this.iconHeight;
            for (n2 = n; n2 < n4; n2 += this.iconWidth) {
                this.icon.paintIcon(this, graphics2, n2, n3);
            }
            graphics2.setClip(n, 1, 1, n5 - 2);
            for (n3 = 0; n3 < n5; n3 += this.iconHeight) {
                this.icon.paintIcon(this, graphics2, n, n3);
            }
            graphics2.setClip(n4 - 1, 1, 1, n5 - 2);
            n2 = n4 - 1 - (n4 - 1 - n) % this.iconWidth;
            for (n3 = 0; n3 < n5; n3 += this.iconHeight) {
                this.icon.paintIcon(this, graphics2, n2, n3);
            }
            graphics2.dispose();
        }
    }
}

