/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;

public class WrappingBox
extends Box {
    final List<Component> elements = new LinkedList<Component>();
    private final int horizontalStrut;
    private final int verticalStrut;
    int lastTargetWidth = -1;

    public WrappingBox(int n, int n2) {
        super(1);
        this.horizontalStrut = n;
        this.verticalStrut = n2;
        super.add(Box.createVerticalGlue());
        WrappingBox wrappingBox = this;
        wrappingBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WrappingBox.this.relayout();
            }
        });
    }

    public void relayout() {
        Container container = this;
        while (container.getSize().width == 0 && container.getParent() != null) {
            container = container.getParent();
        }
        container.setForeground(Color.GREEN);
        Insets insets = container.getInsets();
        int n = container.getSize().width;
        if (n == 0) {
            n = container.getPreferredSize().width;
        }
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n -= insets.left + insets.right) == this.lastTargetWidth) {
            return;
        }
        this.lastTargetWidth = n;
        this.removeAll();
        Box box = this.addHorizontalBox(true);
        int n2 = 0;
        for (Component component : this.elements) {
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            double d = dimension.getWidth();
            if ((double)n2 + d + (double)this.horizontalStrut > (double)n) {
                box.add(Box.createHorizontalGlue());
                box = this.addHorizontalBox(false);
                n2 = 0;
            } else if (n2 > 0) {
                box.add(Box.createHorizontalStrut(this.horizontalStrut));
            }
            box.add(component);
            n2 = (int)((double)n2 + (d + (double)this.horizontalStrut));
        }
        box.add(Box.createHorizontalGlue());
        this.revalidate();
        this.repaint();
    }

    @Override
    public Component add(Component component) {
        this.elements.add(component);
        return component;
    }

    private Box addHorizontalBox(boolean bl) {
        if (!bl) {
            super.add(Box.createVerticalStrut(this.verticalStrut));
        }
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        super.add(box);
        super.add(Box.createVerticalGlue());
        return box;
    }
}

