/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree.filter;

import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;

public abstract class FilterTextTreeModelFilter
extends AbstractTreeModelFilter {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.filter.FilterTextTreeModelFilter");
    private String filterText;
    private boolean containsCapitalLetters = false;
    private boolean regexUsed = false;

    protected FilterTextTreeModelFilter(AbstractTreeModelFilter.FilterType filterType) {
        super(filterType);
        if (FilterTextTreeModelFilter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "FilterTextTreeModelFilter(FilterType)", 64).addDetail("type", (Object)filterType)).log();
        }
    }

    public void setFilterText(String string) {
        Object object;
        block10: {
            this.filterText = string;
            this.containsCapitalLetters = false;
            try {
                object = Pattern.compile("[A-Z]").matcher(Misc.quoteRegex(this.filterText));
                this.containsCapitalLetters = ((Matcher)object).find();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if (FilterTextTreeModelFilter.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setFilterText(String)", 87).add("PatternSyntaxException error occurred, something wrong in the pattern.")).log();
                }
            }
            catch (StackOverflowError stackOverflowError) {
                if (FilterTextTreeModelFilter.logger.level < 3) break block10;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "setFilterText(String)", 89).add("Stackoverflow error occurred, something wrong in the pattern.")).log();
            }
        }
        if (!this.containsCapitalLetters && !this.filterText.equals(this.filterText.toLowerCase())) {
            if (FilterTextTreeModelFilter.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setFilterText(String)", 93).add("Localized capital letters, so set containsCapitalLetters to true.")).log();
            }
            this.containsCapitalLetters = true;
        }
        this.regexUsed = false;
        if (this.filterText.indexOf("*") != -1 || this.filterText.indexOf("?") != -1) {
            this.regexUsed = true;
            object = "<QFS_STAR_20160916>";
            String string2 = "<QFS_QM_20160916>";
            this.filterText = this.filterText.replace("*", (CharSequence)object);
            this.filterText = this.filterText.replace("?", string2);
            this.filterText = Misc.quoteRegex(this.filterText);
            this.filterText = this.filterText.replace((CharSequence)object, ".*");
            this.filterText = this.filterText.replace(string2, ".");
        }
        if (FilterTextTreeModelFilter.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setFilterText(String)", 110).add("Filtertext to use: ", this.filterText)).log();
        }
        if (FilterTextTreeModelFilter.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setFilterText(String)", 111).add("regexUsed to use: ", this.regexUsed)).log();
        }
        if (FilterTextTreeModelFilter.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setFilterText(String)", 112).add("containsCapitalLetters to use: ", this.containsCapitalLetters)).log();
        }
        this.setActive(true);
    }

    public void reset() {
        if (FilterTextTreeModelFilter.logger.level >= 7) {
            logger.lvlBuild(7, "reset()", 120).log();
        }
        this.filterText = null;
        this.regexUsed = false;
        this.containsCapitalLetters = false;
        this.setActive(false);
    }

    protected boolean matchesFilterText(String string) {
        if (FilterTextTreeModelFilter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(String)", 138).addDetail("fullname", string)).log();
        }
        if (Misc.emptyOrNull(this.filterText)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (FilterTextTreeModelFilter.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "matchesFilterText(String)", 150).add("Do filter with filterText:", this.filterText)).add(" on fullname: ")).add("fullname", string)).log();
        }
        String string2 = this.filterText;
        if (this.regexUsed) {
            if (!this.containsCapitalLetters) {
                string2 = "(?i)" + this.filterText;
            }
            try {
                Matcher matcher = Pattern.compile(string2).matcher(string);
                return matcher.find();
            }
            catch (RuntimeException | StackOverflowError throwable) {
                return false;
            }
        }
        if (!this.containsCapitalLetters) {
            string2 = this.filterText.toLowerCase();
            string = string.toLowerCase();
        }
        return string.indexOf(string2) != -1;
    }

    @Generated
    public String getFilterText() {
        return this.filterText;
    }

    @Generated
    public boolean isContainsCapitalLetters() {
        if (FilterTextTreeModelFilter.logger.level >= 7) {
            logger.lvlBuild(7, "isContainsCapitalLetters()", 48).log();
        }
        return this.containsCapitalLetters;
    }

    @Generated
    public boolean isRegexUsed() {
        if (FilterTextTreeModelFilter.logger.level >= 7) {
            logger.lvlBuild(7, "isRegexUsed()", 54).log();
        }
        return this.regexUsed;
    }
}

