/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree.filter;

import de.qfs.lib.gui.PlaceholderTextField;
import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.FilteredTreeHelper;
import de.qfs.lib.gui.tree.FilteredTreeModel;
import de.qfs.lib.gui.tree.TreeModelFilter;
import de.qfs.lib.gui.tree.filter.FilterTextTreeModelFilter;
import de.qfs.lib.gui.tree.filter.IFilteredTreeTextfieldTarget;
import de.qfs.lib.gui.tree.hierarchyfilter.HierarchicalTreeModelAdapter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import lombok.Generated;
import lombok.NonNull;

public class FilteredTreeGUIHelper {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.filter.FilteredTreeGUIHelper");
    protected PlaceholderTextField filterTextField;
    private FilteredTreeHelper treeHelper;
    private IFilteredTreeTextfieldTarget filterTarget;
    private String prevFilterText = "";
    private KeyListener jumpToFilterListener = new JumpToFilterListener();
    protected boolean searchFlag = false;
    protected boolean selectRootAfterSearchFlag = true;

    public void prepare(JTree jTree, TreeAdapter treeAdapter, AbstractTreeModelFilter abstractTreeModelFilter, @Nullable TreeCellRenderer treeCellRenderer) {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "prepare(JTree,TreeAdapter,AbstractTreeModelFilter,TreeCellRenderer)", 139).addDetail("tree", jTree)).addDetail("adapter", treeAdapter)).addDetail("treeFilter", abstractTreeModelFilter)).addDetail("renderer", treeCellRenderer)).log();
        }
        this.treeHelper = new FilteredTreeHelper(jTree, treeAdapter, abstractTreeModelFilter);
        this.treeHelper.setTreeNodeRenderer(treeCellRenderer);
        this.treeHelper.prepareTree();
    }

    public JPanel setupTreeWithFilterField(IFilteredTreeTextfieldTarget iFilteredTreeTextfieldTarget, JComponent jComponent, String string, String string2, String string3, boolean bl) {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setupTreeWithFilterField(IFilteredTreeTextfieldTarget,JComponent,String,String,String,boolean)", 163).addDetail("target", iFilteredTreeTextfieldTarget)).addDetail("treePane", jComponent)).addDetail("placeholder", string)).addDetail("name", string2)).addDetail("tooltip", string3)).addDetail("withShortCut", bl)).log();
        }
        JComponent jComponent2 = this.initialiseFilterTextField(iFilteredTreeTextfieldTarget, string, string2, string3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent2, "North");
        jPanel.add((Component)jComponent, "Center");
        if (bl) {
            KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_SEARCH_SYSTEM);
            ActionListener actionListener = actionEvent -> this.filterTextField.requestFocusInWindow();
            jPanel.registerKeyboardAction(actionListener, keyStroke, 2);
        }
        return jPanel;
    }

    private JComponent initialiseFilterTextField(IFilteredTreeTextfieldTarget iFilteredTreeTextfieldTarget, String string, String string2, String string3) {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "initialiseFilterTextField(IFilteredTreeTextfieldTarget,String,String,String)", 184).addDetail("target", iFilteredTreeTextfieldTarget)).addDetail("placeholder", string)).addDetail("name", string2)).addDetail("tooltip", string3)).log();
        }
        this.filterTarget = iFilteredTreeTextfieldTarget;
        this.filterTextField = new PlaceholderTextField();
        this.filterTextField.setPlaceholder(string);
        this.filterTextField.setName(string2);
        this.filterTextField.setToolTipText(string3);
        JComponent jComponent = this.createWrapperPanel();
        this.initialiseKeyListeners();
        this.initialiseTextfieldBorder();
        return jComponent;
    }

    protected void initialiseKeyListeners() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "initialiseKeyListeners()", 200).log();
        }
        this.filterTextField.addKeyListener(new FilterTextFieldListener());
        this.filterTextField.addKeyListener(new JumpToTreeListener());
    }

    protected void initialiseTextfieldBorder() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "initialiseTextfieldBorder()", 207).log();
        }
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 1, 0, 1, UIManager.getColor("FilteredTextField.borderColor"));
        Border border = BorderFactory.createEmptyBorder(1, 2, 2, 0);
        this.filterTextField.setBorder(new CompoundBorder(matteBorder, border));
    }

    protected JComponent createWrapperPanel() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "createWrapperPanel()", 216).log();
        }
        return this.filterTextField;
    }

    public void registerTreeListeners(JTree jTree) {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "registerTreeListeners(JTree)", 230).addDetail("tree", jTree)).log();
        }
        jTree.removeKeyListener(this.jumpToFilterListener);
        jTree.addKeyListener(this.jumpToFilterListener);
    }

    public TreeModelFilter getFilter() {
        if (this.treeHelper == null) {
            return null;
        }
        return this.treeHelper.getFilter();
    }

    public void doUpdateFilter(boolean bl, JTree jTree, boolean bl2) {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "doUpdateFilter(boolean,JTree,boolean)", 265).addDetail("doReset", bl)).addDetail("tree", jTree)).addDetail("expandAfterSearch", bl2)).dumpStack();
        }
        if (this.getTreeHelper() == null) {
            if (FilteredTreeGUIHelper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 267).add("No helper")).log();
            }
            return;
        }
        FilterTextTreeModelFilter filterTextTreeModelFilter = (FilterTextTreeModelFilter)this.getTreeHelper().getFilter();
        if (filterTextTreeModelFilter == null) {
            if (FilteredTreeGUIHelper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 272).add("No filter")).log();
            }
            return;
        }
        boolean bl3 = filterTextTreeModelFilter.isActive();
        if (FilteredTreeGUIHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 276).add("isActive", bl3)).log();
        }
        if (bl && !bl3) {
            if (FilteredTreeGUIHelper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 280).add("No active filter to reset, so leave.")).log();
            }
            this.filterTextField.setText("");
            this.prevFilterText = "";
            return;
        }
        String string = this.getFilterTextField().getText();
        if (FilteredTreeGUIHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 287).add("txt", string)).add("prevFilterText", this.prevFilterText)).log();
        }
        if (!bl && !Misc.emptyOrNull(this.prevFilterText) && this.prevFilterText.equals(string)) {
            if (FilteredTreeGUIHelper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 290).add("No filter change, leave.")).log();
            }
            return;
        }
        FilteredTreeModel filteredTreeModel = (FilteredTreeModel)jTree.getModel();
        filterTextTreeModelFilter.reset();
        filteredTreeModel.maybeUpdateFilter();
        filterTextTreeModelFilter.fireFilterChanged();
        jTree.treeDidChange();
        if (bl || Misc.emptyOrNull(string)) {
            this.filterTextField.setText("");
            this.prevFilterText = "";
        } else {
            filterTextTreeModelFilter.setFilterText(string);
            filteredTreeModel.maybeUpdateFilter();
            filterTextTreeModelFilter.fireFilterChanged();
            if (bl2) {
                for (int i = 0; i < jTree.getRowCount(); ++i) {
                    jTree.expandRow(i);
                }
            }
            jTree.treeDidChange();
            this.prevFilterText = string;
        }
        if (this.selectRootAfterSearchFlag && jTree.isSelectionEmpty() && jTree.getRowCount() > 0) {
            jTree.setSelectionRow(0);
        }
        this.setSearchFlag(true);
        this.getFilterTextField().requestFocusInWindow();
        if (FilteredTreeGUIHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "doUpdateFilter(boolean,JTree,boolean)", 329).add("prevFilterText", this.prevFilterText)).log();
        }
    }

    @NonNull
    public List<Integer> collectExpandedRowsFromHierarchicalFilter(JTree jTree) {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "collectExpandedRowsFromHierarchicalFilter(JTree)", 344).addDetail("tree", jTree)).log();
        }
        if (jTree.getModel() instanceof FilteredTreeModel) {
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)jTree.getModel();
            ExpansionCollectorTraversal expansionCollectorTraversal = new ExpansionCollectorTraversal(jTree);
            TreeUtil.traverse(filteredTreeModel.getFilteredTreeAdapter(), filteredTreeModel.getRoot(), expansionCollectorTraversal);
            return Collections.unmodifiableList(expansionCollectorTraversal.getExpandedRows());
        }
        return Collections.emptyList();
    }

    public void cleanup() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 363).log();
        }
        if (this.filterTextField != null) {
            KeyListener[] keyListenerArray = this.filterTextField.getKeyListeners();
            for (int i = 0; i < keyListenerArray.length; ++i) {
                this.filterTextField.removeKeyListener(keyListenerArray[i]);
            }
            this.filterTextField.resetKeyboardActions();
        }
        this.getTreeHelper().getTree().removeKeyListener(this.jumpToFilterListener);
        this.jumpToFilterListener = null;
        this.getTreeHelper().cleanup();
    }

    public void setFilterText(String string) {
        if (this.filterTextField != null) {
            this.filterTextField.setText(string);
            this.filterTarget.doUpdateFilter(false);
        }
    }

    @Generated
    public FilteredTreeGUIHelper() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "FilteredTreeGUIHelper()", 73).log();
        }
    }

    @Generated
    public PlaceholderTextField getFilterTextField() {
        return this.filterTextField;
    }

    @Generated
    public FilteredTreeGUIHelper setFilterTextField(PlaceholderTextField placeholderTextField) {
        this.filterTextField = placeholderTextField;
        return this;
    }

    @Generated
    public FilteredTreeHelper getTreeHelper() {
        return this.treeHelper;
    }

    @Generated
    public FilteredTreeGUIHelper setTreeHelper(FilteredTreeHelper filteredTreeHelper) {
        this.treeHelper = filteredTreeHelper;
        return this;
    }

    @Generated
    public IFilteredTreeTextfieldTarget getFilterTarget() {
        return this.filterTarget;
    }

    @Generated
    public FilteredTreeGUIHelper setFilterTarget(IFilteredTreeTextfieldTarget iFilteredTreeTextfieldTarget) {
        this.filterTarget = iFilteredTreeTextfieldTarget;
        return this;
    }

    @Generated
    public String getPrevFilterText() {
        return this.prevFilterText;
    }

    @Generated
    public KeyListener getJumpToFilterListener() {
        return this.jumpToFilterListener;
    }

    @Generated
    public FilteredTreeGUIHelper setSearchFlag(boolean bl) {
        this.searchFlag = bl;
        return this;
    }

    @Generated
    public boolean isSearchFlag() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "isSearchFlag()", 116).log();
        }
        return this.searchFlag;
    }

    @Generated
    public FilteredTreeGUIHelper setSelectRootAfterSearchFlag(boolean bl) {
        this.selectRootAfterSearchFlag = bl;
        return this;
    }

    @Generated
    public boolean isSelectRootAfterSearchFlag() {
        if (FilteredTreeGUIHelper.logger.level >= 7) {
            logger.lvlBuild(7, "isSelectRootAfterSearchFlag()", 123).log();
        }
        return this.selectRootAfterSearchFlag;
    }

    protected class ExpansionCollectorTraversal
    implements TraversalCallback {
        @NonNull
        protected final List<Integer> expandedRows = new ArrayList<Integer>();
        protected final JTree tree;

        public ExpansionCollectorTraversal(JTree jTree) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ExpansionCollectorTraversal.ExpansionCollectorTraversal(JTree)", 584).addDetail("tree", jTree)).log();
            }
            this.tree = jTree;
        }

        @Override
        public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ExpansionCollectorTraversal.nodeEntered(Traversal)", 593).addDetail("traversal", traversal)).log();
            }
            Object object = traversal.getNode();
            HierarchicalTreeModelAdapter hierarchicalTreeModelAdapter = (HierarchicalTreeModelAdapter)traversal.getAdapter();
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)this.tree.getModel();
            if (filteredTreeModel != null && filteredTreeModel.getTree() != null) {
                Object[] objectArray = TreeUtil.getPath(hierarchicalTreeModelAdapter, object);
                TreePath treePath = new TreePath(objectArray);
                int n = filteredTreeModel.getTree().getRowForPath(treePath);
                boolean bl = filteredTreeModel.getTree().isExpanded(n);
                if (bl) {
                    this.expandedRows.add(n);
                }
            }
            return true;
        }

        @Override
        public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ExpansionCollectorTraversal.nodeExited(Traversal)", 616).addDetail("traversal", traversal)).log();
            }
        }

        @NonNull
        @Generated
        public List<Integer> getExpandedRows() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ExpansionCollectorTraversal.getExpandedRows()", 576).log();
            }
            return this.expandedRows;
        }
    }

    public class JumpToFilterListener
    implements KeyListener {
        protected int[] selectedRows;

        public JumpToFilterListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "JumpToFilterListener.JumpToFilterListener()", 520).log();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "JumpToFilterListener.keyPressed(KeyEvent)", 529).addDetail("e", keyEvent)).log();
            }
            if ((n = keyEvent.getKeyCode()) == 38 && FilteredTreeGUIHelper.this.getTreeHelper().getTree() != null) {
                this.selectedRows = FilteredTreeGUIHelper.this.getTreeHelper().getTree().getSelectionRows();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int[] nArray;
            JTree jTree;
            int n;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "JumpToFilterListener.keyReleased(KeyEvent)", 541).addDetail("e", keyEvent)).log();
            }
            if ((n = keyEvent.getKeyCode()) == 38 && (jTree = FilteredTreeGUIHelper.this.getTreeHelper().getTree()) != null && this.selectedRows != null && this.selectedRows.length > 0 && (nArray = jTree.getSelectionRows()) != null && nArray.length > 0 && this.selectedRows[0] == 0 && nArray[0] == 0) {
                FilteredTreeGUIHelper.this.filterTextField.requestFocusInWindow();
            }
            this.selectedRows = null;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "JumpToFilterListener.keyTyped(KeyEvent)", 560).addDetail("e", keyEvent)).log();
            }
        }
    }

    public class JumpToTreeListener
    implements KeyListener {
        private int lastPos = -1;

        public JumpToTreeListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "JumpToTreeListener.JumpToTreeListener()", 461).log();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "JumpToTreeListener.keyPressed(KeyEvent)", 475).addDetail("e", keyEvent)).log();
            }
            this.lastPos = FilteredTreeGUIHelper.this.filterTextField.getCaretPosition();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "JumpToTreeListener.keyReleased(KeyEvent)", 484).addDetail("e", keyEvent)).log();
            }
            int n = FilteredTreeGUIHelper.this.filterTextField.getCaretPosition();
            int n2 = keyEvent.getKeyCode();
            if (n2 == 39) {
                if (n == this.lastPos) {
                    FilteredTreeGUIHelper.this.getTreeHelper().getTree().requestFocusInWindow();
                    keyEvent.consume();
                }
            } else if (n2 == 40) {
                FilteredTreeGUIHelper.this.getTreeHelper().getTree().requestFocusInWindow();
                keyEvent.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "JumpToTreeListener.keyTyped(KeyEvent)", 506).addDetail("e", keyEvent)).log();
            }
        }
    }

    public class FilterTextFieldListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "FilterTextFieldListener.keyPressed(KeyEvent)", 405).addDetail("e", keyEvent)).log();
            }
            if ((n = keyEvent.getKeyCode()) == 10) {
                keyEvent.consume();
                SwingUtilities.invokeLater(() -> FilteredTreeGUIHelper.this.filterTarget.doUpdateFilter(false));
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "FilterTextFieldListener.keyReleased(KeyEvent)", 415).addDetail("e", keyEvent)).log();
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if (n == 10 || n == 9 || n == 16 || n == 17 || n == 157 || n == 18 || n == 524 || n == 65406 || n == 37 || n == 39 || n == 40 || n == 38 || n == 36 || n == 35 || n == 34 || n == 33 || n == 155 || n == 19 || n == 154 || n == 144 || n == 20 || n == 27 || n == 70 && n2 == 2) {
                return;
            }
            FilteredTreeGUIHelper.this.filterTarget.doUpdateFilter(false);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "FilterTextFieldListener.keyTyped(KeyEvent)", 449).addDetail("e", keyEvent)).log();
            }
        }

        @Generated
        public FilterTextFieldListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "FilterTextFieldListener.FilterTextFieldListener()", 400).log();
            }
        }
    }
}

