/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree.flatfilter;

import de.qfs.lib.gui.tree.AbstractTreeFilterTraversal;
import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.FilteredTreeModel;
import de.qfs.lib.gui.tree.FilteredTreeModelAdapter;
import de.qfs.lib.gui.tree.flatfilter.FlatTreeModelAdapter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TreeUtil;
import java.util.ArrayList;
import javax.swing.tree.TreeModel;
import lombok.Generated;

public class FlatTreeFilterTraversal
extends AbstractTreeFilterTraversal {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.flatfilter.FlatTreeFilterTraversal");
    private ArrayList<Object> leaveNodes = new ArrayList();

    public FlatTreeFilterTraversal(FilteredTreeModel filteredTreeModel) {
        super(filteredTreeModel);
        if (FlatTreeFilterTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "FlatTreeFilterTraversal(FilteredTreeModel)", 71).addDetail("model", filteredTreeModel)).log();
        }
    }

    @Override
    public void cleanup() {
        if (FlatTreeFilterTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 87).log();
        }
        this.leaveNodes.clear();
        this.leaveNodes = null;
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildMap() {
        if (FlatTreeFilterTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "buildMap()", 102).log();
        }
        FilteredTreeModel filteredTreeModel = this.getFilteredModel();
        FilteredTreeModelAdapter filteredTreeModelAdapter = (FilteredTreeModelAdapter)filteredTreeModel.getAdapter();
        AbstractTreeModelFilter abstractTreeModelFilter = filteredTreeModel.getFilter();
        Object object = filteredTreeModel.getRoot();
        try {
            filteredTreeModelAdapter.setUseFullModel(true);
            if (abstractTreeModelFilter != null && !abstractTreeModelFilter.isActive()) {
                int n;
                filteredTreeModelAdapter.setUseFullModel(false);
                for (n = filteredTreeModelAdapter.getChildCount(object) - 1; n >= 0; --n) {
                    filteredTreeModel.nodeRemoved(TreeUtil.getPath(filteredTreeModelAdapter, object), filteredTreeModelAdapter.getIndexOfChildNode(object, filteredTreeModelAdapter.getChildNode(object, n)));
                }
                filteredTreeModelAdapter.setUseFullModel(true);
                ((FlatTreeModelAdapter)filteredTreeModelAdapter).setLeaveNodes(null);
                for (n = 0; n < filteredTreeModelAdapter.getChildCount(object); ++n) {
                    filteredTreeModel.nodeInserted(TreeUtil.getPath(filteredTreeModelAdapter, object), n);
                }
                return;
            }
            this.leaveNodes.clear();
            TreeUtil.traverse(filteredTreeModelAdapter, object, this);
            if (abstractTreeModelFilter != null && abstractTreeModelFilter.isActive()) {
                int n;
                for (n = filteredTreeModelAdapter.getChildCount(object) - 1; n >= 0; --n) {
                    filteredTreeModel.nodeRemoved(TreeUtil.getPath(filteredTreeModelAdapter, object), filteredTreeModelAdapter.getIndexOfChildNode(object, filteredTreeModelAdapter.getChildNode(object, n)));
                }
                ((FlatTreeModelAdapter)filteredTreeModelAdapter).setLeaveNodes(this.leaveNodes);
                filteredTreeModelAdapter.setUseFullModel(false);
                for (n = 0; n < this.leaveNodes.size(); ++n) {
                    filteredTreeModel.nodeInserted(TreeUtil.getPath(filteredTreeModelAdapter, object), n);
                }
            }
        }
        finally {
            filteredTreeModelAdapter.setUseFullModel(false);
        }
    }

    @Override
    public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
        Object object;
        if (FlatTreeFilterTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeEntered(Traversal)", 168).addDetail("traversal", traversal)).log();
        }
        if ((object = traversal.getNode()) == null) {
            if (FlatTreeFilterTraversal.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "nodeEntered(Traversal)", 172).add("No node??")).log();
            }
            return false;
        }
        if (this.isInitialize()) {
            if (FlatTreeFilterTraversal.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "nodeEntered(Traversal)", 177).add("Add entry in any case as initialization or no index map.")).log();
            }
            return true;
        }
        TreeModel treeModel = this.getFilteredModel().getFilteredTreeAdapter().getModel();
        AbstractTreeModelFilter abstractTreeModelFilter = this.getFilteredModel().getFilter();
        if (treeModel.getRoot() == object) {
            if (FlatTreeFilterTraversal.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "nodeEntered(Traversal)", 185).add("Keep root in any case.")).log();
            }
        } else if (treeModel.getChildCount(object) > 0) {
            if (FlatTreeFilterTraversal.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "nodeEntered(Traversal)", 189).add("Don't filter nodes with children.")).log();
            }
        } else if (treeModel.isLeaf(object) || treeModel.getChildCount(object) == 0) {
            boolean bl = true;
            if (abstractTreeModelFilter != null) {
                bl = abstractTreeModelFilter.filter(treeModel, object);
            }
            if (bl) {
                this.leaveNodes.add(object);
            }
        }
        return true;
    }

    @Override
    public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
        if (FlatTreeFilterTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeExited(Traversal)", 207).addDetail("traversal", traversal)).log();
        }
    }
}

