/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree.hierarchyfilter;

import de.qfs.lib.gui.tree.AbstractTreeFilterTraversal;
import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.FilteredTreeModel;
import de.qfs.lib.gui.tree.FilteredTreeModelAdapter;
import de.qfs.lib.gui.tree.hierarchyfilter.HierarchicalTreeModelAdapter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.TreeModel;
import lombok.Generated;

public class HierarchicalTreeFilterTraversal
extends AbstractTreeFilterTraversal {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.hierarchyfilter.HierarchicalTreeFilterTraversal");
    private ArrayList<Object> nodesToAdd = new ArrayList();
    private HashMap<Object, ArrayList<Object>> indexMap = new HashMap();
    private HashSet<Object> keepMask = new HashSet();
    private boolean filterInternalNodes = false;

    public HierarchicalTreeFilterTraversal(FilteredTreeModel filteredTreeModel) {
        super(filteredTreeModel);
        if (HierarchicalTreeFilterTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "HierarchicalTreeFilterTraversal(FilteredTreeModel)", 97).addDetail("model", filteredTreeModel)).log();
        }
    }

    @Override
    public void cleanup() {
        if (HierarchicalTreeFilterTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 113).log();
        }
        if (this.indexMap != null) {
            this.indexMap.clear();
        }
        this.indexMap = null;
        this.keepMask = null;
        this.nodesToAdd = null;
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildMap() {
        if (HierarchicalTreeFilterTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "buildMap()", 132).log();
        }
        FilteredTreeModel filteredTreeModel = this.getFilteredModel();
        FilteredTreeModelAdapter filteredTreeModelAdapter = (FilteredTreeModelAdapter)filteredTreeModel.getAdapter();
        AbstractTreeModelFilter abstractTreeModelFilter = filteredTreeModel.getFilter();
        Object object = filteredTreeModel.getRoot();
        try {
            filteredTreeModelAdapter.setUseFullModel(true);
            if (abstractTreeModelFilter != null && !abstractTreeModelFilter.isActive()) {
                int n;
                filteredTreeModelAdapter.setUseFullModel(false);
                for (n = filteredTreeModelAdapter.getChildCount(object) - 1; n >= 0; --n) {
                    filteredTreeModel.nodeRemoved(TreeUtil.getPath(filteredTreeModelAdapter, object), filteredTreeModelAdapter.getIndexOfChildNode(object, filteredTreeModelAdapter.getChildNode(object, n)));
                }
                filteredTreeModelAdapter.setUseFullModel(true);
                ((HierarchicalTreeModelAdapter)filteredTreeModelAdapter).setIndexMap(null);
                for (n = 0; n < filteredTreeModelAdapter.getChildCount(object); ++n) {
                    filteredTreeModel.nodeInserted(TreeUtil.getPath(filteredTreeModelAdapter, object), n);
                }
                return;
            }
            this.nodesToAdd.clear();
            this.indexMap.clear();
            this.keepMask.clear();
            TreeUtil.traverse(filteredTreeModelAdapter, object, this);
            if (abstractTreeModelFilter != null && abstractTreeModelFilter.isActive()) {
                for (int i = filteredTreeModelAdapter.getChildCount(object) - 1; i >= 0; --i) {
                    int n = filteredTreeModelAdapter.getIndexOfChildNode(object, filteredTreeModelAdapter.getChildNode(object, i));
                    if (n < 0) continue;
                    filteredTreeModel.nodeRemoved(TreeUtil.getPath(filteredTreeModelAdapter, object), n);
                }
                ((HierarchicalTreeModelAdapter)filteredTreeModelAdapter).setIndexMap(this.indexMap);
                filteredTreeModelAdapter.setUseFullModel(false);
                for (Object object2 : this.nodesToAdd) {
                    Object object3;
                    int n;
                    if (object2 == object || (n = filteredTreeModelAdapter.getIndexOfChildNode(object3 = filteredTreeModelAdapter.getParentNode(object2), object2)) < 0) continue;
                    filteredTreeModel.nodeInserted(TreeUtil.getPath(filteredTreeModelAdapter, object3), n);
                }
            }
        }
        finally {
            filteredTreeModelAdapter.setUseFullModel(false);
        }
        this.nodesToAdd.clear();
        this.keepMask.clear();
    }

    @Override
    public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
        Object object = traversal.getNode();
        if (object == null) {
            if (HierarchicalTreeFilterTraversal.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "nodeEntered(Traversal)", 222).add("No node??")).add("traversal", traversal)).log();
            }
            return false;
        }
        if (this.isInitialize()) {
            if (HierarchicalTreeFilterTraversal.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "nodeEntered(Traversal)", 227).add("Add entry in any case as initialization or no index map.")).log();
            }
            return true;
        }
        TreeModel treeModel = this.getFilteredModel().getFilteredTreeAdapter().getModel();
        AbstractTreeModelFilter abstractTreeModelFilter = this.getFilteredModel().getFilter();
        boolean bl = true;
        if (treeModel.getRoot() != object) {
            if (!treeModel.isLeaf(object)) {
                if (this.filterInternalNodes) {
                    if (abstractTreeModelFilter != null) {
                        bl = abstractTreeModelFilter.filter(treeModel, object);
                    }
                } else {
                    bl = false;
                }
            } else if (abstractTreeModelFilter != null) {
                bl = abstractTreeModelFilter.filter(treeModel, object);
            }
        }
        this.addEntry(object, bl);
        return true;
    }

    @Override
    public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
        Object object = traversal.getNode();
        if (this.indexMap.containsKey(object)) {
            if (!this.keepMask.contains(object)) {
                ArrayList<Object> arrayList = this.indexMap.get(object);
                boolean bl = arrayList.stream().anyMatch(this.keepMask::contains);
                if (bl) {
                    this.keepMask.add(object);
                } else {
                    this.removeNode(object);
                }
            }
        } else {
            this.nodesToAdd.remove(object);
        }
    }

    private void addEntry(Object object2, boolean bl) {
        if (HierarchicalTreeFilterTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addEntry(Object,boolean)", 300).addDetail("node", object2)).addDetail("keep", bl)).log();
        }
        if (this.indexMap == null) {
            this.indexMap = new HashMap();
            this.keepMask = new HashSet();
        }
        this.indexMap.computeIfAbsent(object2, object -> new ArrayList());
        Object object3 = this.getFilteredModel().getAdapter().getParentNode(object2);
        ArrayList<Object> arrayList = this.indexMap.get(object3);
        if (arrayList != null && !arrayList.contains(object2)) {
            arrayList.add(object2);
        }
        this.nodesToAdd.add(object2);
        if (bl) {
            this.keepMask.add(object2);
        }
    }

    private void removeNode(Object object) {
        if (HierarchicalTreeFilterTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeNode(Object)", 329).addDetail("node", object)).log();
        }
        if (this.getFilteredModel().getRoot() == object) {
            return;
        }
        this.nodesToAdd.remove(object);
        this.indexMap.remove(object);
        this.keepMask.remove(object);
        Object object2 = this.getFilteredModel().getFilteredTreeAdapter().getParentNode(object);
        this.indexMap.get(object2).remove(object);
    }

    @Generated
    public boolean isFilterInternalNodes() {
        if (HierarchicalTreeFilterTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "isFilterInternalNodes()", 86).log();
        }
        return this.filterInternalNodes;
    }

    @Generated
    public HierarchicalTreeFilterTraversal setFilterInternalNodes(boolean bl) {
        this.filterInternalNodes = bl;
        return this;
    }
}

