/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.json;

import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonNumber;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonSerializable;
import de.qfs.lib.json.JsonString;
import de.qfs.lib.json.JsonValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;

public class JsonBuilder {
    public static JsonValue toJsonValue(Object object) {
        return JsonBuilder.toJsonValue(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JsonValue toJsonValue(Object object, Deque<Object> deque) {
        if (object == null) {
            return Json.NULL;
        }
        if (object instanceof JsonValue) {
            return (JsonValue)object;
        }
        if (object instanceof JsonSerializable) {
            return ((JsonSerializable)object).asJsonValue();
        }
        if (object instanceof Boolean) {
            return Json.value((Boolean)object);
        }
        if (object instanceof Byte) {
            return Json.value(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return Json.value(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return Json.value((Integer)object);
        }
        if (object instanceof Long) {
            return Json.value((Long)object);
        }
        if (object instanceof BigInteger) {
            return new JsonNumber(object.toString());
        }
        if (object instanceof BigDecimal) {
            return new JsonNumber(object.toString());
        }
        if (object instanceof Float) {
            return Json.value(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Json.value((Double)object);
        }
        if (deque == null) {
            deque = new LinkedList<Object>();
        }
        for (Object object2 : deque) {
            if (!object2.equals(object)) continue;
            return new JsonString("(circular reference)");
        }
        try {
            Object object3;
            deque.push(object);
            if (object.getClass().isArray()) {
                object3 = JsonBuilder.arrayToJsonValue(object, deque);
                return object3;
            }
            if (object instanceof Iterable) {
                object3 = JsonBuilder.iterableToJsonValue((Iterable)object, deque);
                return object3;
            }
            if (object instanceof Map) {
                object3 = JsonBuilder.mapToJsonValue((Map)object, deque);
                return object3;
            }
            object3 = Json.value(String.valueOf(object));
            return object3;
        }
        finally {
            deque.pollFirst();
        }
    }

    static JsonArray iterableToJsonValue(Iterable<?> iterable, Deque<Object> deque) {
        JsonArray jsonArray = new JsonArray();
        for (Object obj : iterable) {
            jsonArray.add(JsonBuilder.toJsonValue(obj, deque));
        }
        return jsonArray;
    }

    static JsonObject mapToJsonValue(Map<?, ?> map, Deque<Object> deque) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            jsonObject.add(String.valueOf(entry.getKey()), JsonBuilder.toJsonValue(entry.getValue(), deque));
        }
        return jsonObject;
    }

    static JsonValue arrayToJsonValue(Object object, Deque<Object> deque) {
        JsonArray jsonArray = new JsonArray();
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            jsonArray.add(JsonBuilder.toJsonValue(object2, deque));
        }
        return jsonArray;
    }
}

