/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.json;

import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonLiteral;
import de.qfs.lib.json.JsonNumber;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonString;
import de.qfs.lib.json.JsonValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class JsonMapper {
    public static Object map(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return null;
        }
        if (jsonValue instanceof JsonNumber) {
            return JsonMapper.map((JsonNumber)jsonValue);
        }
        if (jsonValue instanceof JsonString) {
            return JsonMapper.map((JsonString)jsonValue);
        }
        if (jsonValue instanceof JsonLiteral) {
            return JsonMapper.map((JsonLiteral)jsonValue);
        }
        if (jsonValue instanceof JsonArray) {
            return JsonMapper.map((JsonArray)jsonValue);
        }
        if (jsonValue instanceof JsonObject) {
            return JsonMapper.map((JsonObject)jsonValue);
        }
        return jsonValue.toString();
    }

    public static Object map(JsonNumber jsonNumber) {
        try {
            return jsonNumber.asLong();
        }
        catch (NumberFormatException numberFormatException) {
            return jsonNumber.asDouble();
        }
    }

    public static Object map(JsonString jsonString) {
        return jsonString.asString();
    }

    public static Object map(JsonLiteral jsonLiteral) {
        if (jsonLiteral.isBoolean()) {
            return jsonLiteral.asBoolean();
        }
        if (jsonLiteral.isNull()) {
            return null;
        }
        return jsonLiteral.toString();
    }

    public static Object map(JsonArray jsonArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(jsonArray.size());
        for (JsonValue jsonValue : jsonArray) {
            arrayList.add(JsonMapper.map(jsonValue));
        }
        return arrayList;
    }

    public static Object map(JsonObject jsonObject) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (JsonObject.Member member : jsonObject) {
            linkedHashMap.put(member.getName(), JsonMapper.map(member.getValue()));
        }
        return linkedHashMap;
    }
}

