/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.junit.converters;

import de.qfs.lib.junit.converters.ArrayConverter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ConvertWith;

public class ListConverter
extends ArrayConverter {
    @Override
    public Object convert(Object object, ParameterContext parameterContext) throws ArgumentConversionException {
        Class<Object> clazz = parameterContext.getParameter().getType();
        if (!List.class.isAssignableFrom(clazz)) {
            throw new ArgumentConversionException("No argument conversion defined for targetType " + clazz);
        }
        try {
            Object[] objectArray;
            Type type = ((ParameterizedType)parameterContext.getParameter().getParameterizedType()).getActualTypeArguments()[0];
            Class<?> clazz2 = Class.forName("[L" + type.getTypeName() + ";");
            if (clazz.isInterface()) {
                clazz = LinkedList.class;
            }
            List list = (List)clazz.newInstance();
            for (Object object2 : objectArray = (Object[])super.convert(object, clazz2)) {
                list.add(object2);
            }
            return list;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new ArgumentConversionException("Could not initialize " + clazz, (Throwable)reflectiveOperationException);
        }
    }

    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ConvertWith(value=ListConverter.class)
    public static @interface AsList {
    }
}

