/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.DefaultLogFormat;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFormat;
import de.qfs.lib.log.LogUser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Vector;

public class StreamFilter
implements LogUser {
    private static StreamFilter instance;
    public static final int MODE_CREATE = 0;
    public static final int MODE_APPEND = 1;
    public static final int MODE_UNIQUE = 2;
    private PrintWriter out;
    private int mode = 3;
    private int level = -1;
    private DateFormat format;
    private LogFormat logFormat;

    public StreamFilter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream), -1, null);
    }

    public StreamFilter(OutputStream outputStream, int n) {
        this(new OutputStreamWriter(outputStream), n, null);
    }

    public StreamFilter(OutputStream outputStream, int n, DateFormat dateFormat) {
        this(new OutputStreamWriter(outputStream), n, dateFormat);
    }

    public StreamFilter(Writer writer) {
        this(writer, -1, null);
    }

    public StreamFilter(Writer writer, int n) {
        this(writer, n, null);
    }

    public StreamFilter(Writer writer, int n, DateFormat dateFormat) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
        this.level = n;
        this.format = dateFormat;
        this.logFormat = dateFormat == null ? new DefaultLogFormat() : new DefaultLogFormat(dateFormat);
    }

    public static StreamFilter logToFile(String string, File file, int n) throws IOException {
        PrintWriter printWriter;
        block0 : switch (n) {
            case 0: 
            case 1: {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getPath(), n == 1), "UTF-8"));
                break;
            }
            case 2: {
                String string2 = file.getPath();
                String string3 = "";
                int n2 = string2.lastIndexOf(46);
                if (n2 > 0) {
                    string3 = string2.substring(n2);
                    string2 = string2.substring(0, n2);
                }
                int n3 = 1;
                while (true) {
                    if (!(file = new File(string2 + n3 + string3)).exists()) {
                        printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                        break block0;
                    }
                    ++n3;
                }
            }
            default: {
                throw new IllegalArgumentException("Argument mode must be one of MODE_CREATE, MODE_APPEND or MODE_UNIQUE.");
            }
        }
        if (n != 1) {
            printWriter.println("client name: " + string);
            printWriter.flush();
        }
        instance = new StreamFilter(printWriter);
        Log.addFilter(instance);
        return instance;
    }

    public static void stopLogging() {
        if (instance != null) {
            instance.close();
        }
    }

    public final int getLogLevel() {
        return this.level;
    }

    public final void setLogLevel(int n) {
        this.level = n;
    }

    public final DateFormat getDateFormat() {
        return this.format;
    }

    public final void setDateFormat(DateFormat dateFormat) {
        this.format = dateFormat;
        this.logFormat = dateFormat == null ? new DefaultLogFormat() : new DefaultLogFormat(dateFormat);
    }

    public void close() {
        this.out.close();
        Log.removeFilter(this);
    }

    @Override
    public boolean filter(LogEntry logEntry) {
        boolean bl = false;
        if (this.level == -1 || logEntry.getLevel() <= this.level) {
            this.out.println(this.logFormat.format(logEntry));
            this.out.flush();
            bl = true;
        }
        return this.mode != 2 && (bl && this.mode != 0 || !bl && this.mode != 1);
    }

    @Override
    public LogEntry[] filter(LogEntry[] logEntryArray) {
        Vector<LogEntry> vector = null;
        if (this.mode != 2 && this.mode != 3 && this.level != -1) {
            vector = new Vector<LogEntry>();
        }
        boolean bl = false;
        for (int i = 0; i < logEntryArray.length; ++i) {
            if (this.level == -1 || logEntryArray[i].getLevel() <= this.level) {
                this.out.println(this.logFormat.format(logEntryArray[i]));
                if (vector != null && this.mode == 1) {
                    vector.addElement(logEntryArray[i]);
                }
                bl = true;
                continue;
            }
            if (vector == null || this.mode != 0) continue;
            vector.addElement(logEntryArray[i]);
        }
        if (bl) {
            this.out.flush();
        }
        if (this.mode == 2 || vector == null && this.mode == 0) {
            return new LogEntry[0];
        }
        if (this.mode == 3 || vector == null && this.mode == 1) {
            return logEntryArray;
        }
        Object[] objectArray = new LogEntry[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void setFilterMode(int n) {
        this.mode = n;
    }
}

