/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.logrmi;

import de.qfs.lib.log.LevelFilter;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFormat;
import de.qfs.lib.log.LogWriter;
import de.qfs.lib.log.Logger;
import de.qfs.lib.logrmi.LogClient;
import de.qfs.lib.logrmi.LogListener;
import de.qfs.lib.logrmi.LogServer;
import de.qfs.lib.logrmi.RemoteLogLevelAdapter;
import de.qfs.lib.logrmi.RemoteLogLevelListener;
import de.qfs.lib.util.Environment;
import de.qfs.lib.util.Misc;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteLogWriter
extends UnicastRemoteObject
implements LogClient,
LogWriter {
    private static LevelFilter lastLevelFilter;
    private String name;
    private String bound;
    private boolean localOnly;
    private LogServer logServer;
    private int id;
    private boolean connected;
    private LogListener listener;
    private RemoteLogLevelListener levelListener;
    private RemoteLogLevelAdapter adapter;
    private int failure = 0;
    private static final int MAX_FAILURES = 3;

    public RemoteLogWriter(String string) throws RemoteException {
        this.name = string;
    }

    public static LevelFilter logRemote(String string, String string2) throws MalformedURLException, NotBoundException, RemoteException {
        RemoteLogWriter remoteLogWriter = new RemoteLogWriter(string2);
        remoteLogWriter.connect(string);
        lastLevelFilter = new LevelFilter(-1, remoteLogWriter);
        Log.addFilter(lastLevelFilter);
        return lastLevelFilter;
    }

    public static LevelFilter logRemote(String string, int n, boolean bl, boolean bl2) throws RemoteException {
        RemoteLogWriter remoteLogWriter = new RemoteLogWriter(string);
        remoteLogWriter.register(n, bl, bl2);
        lastLevelFilter = new LevelFilter(-1, remoteLogWriter);
        Log.addFilter(lastLevelFilter);
        return lastLevelFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelFilter logRemote(String string, String string2, int n, boolean bl, boolean bl2) throws MalformedURLException, NotBoundException, RemoteException {
        RemoteLogWriter remoteLogWriter = new RemoteLogWriter(string2);
        RemoteException remoteException = null;
        boolean bl3 = false;
        try {
            try {
                remoteLogWriter.register(n, bl, bl2);
            }
            catch (RemoteException remoteException2) {
                remoteException = remoteException2;
            }
            remoteLogWriter.connect(string);
            bl3 = true;
            if (remoteException != null) {
                throw remoteException;
            }
        }
        finally {
            if (bl3 || remoteException == null) {
                lastLevelFilter = new LevelFilter(-1, remoteLogWriter);
                Log.addFilter(lastLevelFilter);
            }
        }
        return lastLevelFilter;
    }

    public static void stopLogging() {
        if (lastLevelFilter != null) {
            Log.removeFilter(lastLevelFilter);
            lastLevelFilter.getLogWriter().close();
            lastLevelFilter = null;
        }
    }

    public static boolean isLogging() {
        return lastLevelFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string) throws MalformedURLException, NotBoundException, RemoteException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.logServer = (LogServer)Naming.lookup(string);
            String string2 = this.logServer.getDisplay();
            if (!Misc.emptyOrNull(string2)) {
                Environment environment = new Environment();
                String string3 = environment.getEnv("DISPLAY");
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                if (string3 != null && string3.endsWith(".0")) {
                    string3 = string3.substring(0, string3.length() - 2);
                }
                if (!string2.equals(string3)) {
                    return;
                }
            }
            this.id = this.logServer.getId(this.name);
            this.connect();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void register(int n, boolean bl, boolean bl2) throws RemoteException {
        this.localOnly = bl2;
        Registry registry = null;
        RemoteException remoteException = null;
        try {
            registry = LocateRegistry.getRegistry(n > 0 ? n : 1099);
        }
        catch (RemoteException remoteException2) {
            remoteException = remoteException2;
        }
        this.bound = "LogClient-" + this.name + "-" + (int)(Math.random() * 100000.0);
        if (registry != null) {
            try {
                registry.bind(this.bound, this);
                return;
            }
            catch (AlreadyBoundException alreadyBoundException) {
            }
            catch (RemoteException remoteException3) {
                registry = null;
                remoteException = remoteException3;
            }
        }
        if (registry == null) {
            if (bl) {
                registry = LocateRegistry.createRegistry(n > 0 ? n : 1099);
            } else {
                if (remoteException != null) {
                    throw remoteException;
                }
                System.err.println("RemoteLogWriter.register: internal error");
            }
        }
        boolean bl3 = false;
        while (!bl3) {
            this.bound = "LogClient-" + this.name + "-" + (int)(Math.random() * 100000.0);
            try {
                registry.bind(this.bound, this);
                bl3 = true;
            }
            catch (AlreadyBoundException alreadyBoundException) {}
        }
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.logServer.disconnect(this.id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.bound != null) {
            try {
                Naming.unbind(this.bound);
            }
            catch (RemoteException remoteException) {
            }
            catch (NotBoundException notBoundException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.bound = null;
        }
        this.listener = null;
        if (this.adapter != null) {
            Logger.removeLogLevelListener(this.adapter);
            this.adapter = null;
            this.levelListener = null;
        }
    }

    @Override
    public void write(LogEntry logEntry) {
        if (this.failure >= 0) {
            if (this.failure >= 3) {
                this.failure = -1;
            } else if (this.listener != null) {
                try {
                    this.listener.log(logEntry);
                }
                catch (Throwable throwable) {
                    ++this.failure;
                }
            }
        }
    }

    @Override
    public void write(LogEntry[] logEntryArray) {
        if (this.failure >= 0) {
            if (this.failure >= 3) {
                this.failure = -1;
            } else if (this.listener != null) {
                try {
                    this.listener.log(logEntryArray);
                }
                catch (Throwable throwable) {
                    ++this.failure;
                }
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    @Override
    public void setFormat(LogFormat logFormat) {
    }

    @Override
    public LogFormat getFormat() {
        return null;
    }

    @Override
    public void connect(LogServer logServer) throws RemoteException {
        if (this.localOnly) {
            try {
                String string = RemoteLogWriter.getClientHost();
                InetAddress inetAddress = InetAddress.getByName(string);
                if (!inetAddress.getHostAddress().startsWith("127.0.0.") && !inetAddress.equals(InetAddress.getLocalHost())) {
                    throw new AccessException("RemoteLogWriter.connect: " + string + " is not a local address");
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }
        if (this.connected) {
            try {
                this.logServer.disconnect(this.id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.adapter != null) {
            Logger.removeLogLevelListener(this.adapter);
            this.adapter = null;
            this.levelListener = null;
        }
        try {
            this.logServer = logServer;
            this.id = logServer.getId(this.name);
            this.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connect() throws RemoteException {
        this.listener = this.logServer.getLogListener(this.id);
        this.levelListener = this.logServer.getLogLevelListener(this.id);
        this.adapter = new RemoteLogLevelAdapter();
        this.adapter.setRemoteListener(this.levelListener);
        Logger.addLogLevelListener(this.adapter);
        this.failure = 0;
        this.connected = true;
    }
}

