/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.ConfigurableOption;
import de.qfs.lib.option.Option;
import java.awt.Component;
import lombok.Generated;

public class IntegerOption
extends Option
implements ConfigurableOption {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.IntegerOption");
    static final long serialVersionUID = 8271881954001543763L;
    private boolean negativeOK;

    public IntegerOption() {
        if (IntegerOption.logger.level >= 7) {
            logger.lvlBuild(7, "IntegerOption()", 73).log();
        }
    }

    public IntegerOption(String string) {
        super(string, null);
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "IntegerOption(String)", 82).addDetail("name", string)).log();
        }
    }

    public IntegerOption(String string, int n) {
        super(string, n);
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "IntegerOption(String,int)", 93).addDetail("name", string)).addDetail("value", n)).log();
        }
    }

    public IntegerOption(String string, Integer n) {
        super(string, n);
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "IntegerOption(String,Integer)", 104).addDetail("name", string)).addDetail("value", n)).log();
        }
    }

    public IntegerOption(String string, int n, boolean bl, boolean bl2) {
        super(string, n, bl);
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "IntegerOption(String,int,boolean,boolean)", 118).addDetail("name", string)).addDetail("value", n)).addDetail("nullOK", bl)).addDetail("negativeOK", bl2)).log();
        }
        this.negativeOK = bl2;
    }

    public IntegerOption(String string, Integer n, boolean bl, boolean bl2) {
        super(string, n, bl);
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "IntegerOption(String,Integer,boolean,boolean)", 134).addDetail("name", string)).addDetail("value", n)).addDetail("nullOK", bl)).addDetail("negativeOK", bl2)).log();
        }
        this.negativeOK = bl2;
    }

    public final boolean isNegativeOK() {
        return this.negativeOK;
    }

    public final void setNegativeOK(boolean bl) {
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setNegativeOK(boolean)", 167).addDetail("negativeOK", bl)).log();
        }
        this.negativeOK = bl;
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 187).addDetail("value", object)).log();
        }
        this.checkValueType(object);
        super.setValue(object);
    }

    protected void checkValueType(Object object) {
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "checkValueType(Object)", 197).addDetail("value", object)).log();
        }
        if (object != null && !(object instanceof Integer)) {
            throw new IllegalArgumentException("Value is not an Integer: " + object);
        }
    }

    @Override
    public boolean checkValue(Component component, Object object) {
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "checkValue(Component,Object)", 219).addDetail("component", component)).addDetail("value", object)).log();
        }
        if (object != null && !this.negativeOK && (Integer)object < 0) {
            if (component != null) {
                Message.showMessageAndHighlight(component, "option.error.negative");
            }
            return false;
        }
        return super.checkValue(component, object);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IntegerOption && super.equals(object);
    }

    @Override
    public String getValueAsString() {
        Object object;
        if (IntegerOption.logger.level >= 7) {
            logger.lvlBuild(7, "getValueAsString()", 258).log();
        }
        return (object = this.getValue()) == null ? "" : object.toString();
    }

    @Override
    public Object getValueFromString(String string) {
        if (IntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getValueFromString(String)", 268).addDetail("value", string)).log();
        }
        if ("UNUSED".equals(string)) {
            throw new IllegalStateException("Unused -> Skip");
        }
        if (string.equals("")) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (IntegerOption.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getValueFromString(String)", 279).add("ex", numberFormatException)).log();
            }
            throw new IllegalStateException("Error -> Skip");
        }
    }
}

