/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.Logger;
import de.qfs.lib.option.ConfigurableOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.util.Misc;
import java.io.Serializable;

public class KeyOption
extends Option
implements ConfigurableOption {
    static final long serialVersionUID = 8234204428668829492L;
    public static final String OPT_KEYBINDING_OPTGROUPNAME = "QF-Test Keyboard Bindings";
    public static final String OPT_KEYBINDING_TYPE_SYSTEM = "system";
    public static final String OPT_KEYBINDING_TYPE_CLASSIC = "classic";
    public static final int VK_COMMAND_MASK = Misc.OS_IS_MAC_OS_X ? 4 : 2;
    public static final String OPT_KEYSTROKE_DEFAULTBUTTON = "KeystrokeDefaultButton";
    public static final Data DEFVAL_KEYSTROKE_DEFAULTBUTTON_CLASSIC = new Data(10, 2);
    public static final Data DEFVAL_KEYSTROKE_DEFAULTBUTTON_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(10, 4) : DEFVAL_KEYSTROKE_DEFAULTBUTTON_CLASSIC;
    public static final String OPT_KEYSTROKE_TRIGGER_CONTEXTMENU = "KeystrokeTriggerContextMenu";
    public static final Data DEFVAL_KEYSTROKE_TRIGGER_CONTEXTMENU_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TRIGGER_CONTEXTMENU_SYSTEM;
    public static final String OPT_KEYSTROKE_TRIGGER_EDIT = "KeystrokeTriggerEdit";
    public static final Data DEFVAL_KEYSTROKE_TRIGGER_EDIT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TRIGGER_EDIT_SYSTEM;
    public static final String OPT_KEYSTROKE_TRIGGER_EDIT2 = "KeystrokeTriggerEdit2";
    public static final Data DEFVAL_KEYSTROKE_TRIGGER_EDIT2_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TRIGGER_EDIT2_SYSTEM;
    public static final String OPT_KEYSTROKE_OPEN_RUNLOG = "KeystrokeOpenRunLog";
    public static final Data DEFVAL_KEYSTROKE_OPEN_RUNLOG_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_OPEN_RUNLOG_SYSTEM;
    public static final String OPT_KEYSTROKE_CONTINUE_FROM_HERE = "KeystrokeContinueFromHere";
    public static final Data DEFVAL_KEYSTROKE_CONTINUE_FROM_HERE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_CONTINUE_FROM_HERE_SYSTEM;
    public static final String OPT_KEYSTROKE_NEW_SUITE = "KeyStrokeNewSuite";
    public static final Data DEFVAL_KEYSTROKE_NEW_SUITE_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_NEW_SUITE_CLASSIC;
    public static final String OPT_KEYSTROKE_OPEN_FILE = "KeyStrokeOpenFile";
    public static final Data DEFVAL_KEYSTROKE_OPEN_FILE_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_OPEN_FILE_CLASSIC;
    public static final String OPT_KEYSTROKE_SAVE_FILE = "KeyStrokeSaveFile";
    public static final Data DEFVAL_KEYSTROKE_SAVE_FILE_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SAVE_FILE_CLASSIC;
    public static final String OPT_KEYSTROKE_SAVE_FILE_AS = "KeyStrokeSaveFileAs";
    public static final Data DEFVAL_KEYSTROKE_SAVE_FILE_AS_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SAVE_FILE_AS_CLASSIC;
    public static final String OPT_KEYSTROKE_COPY = "KeyStrokeCopy";
    public static final Data DEFVAL_KEYSTROKE_COPY_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_COPY_CLASSIC;
    public static final String OPT_KEYSTROKE_COPY_TEXT = "KeyStrokeCopyText";
    public static final Data DEFVAL_KEYSTROKE_COPY_TEXT_SYSTEM;
    public static final String OPT_KEYSTROKE_PASTE = "KeyStrokePaste";
    public static final Data DEFVAL_KEYSTROKE_PASTE_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_PASTE_CLASSIC;
    public static final String OPT_KEYSTROKE_CUT = "KeyStrokeCut";
    public static final Data DEFVAL_KEYSTROKE_CUT_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_CUT_CLASSIC;
    public static final String OPT_KEYSTROKE_UNDO = "KeyStrokeUndo";
    public static final Data DEFVAL_KEYSTROKE_UNDO_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_UNDO_CLASSIC;
    public static final String OPT_KEYSTROKE_REDO = "KeyStrokeRedo";
    public static final Data DEFVAL_KEYSTROKE_REDO_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_REDO_CLASSIC;
    public static final String OPT_KEYSTROKE_SEARCH = "KeyStrokeSearch";
    public static final Data DEFVAL_KEYSTROKE_SEARCH_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SEARCH_CLASSIC;
    public static final String OPT_KEYSTROKE_SEARCH_AGAIN = "KeyStrokeSearchAgain";
    public static final Data DEFVAL_KEYSTROKE_SEARCH_AGAIN_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SEARCH_AGAIN_CLASSIC;
    public static final String OPT_KEYSTROKE_SEARCH_CONTINUE = "KeyStrokeSearchContinue";
    public static final Data DEFVAL_KEYSTROKE_SEARCH_CONTINUE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SEARCH_CONTINUE_SYSTEM;
    public static final String OPT_KEYSTROKE_SEARCH_SWITCH_SEARCHMODE = "KeyStrokeSearchSwitchSearchMode";
    public static final Data DEFVAL_KEYSTROKE_SEARCH_SWITCH_SEARCHMODE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SEARCH_SWITCH_SEARCHMODE_SYSTEM;
    public static final String OPT_KEYSTROKE_SEARCH_SWITCH_REPLACEMODE = "KeyStrokeSearchSwitchReplaceMode";
    public static final Data DEFVAL_KEYSTROKE_SEARCH_SWITCH_REPLACEMODE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SEARCH_SWITCH_REPLACEMODE_SYSTEM;
    public static final String OPT_KEYSTROKE_SEARCH_RESET = "KeyStrokeSearchReset";
    public static final Data DEFVAL_KEYSTROKE_SEARCH_RESET_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SEARCH_RESET_SYSTEM;
    public static final String OPT_KEYSTROKE_REPLACE = "KeyStrokeReplace";
    public static final Data DEFVAL_KEYSTROKE_REPLACE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_REPLACE_SYSTEM;
    public static final String OPT_KEYSTROKE_TOGGLE_FULLSCREEN = "KeyStrokeToggleFullscreen";
    public static final Data DEFVAL_KEYSTROKE_TOGGLE_FULLSCREEN_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TOGGLE_FULLSCREEN_SYSTEM;
    public static final String OPT_KEYSTROKE_SWITCH_TABS = "KeyStrokeSwitchTabModifier";
    public static final int DEFVAL_KEYSTROKE_SWITCH_TABS_SYSTEM;
    public static final int DEFVAL_KEYSTROKE_SWITCH_TABS_CLASSIC = 8;
    public static final String OPT_KEYSTROKE_SELECT_ALL = "KeyStrokeSelectAll";
    public static final Data DEFVAL_KEYSTROKE_SELECT_ALL_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SELECT_ALL_CLASSIC;
    public static final String OPT_KEYSTROKE_DELETE = "KeyStrokeDelete";
    public static final Data DEFVAL_KEYSTROKE_DELETE_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_DELETE_CLASSIC;
    public static final String OPT_KEYSTROKE_DOCUMENT_HOME = "KeyStrokeDocumentHome";
    public static final Data DEFVAL_KEYSTROKE_DOCUMENT_HOME_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_DOCUMENT_HOME_CLASSIC;
    public static final String OPT_KEYSTROKE_DOCUMENT_END = "KeyStrokeDocumentEnd";
    public static final Data DEFVAL_KEYSTROKE_DOCUMENT_END_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_DOCUMENT_END_CLASSIC;
    public static final String OPT_KEYSTROKE_SELECT_DOCUMENT_HOME = "KeyStrokeSelectDocumentHome";
    public static final Data DEFVAL_KEYSTROKE_SELECT_DOCUMENT_HOME_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SELECT_DOCUMENT_HOME_CLASSIC;
    public static final String OPT_KEYSTROKE_SELECT_DOCUMENT_END = "KeyStrokeSelectDocumentEnd";
    public static final Data DEFVAL_KEYSTROKE_SELECT_DOCUMENT_END_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SELECT_DOCUMENT_END_CLASSIC;
    public static final String OPT_KEYSTROKE_HOME = "KeyStrokeHome";
    public static final Data DEFVAL_KEYSTROKE_HOME_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_HOME_SYSTEM;
    public static final String OPT_KEYSTROKE_HOTKEY_INSPECTOR = "KeyStrokeHotkeyInspector";
    public static final Data DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_SYSTEM;
    public static final String OPT_KEYSTROKE_HOTKEY_INSPECTOR_MODE = "KeyStrokeHotkeyInspectorMode";
    public static final Data DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_MODE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_MODE_SYSTEM;
    public static final String OPT_KEYSTROKE_END = "KeyStrokeEnd";
    public static final Data DEFVAL_KEYSTROKE_END_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_END_SYSTEM;
    public static final String OPT_KEYSTROKE_SELECT_HOME = "KeyStrokeSelectHome";
    public static final Data DEFVAL_KEYSTROKE_SELECT_HOME_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SELECT_HOME_SYSTEM;
    public static final String OPT_KEYSTROKE_SELECT_END = "KeyStrokeSelectEnd";
    public static final Data DEFVAL_KEYSTROKE_SELECT_END_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SELECT_END_SYSTEM;
    public static final String OPT_KEYSTROKE_PREV_WORD = "KeyStrokePreviousWord";
    public static final Data DEFVAL_KEYSTROKE_PREV_WORD_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_PREV_WORD_CLASSIC;
    public static final String OPT_KEYSTROKE_NEXT_WORD = "KeyStrokeNextWord";
    public static final Data DEFVAL_KEYSTROKE_NEXT_WORD_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_NEXT_WORD_CLASSIC;
    public static final String OPT_KEYSTROKE_SELECT_PREV_WORD = "KeyStrokeSelectPreviousWord";
    public static final Data DEFVAL_KEYSTROKE_SELECT_PREV_WORD_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SELECT_PREV_WORD_CLASSIC;
    public static final String OPT_KEYSTROKE_SELECT_NEXT_WORD = "KeyStrokeSelectNextWord";
    public static final Data DEFVAL_KEYSTROKE_SELECT_NEXT_WORD_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_SELECT_NEXT_WORD_CLASSIC;
    public static final String OPT_KEYSTROKE_MOVE_LINE_UP = "KeyStrokeMoveLineUpFixed";
    public static final Data DEFVAL_KEYSTROKE_MOVE_LINE_UP_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_MOVE_LINE_UP_CLASSIC;
    public static final String OPT_KEYSTROKE_MOVE_LINE_DOWN = "KeyStrokeMoveLineDownFixed";
    public static final Data DEFVAL_KEYSTROKE_MOVE_LINE_DOWN_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_MOVE_LINE_DOWN_CLASSIC;
    public static final String OPT_KEYSTROKE_CLONE_LINE_UP = "KeyStrokeCloneLineUp";
    public static final Data DEFVAL_KEYSTROKE_CLONE_LINE_UP_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_CLONE_LINE_UP_CLASSIC;
    public static final String OPT_KEYSTROKE_CLONE_LINE_DOWN = "KeyStrokeCloneLineDown";
    public static final Data DEFVAL_KEYSTROKE_CLONE_LINE_DOWN_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_CLONE_LINE_DOWN_CLASSIC;
    public static final String OPT_KEYSTROKE_DELETE_WORD = "KeyStrokeDeleteWord";
    public static final Data DEFVAL_KEYSTROKE_DELETE_WORD_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_DELETE_WORD_CLASSIC;
    public static final String OPT_KEYSTROKE_BACKSPACE_WORD = "KeyStrokeBackspaceWord";
    public static final Data DEFVAL_KEYSTROKE_BACKSPACE_WORD_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_BACKSPACE_WORD_CLASSIC;
    public static final String OPT_KEYSTROKE_CLOSESUITE = "KeyStrokeCloseSuite2";
    public static final Data DEFVAL_KEYSTROKE_CLOSESUITE_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_CLOSESUITE_CLASSIC;
    public static final String OPT_KEYSTROKE_HIGHLIGHT_COMPONENT = "KeyStrokeHighlightComponent";
    public static final Data DEFVAL_KEYSTROKE_HIGHLIGHT_COMPONENT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_HIGHLIGHT_COMPONENT_SYSTEM;
    public static final String OPT_KEYSTROKE_LOCATE_COMPONENT = "KeyStrokeLocateComponent";
    public static final Data DEFVAL_KEYSTROKE_LOCATE_COMPONENT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_LOCATE_COMPONENT_SYSTEM;
    public static final String OPT_KEYSTROKE_LOCATE_ANY = "KeyStrokeLocateAny";
    public static final Data DEFVAL_KEYSTROKE_LOCATE_ANY_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_LOCATE_ANY_SYSTEM;
    public static final String OPT_KEYSTROKE_LOCATE_STEP = "KeyStrokeLocateStep";
    public static final Data DEFVAL_KEYSTROKE_LOCATE_STEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_LOCATE_STEP_SYSTEM;
    public static final String OPT_KEYSTROKE_LOCATE_REFERENCES = "KeyStrokeLocateReferences";
    public static final Data DEFVAL_KEYSTROKE_LOCATE_REFERENCES_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_LOCATE_REFERENCES_SYSTEM;
    public static final String OPT_KEYSTROKE_UPDATE_CHECK = "KeyStrokeUpdateCheck";
    public static final Data DEFVAL_KEYSTROKE_UPDATE_CHECK_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_UPDATE_CHECK_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_PROCEDURE_CALL = "KeyStrokeInsertProcedureCall";
    public static final Data DEFVAL_KEYSTROKE_INSERT_PROCEDURE_CALL_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_PROCEDURE_CALL_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENT_STEP = "KeyStrokeInsertCommentStep";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENT_STEP_ALT = "KeyStrokeInsertCommentStepAlt";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_ALT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_ALT_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENT_STEP_NUM = "KeyStrokeInsertCommentStepNum";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENT_STEP_NUM_ALT = "KeyStrokeInsertCommentStepNumAlt";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_ALT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_ALT_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENTABOVE_STEP = "KeyStrokeInsertCommentAboveStep";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENTABOVE_STEP_ALT = "KeyStrokeInsertCommentAboveStepAlt";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_ALT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_ALT_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM = "KeyStrokeInsertCommentAboveStepNum";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_ALT = "KeyStrokeInsertCommentAboveStepNumAlt";
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_ALT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_ALT_SYSTEM;
    public static final String OPT_KEYSTROKE_PACK_IN_SEQUENCE = "KeyStrokePackInSequence";
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_SEQUENCE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_SEQUENCE_SYSTEM;
    public static final String OPT_KEYSTROKE_PACK_IN_IF = "KeyStrokePackInIf";
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_IF_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_IF_SYSTEM;
    public static final String OPT_KEYSTROKE_PACK_IN_TESTSTEP = "KeyStrokePackInTestStep";
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_TESTSTEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_TESTSTEP_SYSTEM;
    public static final String OPT_KEYSTROKE_PACK_IN_TRY = "KeyStrokePackInTry";
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_TRY_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_PACK_IN_TRY_SYSTEM;
    public static final String OPT_KEYSTROKE_TRANSFROM_IN_PROCEDURE = "KeyStrokeTransformInProcedure";
    public static final Data DEFVAL_KEYSTROKE_TRANSFROM_IN_PROCEDURE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TRANSFROM_IN_PROCEDURE_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_SINGLESTEP = "KeyStrokeDebuggerSingleStep";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_SINGLESTEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_SINGLESTEP_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_STEPOVER = "KeyStrokeDebuggerStepOver";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_STEPOVER_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_STEPOVER_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_STEPOUT = "KeyStrokeDebuggerStepOut";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_STEPOUT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_STEPOUT_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_SKIPOVER = "KeyStrokeDebuggerSkipOver";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_SKIPOVER_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_SKIPOVER_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_SKIPOUT = "KeyStrokeDebuggerSkipOut";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_SKIPOUT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_SKIPOUT_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_TOGGLE_BREAKPOINT = "KeyStrokeDebuggerToggleBreakPoint";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_TOGGLE_BREAKPOINT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_TOGGLE_BREAKPOINT_SYSTEM;
    public static final String OPT_KEYSTROKE_DEBUGGER_JUMP_LOG = "KeyStrokeDebuggerJumpLog";
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_JUMP_LOG_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DEBUGGER_JUMP_LOG_SYSTEM;
    public static final String OPT_KEYSTROKE_RUN_PAUSE = "KeyStrokeRunPause";
    public static final Data DEFVAL_KEYSTROKE_RUN_PAUSE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RUN_PAUSE_SYSTEM;
    public static final String OPT_KEYSTROKE_ISEARCH = "KeyStrokeISearch";
    public static final Data DEFVAL_KEYSTROKE_ISEARCH_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_ISEARCH_SYSTEM;
    public static final String OPT_KEYSTROKE_ISEARCH_REGION = "KeyStrokeISearchRegion";
    public static final Data DEFVAL_KEYSTROKE_ISEARCH_REGION_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_ISEARCH_REGION_SYSTEM;
    public static final String OPT_KEYSTROKE_MARKS_TOGGLE = "KeyStrokeMarksToggle";
    public static final Data DEFVAL_KEYSTROKE_MARKS_TOGGLE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_MARKS_TOGGLE_SYSTEM;
    public static final String OPT_KEYSTROKE_MARKS_NEXT = "KeyStrokeMarksNext";
    public static final Data DEFVAL_KEYSTROKE_MARKS_NEXT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_MARKS_NEXT_SYSTEM;
    public static final String OPT_KEYSTROKE_MARKS_PREVIOUS = "KeyStrokeMarksPrevious";
    public static final Data DEFVAL_KEYSTROKE_MARKS_PREVIOUS_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_MARKS_PREVIOUS_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_PREVIOUS_NODE = "KeyStrokeTreePreviousNode";
    public static final Data DEFVAL_KEYSTROKE_TREE_PREVIOUS_NODE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_PREVIOUS_NODE_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_NEXT_NODE = "KeyStrokeTreeNextNode";
    public static final Data DEFVAL_KEYSTROKE_TREE_NEXT_NODE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_NEXT_NODE_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_PREVIOUS_SIBLING = "KeyStrokeTreePreviousNextSibling";
    public static final Data DEFVAL_KEYSTROKE_TREE_PREVIOUS_SIBLING_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_PREVIOUS_SIBLING_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_NEXT_SIBLING = "KeyStrokeTreeNextSibling";
    public static final Data DEFVAL_KEYSTROKE_TREE_NEXT_SIBLING_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_NEXT_SIBLING_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_CLEAN = "KeyStrokeTreeClean";
    public static final Data DEFVAL_KEYSTROKE_TREE_CLEAN_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_CLEAN_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_EXPAND = "KeyStrokeTreeExpand";
    public static final Data DEFVAL_KEYSTROKE_TREE_EXPAND_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_EXPAND_SYSTEM;
    public static final String OPT_KEYSTROKE_TREE_COLLAPSE = "KeyStrokeTreeCollapse";
    public static final Data DEFVAL_KEYSTROKE_TREE_COLLAPSE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TREE_COLLAPSE_SYSTEM;
    public static final String OPT_KEYSTROKE_PARAM_ADD_TO_CALLERS = "KeyStrokeParamAddToCallers";
    public static final Data DEFVAL_KEYSTROKE_PARAM_ADD_TO_CALLERS_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_PARAM_ADD_TO_CALLERS_SYSTEM;
    public static final String OPT_KEYSTROKE_PARAM_REMOVE = "KeyStrokeParamRemove";
    public static final Data DEFVAL_KEYSTROKE_PARAM_REMOVE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_PARAM_REMOVE_SYSTEM;
    public static final String OPT_KEYSTROKE_RUNLOG_NEXT_WARNING = "KeyStrokeRunLogNextWarning";
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_NEXT_WARNING_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_NEXT_WARNING_SYSTEM;
    public static final String OPT_KEYSTROKE_RUNLOG_PREVIOUS_WARNING = "KeyStrokeRunLogPreviousWarning";
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_WARNING_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_WARNING_SYSTEM;
    public static final String OPT_KEYSTROKE_RUNLOG_NEXT_EXCEPTION = "KeyStrokeRunLogNextException";
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_NEXT_EXCEPTION_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_NEXT_EXCEPTION_SYSTEM;
    public static final String OPT_KEYSTROKE_RUNLOG_PREVIOUS_EXCEPTION = "KeyStrokeRunLogPreviousException";
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_EXCEPTION_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_EXCEPTION_SYSTEM;
    public static final String OPT_KEYSTROKE_RESULTLIST = "KeyStrokeResultList";
    public static final Data DEFVAL_KEYSTROKE_RESULTLIST_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RESULTLIST_SYSTEM;
    public static final String OPT_KEYSTROKE_DISABLESTEP = "KeyStrokeDisableStep";
    public static final Data DEFVAL_KEYSTROKE_DISABLESTEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_DISABLESTEP_SYSTEM;
    public static final String OPT_KEYSTROKE_REFRESH = "KeyStrokeRefresh";
    public static final Data DEFVAL_KEYSTROKE_REFRESH_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_REFRESH_SYSTEM;
    public static final String OPT_KEYSTROKE_REFRESH_DEEP = "KeyStrokeRefreshDeep";
    public static final Data DEFVAL_KEYSTROKE_REFRESH_DEEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_REFRESH_DEEP_SYSTEM;
    public static final String OPT_KEYSTROKE_TERMINAL_PREVIOUS_CALL = "KeyStrokeTerminalPreviousCall";
    public static final Data DEFVAL_KEYSTROKE_TERMINAL_PREVIOUS_CALL_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TERMINAL_PREVIOUS_CALL_SYSTEM;
    public static final String OPT_KEYSTROKE_TERMINAL_NEXT_CALL = "KeyStrokeTerminalNextCall";
    public static final Data DEFVAL_KEYSTROKE_TERMINAL_NEXT_CALL_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_TERMINAL_NEXT_CALL_SYSTEM;
    public static final String OPT_KEYSTROKE_SHOW_TERMINAL = "KeyStrokeShowTerminal";
    public static final Data DEFVAL_KEYSTROKE_SHOW_TERMINAL_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_SHOW_TERMINAL_SYSTEM;
    public static final String OPT_KEYSTROKE_ADD_BOOKMARK = "KeyStrokeAddBookmark";
    public static final Data DEFVAL_KEYSTROKE_ADD_BOOKMARK_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_ADD_BOOKMARK_SYSTEM;
    public static final String OPT_KEYSTROKE_REMOVE = "KeyStrokeRemove";
    public static final Data DEFVAL_KEYSTROKE_REMOVE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_REMOVE_SYSTEM;
    public static final String OPT_KEYSTROKE_INSERT = "KeyStrokeInsert";
    public static final Data DEFVAL_KEYSTROKE_INSERT_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_INSERT_SYSTEM;
    public static final String OPT_KEYSTROKE_RENAME = "KeyStrokeRename";
    public static final Data DEFVAL_KEYSTROKE_RENAME_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RENAME_SYSTEM;
    public static final String OPT_KEYSTROKE_FOCUS_STEP = "KeyStrokeFocusStep";
    public static final Data DEFVAL_KEYSTROKE_FOCUS_STEP_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_FOCUS_STEP_SYSTEM;
    public static final String OPT_KEYSTROKE_MULTIRESULT_REPLACE = "KeyStrokeMultiresultReplace";
    public static final Data DEFVAL_KEYSTROKE_MULTIRESULT_REPLACE_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_MULTIRESULT_REPLACE_SYSTEM;
    public static final String OPT_KEYSTROKE_COPY_PATH = "KeyStrokeCopyPathNew";
    public static final Data DEFVAL_KEYSTROKE_COPY_PATH_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_COPY_PATH_CLASSIC;
    public static final String OPT_KEYSTROKE_GOTO_PATH = "KeyStrokeGotoPathNew";
    public static final Data DEFVAL_KEYSTROKE_GOTO_PATH_SYSTEM;
    public static final Data DEFVAL_KEYSTROKE_GOTO_PATH_CLASSIC;
    public static final String OPT_KEYSTROKE_RESTORE_PARAMETERS = "KeyStrokeRestoreParameters";
    public static final Data DEFVAL_KEYSTROKE_RESTORE_PARAMETERS_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_RESTORE_PARAMETERS_SYSTEM;
    public static final String OPT_KEYSTROKE_OPEN_TEXT_IN_EDITOR = "KeyStrokeOpenTextInEditor";
    public static final Data DEFVAL_KEYSTROKE_OPEN_TEXT_IN_EDITOR_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_OPEN_TEXT_IN_EDITOR_SYSTEM;
    public static final String OPT_KEYSTROKE_FORWARD_PARAMETERS = "KeyStrokeForwardParameters";
    public static final Data DEFVAL_KEYSTROKE_FORWARD_PARAMETERS_CLASSIC;
    public static final Data DEFVAL_KEYSTROKE_FORWARD_PARAMETERS_SYSTEM;
    private static final Logger logger;

    public KeyOption(String string, Data data) {
        super(string, data);
    }

    public KeyOption(String string, int n, char c, int n2) {
        this(string, new Data(n, c, n2));
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof KeyOption && super.equals(object);
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (KeyOption.logger.level >= 7) {
            logger.log(7, "setValue(Object)", KeyOption.logger.level < 8 ? "" : "value: " + object);
        }
        if (object != null && !(object instanceof Data)) {
            throw new IllegalArgumentException("Value is not a Data: " + object);
        }
        super.setValue(object);
    }

    @Override
    public String getValueAsString() {
        if (this.getValue() instanceof Data) {
            Data data = (Data)this.getValue();
            return "" + data.keyCode + "," + data.keyChar + "," + data.modifiers;
        }
        return "";
    }

    @Override
    public Object getValueFromString(String string) {
        if (KeyOption.logger.level >= 7) {
            Logger.Builder builder = logger.build("getValueFromString(String)");
            (KeyOption.logger.level < 8 ? builder : builder.add("value: ").add(string)).log(7);
        }
        if ("UNUSED".equals(string)) {
            throw new IllegalStateException("Unused -> Skip");
        }
        if (string.equals("")) {
            return null;
        }
        int n = string.indexOf(44);
        int n2 = string.indexOf(44, n + 1);
        if (n < 0 || n2 < 0) {
            if (KeyOption.logger.level >= 1) {
                logger.log(1, "getValueFromString(String)", "Bad value: " + string);
            }
            throw new IllegalStateException("Error -> Skip");
        }
        try {
            return new Data(Integer.parseInt(string.substring(0, n)), (char)Integer.parseInt(string.substring(n + 1, n2)), Integer.parseInt(string.substring(n2 + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            logger.log("getValueFromString(String)", numberFormatException);
            throw new IllegalStateException("Error -> Skip");
        }
    }

    static {
        DEFVAL_KEYSTROKE_TRIGGER_CONTEXTMENU_SYSTEM = DEFVAL_KEYSTROKE_TRIGGER_CONTEXTMENU_CLASSIC = new Data(121, 1);
        DEFVAL_KEYSTROKE_TRIGGER_EDIT_SYSTEM = DEFVAL_KEYSTROKE_TRIGGER_EDIT_CLASSIC = new Data(10, 8);
        DEFVAL_KEYSTROKE_TRIGGER_EDIT2_SYSTEM = DEFVAL_KEYSTROKE_TRIGGER_EDIT2_CLASSIC = new Data(10, 1);
        DEFVAL_KEYSTROKE_OPEN_RUNLOG_SYSTEM = DEFVAL_KEYSTROKE_OPEN_RUNLOG_CLASSIC = new Data(76, 2);
        DEFVAL_KEYSTROKE_CONTINUE_FROM_HERE_SYSTEM = DEFVAL_KEYSTROKE_CONTINUE_FROM_HERE_CLASSIC = new Data(44, 2);
        DEFVAL_KEYSTROKE_NEW_SUITE_SYSTEM = new Data(78, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_NEW_SUITE_CLASSIC = new Data(78, 2);
        DEFVAL_KEYSTROKE_OPEN_FILE_SYSTEM = new Data(79, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_OPEN_FILE_CLASSIC = new Data(79, 2);
        DEFVAL_KEYSTROKE_SAVE_FILE_SYSTEM = new Data(83, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_SAVE_FILE_CLASSIC = new Data(83, 2);
        DEFVAL_KEYSTROKE_SAVE_FILE_AS_CLASSIC = DEFVAL_KEYSTROKE_SAVE_FILE_AS_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(83, 5) : null;
        DEFVAL_KEYSTROKE_COPY_SYSTEM = new Data(67, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_COPY_CLASSIC = new Data(67, 2);
        DEFVAL_KEYSTROKE_COPY_TEXT_SYSTEM = new Data(67, VK_COMMAND_MASK + 1);
        DEFVAL_KEYSTROKE_PASTE_SYSTEM = new Data(86, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_PASTE_CLASSIC = new Data(86, 2);
        DEFVAL_KEYSTROKE_CUT_SYSTEM = new Data(88, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_CUT_CLASSIC = new Data(88, 2);
        DEFVAL_KEYSTROKE_UNDO_SYSTEM = new Data(90, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_UNDO_CLASSIC = new Data(90, 2);
        DEFVAL_KEYSTROKE_REDO_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(90, 5) : new Data(89, 2);
        DEFVAL_KEYSTROKE_REDO_CLASSIC = new Data(89, 2);
        DEFVAL_KEYSTROKE_SEARCH_SYSTEM = new Data(70, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_SEARCH_CLASSIC = new Data(70, 2);
        DEFVAL_KEYSTROKE_SEARCH_AGAIN_SYSTEM = new Data(71, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_SEARCH_AGAIN_CLASSIC = new Data(71, 2);
        DEFVAL_KEYSTROKE_SEARCH_CONTINUE_SYSTEM = DEFVAL_KEYSTROKE_SEARCH_CONTINUE_CLASSIC = new Data(114, 0);
        DEFVAL_KEYSTROKE_SEARCH_SWITCH_SEARCHMODE_SYSTEM = DEFVAL_KEYSTROKE_SEARCH_SWITCH_SEARCHMODE_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(87, 10) : new Data(87, 8);
        DEFVAL_KEYSTROKE_SEARCH_SWITCH_REPLACEMODE_SYSTEM = DEFVAL_KEYSTROKE_SEARCH_SWITCH_REPLACEMODE_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(77, 10) : new Data(77, 8);
        DEFVAL_KEYSTROKE_SEARCH_RESET_SYSTEM = DEFVAL_KEYSTROKE_SEARCH_RESET_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(90, 10) : new Data(90, 8);
        DEFVAL_KEYSTROKE_REPLACE_SYSTEM = DEFVAL_KEYSTROKE_REPLACE_CLASSIC = new Data(72, 2);
        DEFVAL_KEYSTROKE_TOGGLE_FULLSCREEN_SYSTEM = DEFVAL_KEYSTROKE_TOGGLE_FULLSCREEN_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(70, 6) : null;
        DEFVAL_KEYSTROKE_SWITCH_TABS_SYSTEM = Misc.OS_IS_MAC_OS_X ? 4 : 8;
        DEFVAL_KEYSTROKE_SELECT_ALL_SYSTEM = new Data(65, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_SELECT_ALL_CLASSIC = new Data(65, 2);
        DEFVAL_KEYSTROKE_DELETE_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(8, 4) : new Data(127, 0);
        DEFVAL_KEYSTROKE_DELETE_CLASSIC = new Data(127, 0);
        DEFVAL_KEYSTROKE_DOCUMENT_HOME_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(38, 4) : new Data(36, 2);
        DEFVAL_KEYSTROKE_DOCUMENT_HOME_CLASSIC = new Data(36, 2);
        DEFVAL_KEYSTROKE_DOCUMENT_END_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(40, 4) : new Data(35, 2);
        DEFVAL_KEYSTROKE_DOCUMENT_END_CLASSIC = new Data(35, 2);
        DEFVAL_KEYSTROKE_SELECT_DOCUMENT_HOME_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(38, 5) : new Data(36, 3);
        DEFVAL_KEYSTROKE_SELECT_DOCUMENT_HOME_CLASSIC = new Data(36, 2);
        DEFVAL_KEYSTROKE_SELECT_DOCUMENT_END_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(40, 5) : new Data(35, 3);
        DEFVAL_KEYSTROKE_SELECT_DOCUMENT_END_CLASSIC = new Data(35, 3);
        DEFVAL_KEYSTROKE_HOME_SYSTEM = DEFVAL_KEYSTROKE_HOME_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(37, 4) : new Data(36, 0);
        DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_SYSTEM = DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_CLASSIC = new Data(122, VK_COMMAND_MASK + 1);
        DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_MODE_SYSTEM = DEFVAL_KEYSTROKE_HOTKEY_INSPECTOR_MODE_CLASSIC = new Data(123, VK_COMMAND_MASK + 1);
        DEFVAL_KEYSTROKE_END_SYSTEM = DEFVAL_KEYSTROKE_END_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(39, 4) : new Data(35, 0);
        DEFVAL_KEYSTROKE_SELECT_HOME_SYSTEM = DEFVAL_KEYSTROKE_SELECT_HOME_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(37, 5) : new Data(36, 1);
        DEFVAL_KEYSTROKE_SELECT_END_SYSTEM = DEFVAL_KEYSTROKE_SELECT_END_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(39, 5) : new Data(35, 1);
        DEFVAL_KEYSTROKE_PREV_WORD_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(37, 8) : new Data(37, 2);
        DEFVAL_KEYSTROKE_PREV_WORD_CLASSIC = new Data(37, 2);
        DEFVAL_KEYSTROKE_NEXT_WORD_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(39, 8) : new Data(39, 2);
        DEFVAL_KEYSTROKE_NEXT_WORD_CLASSIC = new Data(39, 2);
        DEFVAL_KEYSTROKE_SELECT_PREV_WORD_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(37, 9) : new Data(37, 3);
        DEFVAL_KEYSTROKE_SELECT_PREV_WORD_CLASSIC = new Data(37, 3);
        DEFVAL_KEYSTROKE_SELECT_NEXT_WORD_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(39, 9) : new Data(39, 3);
        DEFVAL_KEYSTROKE_SELECT_NEXT_WORD_CLASSIC = new Data(39, 3);
        DEFVAL_KEYSTROKE_MOVE_LINE_UP_SYSTEM = new Data(38, 8);
        DEFVAL_KEYSTROKE_MOVE_LINE_UP_CLASSIC = new Data(38, 8);
        DEFVAL_KEYSTROKE_MOVE_LINE_DOWN_SYSTEM = new Data(40, 8);
        DEFVAL_KEYSTROKE_MOVE_LINE_DOWN_CLASSIC = new Data(40, 8);
        DEFVAL_KEYSTROKE_CLONE_LINE_UP_SYSTEM = new Data(38, 9);
        DEFVAL_KEYSTROKE_CLONE_LINE_UP_CLASSIC = new Data(38, 9);
        DEFVAL_KEYSTROKE_CLONE_LINE_DOWN_SYSTEM = new Data(40, 9);
        DEFVAL_KEYSTROKE_CLONE_LINE_DOWN_CLASSIC = new Data(40, 9);
        DEFVAL_KEYSTROKE_DELETE_WORD_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(127, 8) : new Data(127, 2);
        DEFVAL_KEYSTROKE_DELETE_WORD_CLASSIC = new Data(127, 2);
        DEFVAL_KEYSTROKE_BACKSPACE_WORD_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(8, 8) : new Data(8, 2);
        DEFVAL_KEYSTROKE_BACKSPACE_WORD_CLASSIC = new Data(8, 2);
        DEFVAL_KEYSTROKE_CLOSESUITE_CLASSIC = DEFVAL_KEYSTROKE_CLOSESUITE_SYSTEM = Misc.OS_IS_MAC_OS_X ? new Data(87, 4) : null;
        DEFVAL_KEYSTROKE_HIGHLIGHT_COMPONENT_SYSTEM = DEFVAL_KEYSTROKE_HIGHLIGHT_COMPONENT_CLASSIC = null;
        DEFVAL_KEYSTROKE_LOCATE_COMPONENT_SYSTEM = DEFVAL_KEYSTROKE_LOCATE_COMPONENT_CLASSIC = new Data(87, 2);
        DEFVAL_KEYSTROKE_LOCATE_ANY_SYSTEM = DEFVAL_KEYSTROKE_LOCATE_ANY_CLASSIC = new Data(80, 2);
        DEFVAL_KEYSTROKE_LOCATE_STEP_SYSTEM = DEFVAL_KEYSTROKE_LOCATE_STEP_CLASSIC = new Data(84, 2);
        DEFVAL_KEYSTROKE_LOCATE_REFERENCES_SYSTEM = DEFVAL_KEYSTROKE_LOCATE_REFERENCES_CLASSIC = new Data(73, 2);
        DEFVAL_KEYSTROKE_UPDATE_CHECK_SYSTEM = DEFVAL_KEYSTROKE_UPDATE_CHECK_CLASSIC = new Data(85, 2);
        DEFVAL_KEYSTROKE_INSERT_PROCEDURE_CALL_SYSTEM = DEFVAL_KEYSTROKE_INSERT_PROCEDURE_CALL_CLASSIC = new Data(65, 2);
        DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_CLASSIC = new Data(55, 2);
        DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_ALT_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_ALT_CLASSIC = new Data(47, 2);
        DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_CLASSIC = new Data(103, 2);
        DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_ALT_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENT_STEP_NUM_ALT_CLASSIC = new Data(111, 2);
        DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_CLASSIC = new Data(55, 3);
        DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_ALT_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_ALT_CLASSIC = new Data(47, 3);
        DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_CLASSIC = new Data(103, 3);
        DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_ALT_SYSTEM = DEFVAL_KEYSTROKE_INSERT_COMMENTABOVE_STEP_NUM_ALT_CLASSIC = new Data(111, 3);
        DEFVAL_KEYSTROKE_PACK_IN_SEQUENCE_SYSTEM = DEFVAL_KEYSTROKE_PACK_IN_SEQUENCE_CLASSIC = new Data(83, 3);
        DEFVAL_KEYSTROKE_PACK_IN_IF_SYSTEM = DEFVAL_KEYSTROKE_PACK_IN_IF_CLASSIC = new Data(73, 3);
        DEFVAL_KEYSTROKE_PACK_IN_TESTSTEP_SYSTEM = DEFVAL_KEYSTROKE_PACK_IN_TESTSTEP_CLASSIC = new Data(84, 3);
        DEFVAL_KEYSTROKE_PACK_IN_TRY_SYSTEM = DEFVAL_KEYSTROKE_PACK_IN_TRY_CLASSIC = new Data(89, 3);
        DEFVAL_KEYSTROKE_TRANSFROM_IN_PROCEDURE_SYSTEM = DEFVAL_KEYSTROKE_TRANSFROM_IN_PROCEDURE_CLASSIC = new Data(80, 3);
        DEFVAL_KEYSTROKE_DEBUGGER_SINGLESTEP_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_SINGLESTEP_CLASSIC = new Data(118, 0);
        DEFVAL_KEYSTROKE_DEBUGGER_STEPOVER_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_STEPOVER_CLASSIC = new Data(119, 0);
        DEFVAL_KEYSTROKE_DEBUGGER_STEPOUT_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_STEPOUT_CLASSIC = new Data(118, 2);
        DEFVAL_KEYSTROKE_DEBUGGER_SKIPOVER_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_SKIPOVER_CLASSIC = new Data(120, 1);
        DEFVAL_KEYSTROKE_DEBUGGER_SKIPOUT_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_SKIPOUT_CLASSIC = new Data(120, 2);
        DEFVAL_KEYSTROKE_DEBUGGER_TOGGLE_BREAKPOINT_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_TOGGLE_BREAKPOINT_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(66, 5) : new Data(119, 2);
        DEFVAL_KEYSTROKE_DEBUGGER_JUMP_LOG_SYSTEM = DEFVAL_KEYSTROKE_DEBUGGER_JUMP_LOG_CLASSIC = new Data(74, 2);
        DEFVAL_KEYSTROKE_RUN_PAUSE_SYSTEM = DEFVAL_KEYSTROKE_RUN_PAUSE_CLASSIC = new Data(120, 0);
        DEFVAL_KEYSTROKE_ISEARCH_SYSTEM = DEFVAL_KEYSTROKE_ISEARCH_CLASSIC = new Data(70, VK_COMMAND_MASK);
        DEFVAL_KEYSTROKE_ISEARCH_REGION_SYSTEM = DEFVAL_KEYSTROKE_ISEARCH_REGION_CLASSIC = new Data(70, VK_COMMAND_MASK + 1);
        DEFVAL_KEYSTROKE_MARKS_TOGGLE_SYSTEM = DEFVAL_KEYSTROKE_MARKS_TOGGLE_CLASSIC = new Data(77, 2);
        DEFVAL_KEYSTROKE_MARKS_NEXT_SYSTEM = DEFVAL_KEYSTROKE_MARKS_NEXT_CLASSIC = new Data(69, 2);
        DEFVAL_KEYSTROKE_MARKS_PREVIOUS_SYSTEM = DEFVAL_KEYSTROKE_MARKS_PREVIOUS_CLASSIC = new Data(69, 3);
        DEFVAL_KEYSTROKE_TREE_PREVIOUS_NODE_SYSTEM = DEFVAL_KEYSTROKE_TREE_PREVIOUS_NODE_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(37, 6) : new Data(8, 2);
        DEFVAL_KEYSTROKE_TREE_NEXT_NODE_SYSTEM = DEFVAL_KEYSTROKE_TREE_NEXT_NODE_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(39, 6) : new Data(8, 3);
        DEFVAL_KEYSTROKE_TREE_PREVIOUS_SIBLING_SYSTEM = DEFVAL_KEYSTROKE_TREE_PREVIOUS_SIBLING_CLASSIC = new Data(38, 8);
        DEFVAL_KEYSTROKE_TREE_NEXT_SIBLING_SYSTEM = DEFVAL_KEYSTROKE_TREE_NEXT_SIBLING_CLASSIC = new Data(40, 8);
        DEFVAL_KEYSTROKE_TREE_CLEAN_SYSTEM = DEFVAL_KEYSTROKE_TREE_CLEAN_CLASSIC = new Data(46, 2);
        DEFVAL_KEYSTROKE_TREE_EXPAND_SYSTEM = DEFVAL_KEYSTROKE_TREE_EXPAND_CLASSIC = new Data(39, 8);
        DEFVAL_KEYSTROKE_TREE_COLLAPSE_SYSTEM = DEFVAL_KEYSTROKE_TREE_COLLAPSE_CLASSIC = new Data(37, 8);
        DEFVAL_KEYSTROKE_PARAM_ADD_TO_CALLERS_SYSTEM = DEFVAL_KEYSTROKE_PARAM_ADD_TO_CALLERS_CLASSIC = new Data(76, 3);
        DEFVAL_KEYSTROKE_PARAM_REMOVE_SYSTEM = DEFVAL_KEYSTROKE_PARAM_REMOVE_CLASSIC = new Data(127, 2);
        DEFVAL_KEYSTROKE_RUNLOG_NEXT_WARNING_SYSTEM = DEFVAL_KEYSTROKE_RUNLOG_NEXT_WARNING_CLASSIC = new Data(87, 2);
        DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_WARNING_SYSTEM = DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_WARNING_CLASSIC = new Data(87, 3);
        DEFVAL_KEYSTROKE_RUNLOG_NEXT_EXCEPTION_SYSTEM = DEFVAL_KEYSTROKE_RUNLOG_NEXT_EXCEPTION_CLASSIC = new Data(78, 2);
        DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_EXCEPTION_SYSTEM = DEFVAL_KEYSTROKE_RUNLOG_PREVIOUS_EXCEPTION_CLASSIC = new Data(78, 3);
        DEFVAL_KEYSTROKE_RESULTLIST_SYSTEM = DEFVAL_KEYSTROKE_RESULTLIST_CLASSIC = new Data(73, 2);
        DEFVAL_KEYSTROKE_DISABLESTEP_SYSTEM = DEFVAL_KEYSTROKE_DISABLESTEP_CLASSIC = new Data(68, 3);
        DEFVAL_KEYSTROKE_REFRESH_SYSTEM = DEFVAL_KEYSTROKE_REFRESH_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(82, 4) : new Data(116, 0);
        DEFVAL_KEYSTROKE_REFRESH_DEEP_SYSTEM = DEFVAL_KEYSTROKE_REFRESH_DEEP_CLASSIC = Misc.OS_IS_MAC_OS_X ? new Data(82, 5) : new Data(116, 1);
        DEFVAL_KEYSTROKE_TERMINAL_PREVIOUS_CALL_SYSTEM = DEFVAL_KEYSTROKE_TERMINAL_PREVIOUS_CALL_CLASSIC = new Data(38, 2);
        DEFVAL_KEYSTROKE_TERMINAL_NEXT_CALL_SYSTEM = DEFVAL_KEYSTROKE_TERMINAL_NEXT_CALL_CLASSIC = new Data(40, 2);
        DEFVAL_KEYSTROKE_SHOW_TERMINAL_SYSTEM = DEFVAL_KEYSTROKE_SHOW_TERMINAL_CLASSIC = new Data(84, 2);
        DEFVAL_KEYSTROKE_ADD_BOOKMARK_SYSTEM = DEFVAL_KEYSTROKE_ADD_BOOKMARK_CLASSIC = new Data(68, 2);
        DEFVAL_KEYSTROKE_REMOVE_SYSTEM = DEFVAL_KEYSTROKE_REMOVE_CLASSIC = new Data(127, 1);
        DEFVAL_KEYSTROKE_INSERT_SYSTEM = DEFVAL_KEYSTROKE_INSERT_CLASSIC = new Data(155, 1);
        DEFVAL_KEYSTROKE_RENAME_SYSTEM = DEFVAL_KEYSTROKE_RENAME_CLASSIC = new Data(113, 0);
        DEFVAL_KEYSTROKE_FOCUS_STEP_SYSTEM = DEFVAL_KEYSTROKE_FOCUS_STEP_CLASSIC = new Data(88, 3);
        DEFVAL_KEYSTROKE_MULTIRESULT_REPLACE_SYSTEM = DEFVAL_KEYSTROKE_MULTIRESULT_REPLACE_CLASSIC = new Data(82, 2);
        DEFVAL_KEYSTROKE_COPY_PATH_SYSTEM = new Data(67, Misc.OS_IS_MAC_OS_X ? 7 : 11);
        DEFVAL_KEYSTROKE_COPY_PATH_CLASSIC = new Data(67, 3);
        DEFVAL_KEYSTROKE_GOTO_PATH_SYSTEM = new Data(86, Misc.OS_IS_MAC_OS_X ? 7 : 11);
        DEFVAL_KEYSTROKE_GOTO_PATH_CLASSIC = new Data(86, 3);
        DEFVAL_KEYSTROKE_RESTORE_PARAMETERS_CLASSIC = null;
        DEFVAL_KEYSTROKE_RESTORE_PARAMETERS_SYSTEM = null;
        DEFVAL_KEYSTROKE_OPEN_TEXT_IN_EDITOR_CLASSIC = null;
        DEFVAL_KEYSTROKE_OPEN_TEXT_IN_EDITOR_SYSTEM = new Data(10, VK_COMMAND_MASK | 1);
        DEFVAL_KEYSTROKE_FORWARD_PARAMETERS_CLASSIC = null;
        DEFVAL_KEYSTROKE_FORWARD_PARAMETERS_SYSTEM = new Data(39, 3);
        logger = new Logger("de.qfs.lib.option.KeyOption");
    }

    public static class Data
    implements Cloneable,
    Serializable {
        public int keyCode;
        public char keyChar;
        public int modifiers;

        public Data(int n, char c, int n2) {
            this.keyCode = n;
            this.keyChar = c;
            this.modifiers = n2;
        }

        public Data(int n, int n2) {
            this.keyCode = n;
            this.keyChar = (char)65535;
            this.modifiers = n2;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public int hashCode() {
            return (this.modifiers << 24) + (this.keyChar << 8) + this.keyCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Data)) {
                return false;
            }
            Data data = (Data)object;
            return data.keyCode == this.keyCode && data.keyChar == this.keyChar && data.modifiers == this.modifiers;
        }

        public String toString() {
            return super.toString() + "[keyCode=" + this.keyCode + ",keyChar=" + this.keyChar + ",modifiers=" + this.modifiers + "]";
        }

        public boolean isUndefined() {
            return this.keyCode == 0 && this.keyChar == '\uffff' && this.modifiers == 0;
        }
    }
}

