/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.Option;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class KeyOptionsState {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.KeyOptionsState");
    private static KeyOptionsState instance;
    private Map<String, KeyOption.Data> hotkeysInUse = new HashMap<String, KeyOption.Data>(5);
    private Map<String, KeyOption.Data> hotkeysPotentiallyInUse = new HashMap<String, KeyOption.Data>(5);
    private Set<String> hotkeysToWatch = new HashSet<String>(5);

    public KeyOptionsState() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "KeyOptionsState.KeyOptionsState()", 11).log();
        }
    }

    public static KeyOptionsState instance() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "instance()", 21).log();
        }
        if (instance == null) {
            instance = new KeyOptionsState();
        }
        return instance;
    }

    public String getOptionNameHotkeyPotentiallyInUseFor(KeyOption keyOption) {
        if (KeyOptionsState.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOptionNameHotkeyPotentiallyInUseFor(KeyOption)", 29).addDetail("hotkeyOption", keyOption)).log();
        }
        if (!this.hotkeysToWatch.contains(keyOption.getName())) {
            return null;
        }
        for (Map.Entry<String, KeyOption.Data> entry : this.hotkeysPotentiallyInUse.entrySet()) {
            if (entry.getKey().equals(keyOption.getName()) || !entry.getValue().equals(keyOption.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addHotkeyToWatch(String string) {
        if (KeyOptionsState.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addHotkeyToWatch(String)", 42).addDetail("hotkeyOptionName", string)).log();
        }
        this.hotkeysToWatch.add(string);
        if (KeyOptionsState.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "addHotkeyToWatch(String)", 45).add("hotkeysToWatch", this.hotkeysToWatch)).log();
        }
    }

    public void addHotkeyToInUse(Option option) {
        if (KeyOptionsState.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addHotkeyToInUse(Option)", 48).addDetail("hotkeyOption", option)).log();
        }
        if (!this.hotkeysToWatch.contains(option.getName())) {
            return;
        }
        if (option instanceof KeyOption) {
            this.hotkeysInUse.put(option.getName(), (KeyOption.Data)option.getValue());
        }
    }

    public void removeHotkeyFromInUse(KeyOption keyOption) {
        if (KeyOptionsState.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeHotkeyFromInUse(KeyOption)", 57).addDetail("hotkeyOption", keyOption)).log();
        }
        if (!this.hotkeysToWatch.contains(keyOption.getName())) {
            return;
        }
        this.hotkeysInUse.remove(keyOption.getName());
    }

    public void resetHotkeysPotentiallyInUse() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "resetHotkeysPotentiallyInUse()", 64).log();
        }
        this.hotkeysPotentiallyInUse = new HashMap<String, KeyOption.Data>(this.hotkeysInUse);
    }

    public void addHotkeyToPotentiallyInUse(KeyOption keyOption) {
        if (KeyOptionsState.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addHotkeyToPotentiallyInUse(KeyOption)", 68).addDetail("hotkeyOption", keyOption)).log();
        }
        if (!this.hotkeysToWatch.contains(keyOption.getName())) {
            return;
        }
        this.hotkeysPotentiallyInUse.put(keyOption.getName(), (KeyOption.Data)keyOption.getValue());
    }

    public void removeHotkeyFromPotentiallyInUse(String string) {
        if (KeyOptionsState.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeHotkeyFromPotentiallyInUse(String)", 75).addDetail("optionName", string)).log();
        }
        if (!this.hotkeysToWatch.contains(string)) {
            return;
        }
        this.hotkeysPotentiallyInUse.remove(string);
    }

    protected int getNumberOfHotkeysInUse() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "getNumberOfHotkeysInUse()", 83).log();
        }
        return this.hotkeysInUse.size();
    }

    protected int getNumberOfHotkeysPotentiallyInUse() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "getNumberOfHotkeysPotentiallyInUse()", 88).log();
        }
        return this.hotkeysPotentiallyInUse.size();
    }

    protected void resetHotkeyInUse() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "resetHotkeyInUse()", 93).log();
        }
        this.hotkeysInUse = new HashMap<String, KeyOption.Data>(5);
    }

    protected void resetHotkeyInWatch() {
        if (KeyOptionsState.logger.level >= 7) {
            logger.lvlBuild(7, "resetHotkeyInWatch()", 97).log();
        }
        this.hotkeysToWatch = new HashSet<String>(5);
    }
}

