/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.IntegerOption;
import lombok.Generated;

public class LimitedIntegerOption
extends IntegerOption {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.LimitedIntegerOption");
    int minValue;
    int maxValue;

    public LimitedIntegerOption(String string, Integer n, boolean bl, boolean bl2, int n2, int n3) {
        super(string, n, bl, bl2);
        if (LimitedIntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "LimitedIntegerOption(String,Integer,boolean,boolean,int,int)", 35).addDetail("name", string)).addDetail("value", n)).addDetail("nullOK", bl)).addDetail("negativeOK", bl2)).addDetail("minValue", n2)).addDetail("maxValue", n3)).log();
        }
        this.minValue = n2;
        this.maxValue = n3;
        this.checkLimits();
    }

    protected void checkLimits() {
        if (LimitedIntegerOption.logger.level >= 7) {
            logger.lvlBuild(7, "checkLimits()", 48).log();
        }
        Integer n = (Integer)this.getValue();
        this.checkLimits(n, this.minValue, this.maxValue);
    }

    protected void checkLimits(Integer n, int n2, int n3) {
        if (LimitedIntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "checkLimits(Integer,int,int)", 56).addDetail("value", n)).addDetail("minValue", n2)).addDetail("maxValue", n3)).log();
        }
        if (this.isNullOK() && n == null) {
            if (n2 > n3) {
                throw new IllegalArgumentException(String.format("Max value %d is lower than min value %d", n3, n2));
            }
        } else if (n < n2 || n > n3) {
            throw new IllegalArgumentException(String.format("%d is not within [%d,%d]", n, n2, n3));
        }
    }

    public void setMinValue(int n) {
        if (LimitedIntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMinValue(int)", 70).addDetail("minValue", n)).log();
        }
        this.checkLimits((Integer)this.getValue(), n, this.maxValue);
        this.minValue = n;
    }

    public void setMaxValue(int n) {
        if (LimitedIntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMaxValue(int)", 79).addDetail("maxValue", n)).log();
        }
        this.checkLimits((Integer)this.getValue(), this.minValue, n);
        this.maxValue = n;
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (LimitedIntegerOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 89).addDetail("value", object)).log();
        }
        this.checkValueType(object);
        this.checkLimits((Integer)object, this.minValue, this.maxValue);
        super.setValue(object);
    }

    @Generated
    public int getMinValue() {
        if (LimitedIntegerOption.logger.level >= 7) {
            logger.lvlBuild(7, "getMinValue()", 18).log();
        }
        return this.minValue;
    }

    @Generated
    public int getMaxValue() {
        if (LimitedIntegerOption.logger.level >= 7) {
            logger.lvlBuild(7, "getMaxValue()", 19).log();
        }
        return this.maxValue;
    }
}

