/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionValidator;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observed;
import java.awt.Component;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import lombok.Generated;
import lombok.NonNull;

public class Option
extends Observed
implements Serializable,
Cloneable {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.Option");
    static final long serialVersionUID = 3380333241949153766L;
    private static MapResourceBundle rb = new MapResourceBundle();
    private transient Vector validators;
    private String name;
    private Object value;
    private Object defaultValue;
    private boolean nullOK;
    private boolean verifiable;
    private String verificationString;

    public Option() {
        if (Option.logger.level >= 7) {
            logger.lvlBuild(7, "Option()", 148).log();
        }
    }

    public Option(String string, Object object) {
        this(string, object, false);
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Option(String,Object)", 158).addDetail("name", string)).addDetail("value", object)).log();
        }
    }

    public Option(String string, Object object, boolean bl) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Option(String,Object,boolean)", 170).addDetail("name", string)).addDetail("value", object)).addDetail("nullOK", bl)).log();
        }
        this.name = string;
        this.value = object;
        this.defaultValue = object;
        this.nullOK = bl;
    }

    public static final MapResourceBundle getResources() {
        return rb;
    }

    public static final void setResources(ResourceBundle resourceBundle) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setResources(ResourceBundle)", 210).addDetail("resources", resourceBundle)).log();
        }
        rb = resourceBundle == null ? new MapResourceBundle() : (resourceBundle instanceof MapResourceBundle ? (MapResourceBundle)resourceBundle : new MapResourceBundle(resourceBundle));
    }

    public static final void addResources(ResourceBundle resourceBundle) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addResources(ResourceBundle)", 230).addDetail("resources", resourceBundle)).log();
        }
        rb.addResources(resourceBundle);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setName(String)", 261).addDetail("name", string)).log();
        }
        this.name = string;
    }

    public Object getValue() {
        return this.value;
    }

    @NonNull
    public String getValueAsString() {
        String string;
        block3: {
            if (Option.logger.level >= 7) {
                logger.lvlBuild(7, "getValueAsString()", 287).log();
            }
            string = "???";
            try {
                string = String.valueOf(this.getValue());
            }
            catch (Throwable throwable) {
                if (Option.logger.level < 9) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getValueAsString()", 293).add("ex", throwable)).log();
            }
        }
        return string;
    }

    public void setValueFromString(String string) {
        block4: {
            if (Option.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValueFromString(String)", 304).addDetail("val", string)).log();
            }
            try {
                Object object = this.getValueFromString(string);
                if (Option.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setValueFromString(String)", 308).add("valObject", object)).log();
                }
                this.setValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                if (Option.logger.level < 9) break block4;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setValueFromString(String)", 311).add("Skipping setValue")).log();
            }
        }
    }

    public Object getValueFromString(String string) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getValueFromString(String)", 322).addDetail("val", string)).log();
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefaultValue(Object)", 349).addDetail("defaultValue", object)).log();
        }
        this.defaultValue = object;
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 366).addDetail("value", object)).log();
        }
        this.value = object;
        if (this.verifiable) {
            this.setVerificationString();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isNullOK() {
        return this.nullOK;
    }

    public void setNullOK(boolean bl) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setNullOK(boolean)", 399).addDetail("nullOK", bl)).log();
        }
        this.nullOK = bl;
    }

    public boolean checkValue(Component component, Object object) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "checkValue(Component,Object)", 421).addDetail("component", component)).addDetail("value", object)).log();
        }
        boolean bl = Misc.emptyOrNull(object);
        if (!this.nullOK && bl) {
            if (component != null) {
                Message.showMessageAndHighlight(component, "option.error.empty");
            }
            return false;
        }
        if (this.validators != null) {
            for (int i = 0; i < this.validators.size(); ++i) {
                OptionValidator optionValidator = (OptionValidator)this.validators.elementAt(i);
                if (optionValidator.checkValue(component, this, object)) continue;
                return false;
            }
        }
        return true;
    }

    public void addValidator(OptionValidator optionValidator) {
        if (this.validators == null) {
            this.validators = new Vector();
        }
        this.validators.addElement(optionValidator);
    }

    public void removeValidator(OptionValidator optionValidator) {
        if (this.validators != null) {
            this.validators.removeElement(optionValidator);
        }
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + "[name=" + this.name + ",value=" + this.value;
        if (this.verifiable) {
            string = string + ",verification=" + this.verificationString;
        }
        return string + "]";
    }

    public int hashCode() {
        return this.name.hashCode() + (this.value == null ? 0 : this.value.hashCode());
    }

    public boolean equals(Object object) {
        Option option;
        return object instanceof Option && this.name.equals((option = (Option)object).getName()) && (this.value == null && option.getValue() == null || this.value.equals(option.getValue()));
    }

    public Object clone() {
        if (Option.logger.level >= 7) {
            logger.lvlBuild(7, "clone()", 548).log();
        }
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setVerifiable(boolean bl) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setVerifiable(boolean)", 561).addDetail("verifiable", bl)).log();
        }
        if (bl && this.verificationString == null) {
            this.setVerificationString();
        }
        this.verifiable = bl;
    }

    public boolean verify() {
        if (Option.logger.level >= 7) {
            logger.lvlBuild(7, "verify()", 576).log();
        }
        try {
            if (this.verificationString == null) {
                return false;
            }
            String[] stringArray = Misc.fastSplit(this.verificationString, ';', 4);
            if (stringArray.length != 4) {
                return false;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            if (!string4.equals(this.getValueAsString())) {
                return false;
            }
            return this.verificationString.equals(this.createVerificationString(string2, string3, string4));
        }
        catch (Throwable throwable) {
            if (Option.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "verify()", 590).add("t", throwable)).log();
            }
            return false;
        }
    }

    @NonNull
    static String getUsername() {
        String string;
        if (Option.logger.level >= 7) {
            logger.lvlBuild(7, "getUsername()", 602).log();
        }
        if (Misc.emptyOrNull(string = System.getProperty("user.name"))) {
            string = "user?";
        }
        return string.replace(";", ":");
    }

    private void setVerificationString() {
        if (Option.logger.level >= 7) {
            logger.lvlBuild(7, "setVerificationString()", 614).log();
        }
        String string = "" + System.currentTimeMillis();
        String string2 = Option.getUsername();
        String string3 = this.getValueAsString();
        this.verificationString = this.createVerificationString(string, string2, string3);
    }

    protected String createVerificationString(String string, String string2, String string3) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createVerificationString(String,String,String)", 626).addDetail("timestamp", string)).addDetail("username", string2)).addDetail("valueString", string3)).log();
        }
        try {
            String string4 = string + ";" + string2 + ";" + string3;
            return Misc.hashString(string4, "SHA") + ";" + string + ";" + string2 + ";" + string3;
        }
        catch (Throwable throwable) {
            if (Option.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "createVerificationString(String,String,String)", 632).add("ex", throwable)).log();
            }
            return null;
        }
    }

    public String getConfigurableValue() {
        if (this.isVerifiable()) {
            return this.verificationString;
        }
        return this.getValueAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurableValue(String string) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableValue(String)", 662).addDetail("val", string)).log();
        }
        if (this.isVerifiable()) {
            String[] stringArray;
            String string2 = string;
            if (string2 != null && (stringArray = Misc.fastSplit(string2, ';', 4)).length > 0) {
                string2 = stringArray[stringArray.length - 1];
            }
            try {
                this.setValueFromString(string2);
            }
            finally {
                this.verificationString = string;
            }
        } else {
            this.setValueFromString(string);
        }
    }

    public boolean contains(String string) {
        if (Option.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "contains(String)", 692).addDetail("value", string)).log();
        }
        return false;
    }

    @Generated
    public boolean isVerifiable() {
        if (Option.logger.level >= 7) {
            logger.lvlBuild(7, "isVerifiable()", 124).log();
        }
        return this.verifiable;
    }

    static {
        try {
            rb.fetchProperties("/de/qfs/lib/resources/properties/qflib", Option.class);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

