/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.QfFrame;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import lombok.Generated;

public class OptionFrame
extends QfFrame {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.OptionFrame");
    protected OptionSet options;
    protected String root;
    protected OptionGroup optionGroup;

    public OptionFrame(String string, OptionSet optionSet, String string2) {
        super(string);
        this.options = optionSet;
        this.root = string2 == null ? optionSet.getConfigurableName() : string2;
        this.init(Option.getResources());
        if (Option.getResources().getString(this.resName("name"), null) == null) {
            this.setName("OptionFrame-" + string2 + "-" + optionSet.getConfigurableName());
        }
    }

    public OptionFrame(String string, OptionSet optionSet, String string2, OptionFrame optionFrame) {
        super(string);
        this.options = optionSet;
        this.root = string2 == null ? optionSet.getConfigurableName() : string2;
        this.optionGroup = optionFrame.getGroup();
        this.init(Option.getResources());
        if (Option.getResources().getString(this.resName("name"), null) == null) {
            this.setName("OptionFrame-" + string2 + "-" + optionSet.getConfigurableName());
        }
    }

    public boolean readValues() {
        if (this.optionGroup != null) {
            if (!this.optionGroup.checkValues()) {
                return false;
            }
            this.optionGroup.readValues();
            this.optionGroup.notifyOptionObservers();
            this.options.notifyObservers();
        }
        return true;
    }

    public void update(OptionSet optionSet) {
        if (OptionFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(OptionSet)", 191).addDetail("options", optionSet)).log();
        }
        this.optionGroup.update(optionSet == null ? this.options : optionSet);
    }

    public void update(String string, OptionSet optionSet) {
        if (OptionFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "update(String,OptionSet)", 205).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        this.root = string;
        this.optionGroup = OptionGroup.makeGroup(this.root, optionSet);
        if (OptionFrame.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "update(String,OptionSet)", 209).add("optionGroup", this.optionGroup)).log();
        }
        if (this.optionGroup != null) {
            Component component = this.optionGroup.getComponent();
            if (component instanceof Grid && ((Grid)this.mainComponent).needGlue()) {
                ((Grid)component).addGlue();
            }
            if (OptionFrame.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "update(String,OptionSet)", 216).add("com", component)).log();
            }
            this.setMainComponent(component);
        } else {
            this.setMainComponent(new JLabel("MISSING OptionGroup: " + this.root));
        }
    }

    public OptionGroup getGroup() {
        return this.optionGroup;
    }

    @Override
    protected void initComponent() {
        if (OptionFrame.logger.level >= 7) {
            logger.lvlBuild(7, "initComponent()", 248).log();
        }
        if (this.optionGroup == null) {
            this.optionGroup = OptionGroup.makeGroup(this.root, this.options);
        }
        this.mainComponent = null;
        if (this.optionGroup != null) {
            this.mainComponent = this.optionGroup.getComponent();
            if (this.mainComponent instanceof Grid && ((Grid)this.mainComponent).needGlue()) {
                ((Grid)this.mainComponent).addGlue();
            }
        }
        if (this.mainComponent == null) {
            this.mainComponent = new JLabel("MISSING OptionGroup: " + this.root);
        }
    }

    @Override
    protected QfFrame.ButtonData initButton(String string, MapResourceBundle mapResourceBundle) {
        return new OptionButtonData(string, mapResourceBundle);
    }

    @Override
    public void dispose() {
        if (OptionFrame.logger.level >= 7) {
            logger.lvlBuild(7, "dispose()", 296).dumpStack();
        }
        this.optionGroup = null;
        this.options = null;
        super.dispose();
    }

    @Override
    public void addWindowListener(WindowListener windowListener) {
        if (OptionFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addWindowListener(WindowListener)", 313).addDetail("wl", windowListener)).dumpStack();
        }
        super.addWindowListener(windowListener);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (OptionFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "windowClosing(WindowEvent)", 324).addDetail("e", windowEvent)).dumpStack();
        }
        super.windowClosing(windowEvent);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (OptionFrame.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "windowClosed(WindowEvent)", 334).addDetail("e", windowEvent)).dumpStack();
        }
        super.windowClosed(windowEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            int n = this.findButton((JButton)actionEvent.getSource());
            if (n >= 0 && this.buttons[n] instanceof OptionButtonData && ((OptionButtonData)this.buttons[n]).set && !this.readValues()) {
                return;
            }
            super.actionPerformed(actionEvent);
        }
    }

    protected static class OptionButtonData
    extends QfFrame.ButtonData {
        public boolean set;

        public OptionButtonData() {
        }

        public OptionButtonData(String string, MapResourceBundle mapResourceBundle) {
            super(string, mapResourceBundle);
            this.set = mapResourceBundle.getBoolean(OptionFrame.buttonResName(string, "set"), false);
        }
    }
}

