/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.ConfigurableOption;
import de.qfs.lib.option.NestedOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.option.TextOption;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observed;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Pair;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import lombok.Generated;

public class OptionSet
extends Observed
implements Serializable,
Cloneable,
Configurable,
Observer {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.OptionSet");
    static final long serialVersionUID = -2172456472965747088L;
    public static final String PERSISTENT_LAYER_NAME = "default";
    protected transient Map<String, Option> options = Collections.synchronizedMap(new HashMap());
    protected transient Map<String, LinkedList<Object>> valueStacks = Collections.synchronizedMap(new HashMap());
    private Option[] savedOptions;
    private String configurableName;
    private String identifier;
    private OptionSet base;
    private List<Pair<String, Map<String, Object>>> layers;

    public OptionSet(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionSet(String)", 151).addDetail("name", string)).log();
        }
        this.configurableName = string;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setIdentifier(String)", 182).addDetail("identifier", string)).log();
        }
        this.identifier = string;
    }

    public final OptionSet getBase() {
        return this.base;
    }

    public final void setBase(OptionSet optionSet) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setBase(OptionSet)", 211).addDetail("base", optionSet)).log();
        }
        this.base = optionSet;
    }

    public synchronized void add(Supplier<Option> supplier, boolean bl) {
        block4: {
            if (OptionSet.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "add(Supplier<Option>,boolean)", 229).addDetail("optionSupplier", supplier)).addDetail("throwException", bl)).log();
            }
            try {
                this.add(supplier.get());
            }
            catch (Throwable throwable) {
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "add(Supplier<Option>,boolean)", 234).add("ex", throwable)).log();
                }
                if (!bl) break block4;
                throw throwable;
            }
        }
    }

    public synchronized void add(Option option) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "add(Option)", 249).addDetail("option", option)).log();
        }
        this.remove(option.getName());
        this.options.put(option.getName(), option);
        option.addObserver(this);
        this.setChanged();
        if (this.layers != null) {
            this.layers.get(0).getSecond().put(option.getName(), option.getValue());
        }
    }

    public synchronized void addAll(OptionSet optionSet) {
        Option[] optionArray = optionSet.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            this.add(optionArray[i]);
        }
    }

    public synchronized void remove(String string) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "remove(String)", 285).addDetail("name", string)).log();
        }
        if ((option = this.options.remove(string)) != null) {
            option.deleteObserver(this);
            this.setChanged();
            if (this.layers != null) {
                for (Pair<String, Map<String, Object>> pair : this.layers) {
                    pair.getSecond().remove(string);
                }
            }
        }
    }

    public Option getOption(String string) {
        Option option;
        int n;
        Option option2;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOption(String)", 309).addDetail("name", string)).log();
        }
        if ((option2 = this.options.get(string)) == null && (n = string.indexOf(47)) > 0 && n < string.length() - 1 && (option = this.options.get(string.substring(0, n))) != null && option.getValue() instanceof OptionSet) {
            return ((OptionSet)option.getValue()).getOption(string.substring(n + 1));
        }
        if (option2 == null && this.base != null) {
            return this.base.getOption(string);
        }
        return option2;
    }

    public Option[] getOptions() {
        if (OptionSet.logger.level >= 7) {
            logger.lvlBuild(7, "getOptions()", 337).log();
        }
        return this.options.values().toArray(new Option[0]);
    }

    public Option[] getOptions(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOptions(String)", 352).addDetail("layer", string)).log();
        }
        if (string == null) {
            return this.getOptions();
        }
        if (this.layers != null) {
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                Pair<String, Map<String, Object>> pair = this.layers.get(i);
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getOptions(String)", 361).add("pair", pair)).log();
                }
                if (!string.equals(pair.getFirst())) continue;
                ArrayList<Option> arrayList = new ArrayList<Option>();
                for (Map.Entry<String, Object> entry : pair.getSecond().entrySet()) {
                    if (OptionSet.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getOptions(String)", 365).add("entry", entry)).log();
                    }
                    Option option = (Option)this.options.get(entry.getKey()).clone();
                    option.setValue(entry.getValue());
                    arrayList.add(option);
                }
                return arrayList.toArray(new Option[0]);
            }
        }
        return new Option[0];
    }

    public void renameOption(String string, String string2) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "renameOption(String,String)", 386).addDetail("oldName", string)).addDetail("newName", string2)).log();
        }
        if ((option = this.options.remove(string)) != null) {
            option.setName(string2);
            this.options.put(string2, option);
            this.setChanged();
        }
    }

    public Object getValue(String string, Object object) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getValue(String,Object)", 412).addDetail("name", string)).addDetail("def", object)).log();
        }
        if ((option = this.getOption(string)) != null) {
            return option.getValue();
        }
        return object;
    }

    public boolean getBoolean(String string, boolean bl) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getBoolean(String,boolean)", 432).addDetail("name", string)).addDetail("def", bl)).log();
        }
        if ((option = this.getOption(string)) != null && option.getValue() instanceof Boolean) {
            return (Boolean)option.getValue();
        }
        return bl;
    }

    public int getInt(String string, int n) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getInt(String,int)", 452).addDetail("name", string)).addDetail("def", n)).log();
        }
        if ((option = this.getOption(string)) != null && option.getValue() instanceof Integer) {
            return (Integer)option.getValue();
        }
        return n;
    }

    public String getString(String string, String string2) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getString(String,String)", 473).addDetail("name", string)).addDetail("def", string2)).log();
        }
        if ((option = this.getOption(string)) != null && (option.getValue() == null || option.getValue() instanceof String)) {
            return (String)option.getValue();
        }
        return string2;
    }

    public File getFile(String string, File file) {
        Option option;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getFile(String,File)", 495).addDetail("name", string)).addDetail("def", file)).log();
        }
        if ((option = this.getOption(string)) != null && (option.getValue() == null || option.getValue() instanceof File)) {
            return (File)option.getValue();
        }
        return file;
    }

    public synchronized void addLayer(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addLayer(String)", 518).addDetail("name", string)).log();
        }
        this.addLayer(string, null);
    }

    public synchronized void addLayer(String string, Map<String, Object> map) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addLayer(String,Map<String, Object>)", 532).addDetail("name", string)).addDetail("map", map)).log();
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (this.layers == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Option option : this.options.values()) {
                hashMap.put(option.getName(), option.getValue());
            }
            this.layers = new ArrayList<Pair<String, Map<String, Object>>>();
            this.layers.add(new Pair<String, Object>(PERSISTENT_LAYER_NAME, hashMap));
        }
        this.layers.add(new Pair<String, Map<String, Object>>(string, map));
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "addLayer(String,Map<String, Object>)", 547).add("layers", this.layers)).log();
        }
        for (Map.Entry entry : map.entrySet()) {
            Option option;
            option = this.getOption((String)entry.getKey());
            if (OptionSet.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "addLayer(String,Map<String, Object>)", 550).add("option", option)).log();
            }
            if (option == null) continue;
            option.setValue(entry.getValue());
            option.notifyObservers();
        }
    }

    public synchronized Map<String, Object> removeLayer(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeLayer(String)", 571).addDetail("name", string)).log();
        }
        if (PERSISTENT_LAYER_NAME.equals(string)) {
            throw new IllegalArgumentException("Cannot remove default layer");
        }
        Map map = null;
        if (this.layers != null) {
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                Pair<String, Map<String, Object>> pair = this.layers.get(i);
                if (!string.equals(pair.getFirst())) continue;
                map = (Map)pair.getSecond();
                this.layers.remove(i);
                break;
            }
        }
        if (map != null) {
            for (Pair<String, Map<String, Object>> pair : map.keySet()) {
                LinkedList<Object> linkedList;
                Option option = this.getOption((String)((Object)pair));
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "removeLayer(String)", 590).add("option", option)).log();
                }
                if (option == null || (linkedList = this.valueStacks.get(pair)) != null && !linkedList.isEmpty()) continue;
                Pair<String, Object> pair2 = this.getLayerBound((String)((Object)pair));
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "removeLayer(String)", 595).add("pair", pair2)).log();
                }
                if (pair2 == null) continue;
                option.setValue(pair2.getSecond());
                option.notifyObservers();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOption(String string, Object object, String string2) {
        Pair<String, Map<String, Object>> pair;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setOption(String,Object,String)", 620).addDetail("name", string)).addDetail("value", object)).addDetail("layer", string2)).log();
        }
        Map<String, Object> map = null;
        LinkedList<Object> linkedList = null;
        Pair<String, Object> pair2 = this;
        synchronized (pair2) {
            linkedList = this.valueStacks.get(string);
            if (!PERSISTENT_LAYER_NAME.equals(string2)) {
                if (this.layers != null) {
                    for (int i = this.layers.size() - 1; i >= 0; --i) {
                        pair = this.layers.get(i);
                        if (!string2.equals(pair.getFirst())) continue;
                        map = pair.getSecond();
                        break;
                    }
                }
                if (map == null) {
                    this.addLayer(string2);
                    map = this.layers.get(this.layers.size() - 1).getSecond();
                }
            }
        }
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setOption(String,Object,String)", 642).add("layerMap", map)).log();
        }
        if (map != null) {
            map.put(string, object);
        }
        if (linkedList == null || linkedList.isEmpty()) {
            String string3;
            pair2 = this.getLayerBound(string);
            String string4 = string3 = pair2 == null ? null : (String)pair2.getFirst();
            if (OptionSet.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setOption(String,Object,String)", 649).add("bound", string3)).log();
            }
            if (string2.equals(string3) || string3 == null && PERSISTENT_LAYER_NAME.equals(string2)) {
                pair = this.getOption(string);
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setOption(String,Object,String)", 653).add("option", pair)).log();
                }
                if (pair != null) {
                    ((Option)((Object)pair)).setValue(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetOption(String string, String string2) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unsetOption(String,String)", 673).addDetail("name", string)).addDetail("layer", string2)).log();
        }
        if (PERSISTENT_LAYER_NAME.equals(string2)) {
            if (OptionSet.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "unsetOption(String,String)", 676).add("Cannot remove an option from the default layer")).log();
            }
            return;
        }
        Map<String, Object> map = null;
        LinkedList<Object> linkedList = null;
        Pair<String, Object> pair = this;
        synchronized (pair) {
            linkedList = this.valueStacks.get(string);
            if (this.layers != null) {
                for (int i = this.layers.size() - 1; i >= 0; --i) {
                    Pair<String, Map<String, Object>> pair2 = this.layers.get(i);
                    if (!string2.equals(pair2.getFirst())) continue;
                    map = pair2.getSecond();
                    break;
                }
            }
        }
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unsetOption(String,String)", 693).add("layerMap", map)).log();
        }
        if (map == null || !map.containsKey(string)) {
            return;
        }
        pair = this.getLayerBound(string);
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unsetOption(String,String)", 700).add("bound", pair)).log();
        }
        map.remove(string);
        if ((linkedList == null || linkedList.isEmpty()) && pair != null && string2.equals(pair.getFirst())) {
            pair = this.getLayerBound(string);
            if (OptionSet.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "unsetOption(String,String)", 706).add("bound", pair)).log();
            }
            if (pair != null) {
                Option option = this.getOption(string);
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "unsetOption(String,String)", 709).add("option", option)).log();
                }
                if (option != null) {
                    option.setValue(pair.getSecond());
                }
            }
        }
    }

    public synchronized Pair<String, Object> getLayerBound(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getLayerBound(String)", 728).addDetail("name", string)).log();
        }
        if (this.layers == null) {
            return null;
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            Pair<String, Map<String, Object>> pair = this.layers.get(i);
            if (OptionSet.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getLayerBound(String)", 736).add("pair", pair)).log();
            }
            if (!pair.getSecond().containsKey(string)) continue;
            return new Pair<String, Object>(pair.getFirst(), pair.getSecond().get(string));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushOption(String string, Object object) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "pushOption(String,Object)", 751).addDetail("name", string)).addDetail("value", object)).log();
        }
        Option option = this.getOption(string);
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "pushOption(String,Object)", 754).add("option", option)).log();
        }
        if (option == null) {
            return;
        }
        LinkedList<Object> linkedList = null;
        OptionSet optionSet = this;
        synchronized (optionSet) {
            linkedList = this.valueStacks.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.valueStacks.put(string, linkedList);
            }
        }
        linkedList.addFirst(object);
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "pushOption(String,Object)", 768).add("stack", linkedList)).log();
        }
        option.setValue(object);
        option.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popOption(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popOption(String)", 776).addDetail("name", string)).log();
        }
        Option option = this.getOption(string);
        if (OptionSet.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "popOption(String)", 779).add("option", option)).log();
        }
        if (option == null) {
            return;
        }
        LinkedList<Object> linkedList = null;
        Object object = null;
        boolean bl = false;
        Object object2 = this;
        synchronized (object2) {
            linkedList = this.valueStacks.get(string);
            if (linkedList == null) {
                if (OptionSet.logger.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "popOption(String)", 790).add("Stack underflow. Nothing to pop for Option ")).add(string)).log();
                }
                return;
            }
            linkedList.removeFirst();
            if (linkedList.isEmpty()) {
                this.valueStacks.remove(string);
            } else {
                object = linkedList.getFirst();
                bl = true;
            }
        }
        if (!bl) {
            object2 = this.getLayerBound(string);
            if (OptionSet.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "popOption(String)", 804).add("bound", object2)).log();
            }
            if (object2 == null) {
                if (OptionSet.logger.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "popOption(String)", 807).add("Cannot determine bound value for Option ")).add(string)).log();
                }
                return;
            }
            object = ((Pair)object2).getSecond();
        }
        option.setValue(object);
        option.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LinkedList<Object>> saveValueStacks() {
        if (OptionSet.logger.level >= 7) {
            logger.lvlBuild(7, "saveValueStacks()", 826).log();
        }
        OptionSet optionSet = this;
        synchronized (optionSet) {
            Map<String, LinkedList<Object>> map = this.valueStacks;
            this.valueStacks = Collections.synchronizedMap(new HashMap());
            for (String string : map.keySet()) {
                Option option = this.getOption(string);
                if (option == null) continue;
                Pair<String, Object> pair = this.getLayerBound(string);
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "saveValueStacks()", 835).add("bound", pair)).log();
                }
                if (pair == null) {
                    if (OptionSet.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "saveValueStacks()", 838).add("Cannot determine bound value for Option ")).add(string)).log();
                    continue;
                }
                option.setValue(pair.getSecond());
                option.notifyObservers();
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSavedValueStacks(Map<String, LinkedList<Object>> map) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "restoreSavedValueStacks(Map<String, LinkedList<Object>>)", 858).addDetail("savedStacks", map)).log();
        }
        if (map == null) {
            return;
        }
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.valueStacks = map;
            for (Map.Entry<String, LinkedList<Object>> entry : this.valueStacks.entrySet()) {
                Option option;
                if (entry.getValue().isEmpty() || (option = this.getOption(entry.getKey())) == null) continue;
                option.setValue(entry.getValue().getFirst());
                option.notifyObservers();
            }
        }
    }

    @Override
    public final String getConfigurableName() {
        if (OptionSet.logger.level >= 7) {
            logger.lvlBuild(7, "getConfigurableName()", 892).log();
        }
        return this.configurableName;
    }

    @Override
    public final void setConfigurableName(String string) {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableName(String)", 906).addDetail("configurableName", string)).log();
        }
        this.configurableName = string;
    }

    @Override
    public Properties getConfigurableState() {
        Properties properties = new Properties();
        Option[] optionArray = this.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            if (optionArray[i] instanceof ConfigurableOption) {
                properties.put(optionArray[i].getName(), ((ConfigurableOption)((Object)optionArray[i])).getConfigurableValue());
                continue;
            }
            if (OptionSet.logger.level < 5) continue;
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getConfigurableState()", 929).add("Option not stored: (not configurable): ")).add(optionArray[i])).log();
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Option option = this.getOption(string);
            if (option == null) {
                option = new StringOption(string, null);
                this.add(option);
            }
            if (!(option instanceof ConfigurableOption)) continue;
            ((ConfigurableOption)((Object)option)).setConfigurableValue(properties.getProperty(string));
            option.notifyObservers(this);
        }
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        Option[] optionArray = this.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            OptionSet optionSet;
            if (!(optionArray[i] instanceof NestedOption) || (optionSet = (OptionSet)optionArray[i].getValue()) == null) continue;
            if (bl) {
                configuration.registerAs(optionSet, string + "." + optionArray[i].getName());
                continue;
            }
            configuration.unregisterAs(optionSet, string + "." + optionArray[i].getName(), bl2);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        block5: {
            Pair<String, Object> pair;
            String string;
            block6: {
                if (OptionSet.logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Observable,Object)", 1016).addDetail("obs", observable)).addDetail("arg", object)).log();
                }
                if (this.layers == null || !(observable instanceof Option)) break block5;
                string = ((Option)observable).getName();
                pair = this.getLayerBound(string);
                LinkedList<Object> linkedList = this.valueStacks.get(string);
                if (OptionSet.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "update(Observable,Object)", 1023).add("bound", pair)).add("stack", linkedList)).log();
                }
                if (linkedList != null && !linkedList.isEmpty()) break block5;
                if (pair != null) break block6;
                if (OptionSet.logger.level < 5) break block5;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "update(Observable,Object)", 1026).add("No layer for ")).add(observable)).log();
                break block5;
            }
            if (!Misc.equalOrNull(((Option)observable).getValue(), pair.getSecond())) {
                if (OptionSet.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "update(Observable,Object)", 1028).add("Updating layer ")).add(pair.getFirst())).add(" for Option ")).add(observable)).log();
                }
                for (int i = this.layers.size() - 1; i >= 0; --i) {
                    Pair<String, Map<String, Object>> pair2 = this.layers.get(i);
                    if (!pair.getFirst().equals(pair2.getFirst())) continue;
                    pair2.getSecond().put(string, ((Option)observable).getValue());
                    break;
                }
            }
        }
        this.setChanged();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "readObject(ObjectInputStream)", 1059).addDetail("stream", objectInputStream)).log();
        }
        objectInputStream.defaultReadObject();
        this.options = new HashMap<String, Option>();
        for (int i = 0; i < this.savedOptions.length; ++i) {
            this.add(this.savedOptions[i]);
        }
        this.savedOptions = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "writeObject(ObjectOutputStream)", 1081).addDetail("stream", objectOutputStream)).log();
        }
        this.savedOptions = this.getOptions();
        objectOutputStream.defaultWriteObject();
        this.savedOptions = null;
    }

    public Object clone() {
        if (OptionSet.logger.level >= 7) {
            logger.lvlBuild(7, "clone()", 1109).log();
        }
        try {
            OptionSet optionSet = (OptionSet)super.clone();
            optionSet.options = Collections.synchronizedMap(new HashMap());
            Option[] optionArray = this.getOptions();
            for (int i = 0; i < optionArray.length; ++i) {
                OptionSet optionSet2;
                Option option;
                if (OptionSet.logger.level >= 10) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "clone()", 1116).add("cloning ")).add(optionArray[i])).log();
                }
                if ((option = (Option)optionArray[i].clone()) instanceof NestedOption && (optionSet2 = (OptionSet)option.getValue()) != null) {
                    option.setValue(optionSet2.clone());
                }
                optionSet.options.put(optionArray[i].getName(), option);
            }
            return optionSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (OptionSet.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "clone()", 1129).add("ex", cloneNotSupportedException)).log();
            }
            return null;
        }
    }

    public String listOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        Option[] optionArray = this.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            stringBuilder.append(optionArray[i].toString());
            if (i >= optionArray.length - 1) continue;
            stringBuilder.append(TextOption.LINESEP);
        }
        return stringBuilder.toString();
    }

    public Map<String, Object> saveToMap() {
        Option[] optionArray;
        if (OptionSet.logger.level >= 7) {
            logger.lvlBuild(7, "saveToMap()", 1172).log();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Option option : optionArray = this.getOptions()) {
            hashMap.put(option.getName(), option.getValue());
        }
        return hashMap;
    }

    public void restoreFromMap(Map<String, Object> map) {
        Option[] optionArray;
        if (OptionSet.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "restoreFromMap(Map<String, Object>)", 1190).addDetail("values", map)).log();
        }
        for (Option option : optionArray = this.getOptions()) {
            String string = option.getName();
            if (!map.containsKey(string)) continue;
            Object object = map.get(string);
            option.setValue(object);
        }
    }

    public boolean isEmpty() {
        if (OptionSet.logger.level >= 7) {
            logger.lvlBuild(7, "isEmpty()", 1205).log();
        }
        return this.options.isEmpty();
    }
}

