/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.util.ArrayUtil;
import de.qfs.lib.util.Misc;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class StringArrayMapOption
extends Option {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.StringArrayMapOption");
    private Map<String, String[]> valueMap;
    private String[] defaultKeyValue;

    public StringArrayMapOption(String string, String[] stringArray, Map<String, String[]> map) {
        super(string, StringArrayMapOption.createValue(stringArray, map), false);
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringArrayMapOption(String,String[],Map<String, String[]>)", 62).addDetail("name", string)).addDetail("defaultKeyValue", stringArray)).addDetail("valueMap", map)).log();
        }
        this.defaultKeyValue = StringArrayMapOption.createFormattedArray(stringArray);
        this.valueMap = StringArrayMapOption.formatMapValues(map);
    }

    @NonNull
    protected static HashMap<String, String[]> createValue(String[] stringArray, Map<String, String[]> map) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createValue(String[],Map<String, String[]>)", 71).addDetail("defaultKeyValue", stringArray)).addDetail("valueMap", map)).log();
        }
        return Misc.fillMap(new HashMap<String, String[]>(map), null, stringArray);
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 86).addDetail("value", object)).log();
        }
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException();
        }
        this.defaultKeyValue = StringArrayMapOption.createFormattedArray((String[])((Map)object).get(null));
        this.valueMap = StringArrayMapOption.formatMapValues((Map)object).entrySet().stream().filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        super.setValue(object);
    }

    @Override
    public boolean contains(String string) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "contains(String)", 109).addDetail("key", string)).log();
        }
        return this.valueMap.containsKey(string);
    }

    public String[] getValueForKey(String string) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getValueForKey(String)", 123).addDetail("key", string)).log();
        }
        if (this.valueMap.containsKey(string)) {
            return this.valueMap.get(string);
        }
        return this.defaultKeyValue;
    }

    public void setValue(String string, String string2) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(String,String)", 134).addDetail("key", string)).addDetail("value", string2)).log();
        }
        if (string2 == null) {
            return;
        }
        String[] stringArray = StringArrayMapOption.createFormattedArray(Misc.fastSplit(string2, ','));
        if (string == null) {
            this.defaultKeyValue = stringArray;
        } else {
            this.valueMap.put(string, stringArray);
        }
        this.setValue(StringArrayMapOption.createValue(this.defaultKeyValue, this.valueMap));
    }

    public void setValue(String string, String[] stringArray) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(String,String[])", 150).addDetail("key", string)).addDetail("value", stringArray)).log();
        }
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = StringArrayMapOption.createFormattedArray(stringArray);
        if (string == null) {
            this.defaultKeyValue = stringArray2;
        } else {
            this.valueMap.put(string, stringArray2);
        }
        this.setValue(StringArrayMapOption.createValue(this.defaultKeyValue, this.valueMap));
    }

    public void removeKey(String string) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeKey(String)", 166).addDetail("key", string)).log();
        }
        if (string != null && this.valueMap.containsKey(string)) {
            this.valueMap.remove(string);
            this.setValue(StringArrayMapOption.createValue(this.defaultKeyValue, this.valueMap));
        }
    }

    public Set<String> getKeys() {
        if (StringArrayMapOption.logger.level >= 7) {
            logger.lvlBuild(7, "getKeys()", 176).log();
        }
        return this.valueMap.keySet();
    }

    @Override
    @NonNull
    public String getValueAsString() {
        if (StringArrayMapOption.logger.level >= 7) {
            logger.lvlBuild(7, "getValueAsString()", 185).log();
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(Json.value(this.defaultKeyValue));
        jsonArray.add(Json.value(this.valueMap));
        return jsonArray.toString();
    }

    @Override
    public Object getValueFromString(String string) {
        HashMap<String, String[]> hashMap;
        block4: {
            if (string.equals("")) {
                return null;
            }
            hashMap = new HashMap<String, String[]>();
            JsonValue jsonValue = Json.parse(string);
            try {
                JsonArray jsonArray = jsonValue.asArray();
                this.addEntryToOptionValue(hashMap, null, jsonArray.get(0));
                JsonObject jsonObject = jsonArray.get(1).asObject();
                for (JsonObject.Member member : jsonObject) {
                    this.addEntryToOptionValue(hashMap, member.getName(), member.getValue());
                }
            }
            catch (Exception exception) {
                if (StringArrayMapOption.logger.level < 1) break block4;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getValueFromString(String)", 213).add("Could not parse option value")).add("jsonValue", jsonValue)).add("this", this)).add("ex", exception)).log();
            }
        }
        return hashMap;
    }

    private void addEntryToOptionValue(Map<String, String[]> map, String string, JsonValue jsonValue) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addEntryToOptionValue(Map<String, String[]>,String,JsonValue)", 222).addDetail("optionValue", map)).addDetail("optionValueEntryKey", string)).addDetail("optionValueEntryJsonValue", jsonValue)).log();
        }
        JsonArray jsonArray = jsonValue.asArray();
        int n = jsonArray.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        for (JsonValue jsonValue2 : jsonArray) {
            stringArray[n2++] = jsonValue2.asString();
        }
        map.put(string, stringArray);
    }

    @Override
    public boolean equals(Object object) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "equals(Object)", 238).addDetail("o", object)).log();
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof StringArrayMapOption)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StringArrayMapOption stringArrayMapOption = (StringArrayMapOption)object;
        return Objects.equals(this.valueMap, stringArrayMapOption.valueMap) && Arrays.equals(this.defaultKeyValue, stringArrayMapOption.defaultKeyValue);
    }

    @Override
    public int hashCode() {
        if (StringArrayMapOption.logger.level >= 7) {
            logger.lvlBuild(7, "hashCode()", 251).log();
        }
        int n = Objects.hash(super.hashCode(), this.valueMap);
        n = 31 * n + Arrays.hashCode(this.defaultKeyValue);
        return n;
    }

    @Override
    @NonNull
    public String toString() {
        if (StringArrayMapOption.logger.level >= 7) {
            logger.lvlBuild(7, "toString()", 264).log();
        }
        String string = ArrayUtil.arrayToString(this.defaultKeyValue);
        String string2 = this.valueMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + ArrayUtil.arrayToString((String[])entry.getValue())).sorted().collect(Collectors.joining(";"));
        return string + ";" + string2;
    }

    private static Map<String, String[]> formatMapValues(Map<String, String[]> map) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "formatMapValues(Map<String, String[]>)", 276).addDetail("valueMap", map)).log();
        }
        for (String string : map.keySet()) {
            String[] stringArray = map.get(string);
            map.put(string, StringArrayMapOption.createFormattedArray(stringArray));
        }
        return map;
    }

    @NonNull
    private static String[] createFormattedArray(String[] stringArray) {
        if (StringArrayMapOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createFormattedArray(String[])", 288).addDetail("defaultKeyValue", stringArray)).log();
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i].replace("-", "").replace("_", "").toUpperCase();
        }
        return stringArray2;
    }

    @Generated
    public String[] getDefaultKeyValue() {
        if (StringArrayMapOption.logger.level >= 7) {
            logger.lvlBuild(7, "getDefaultKeyValue()", 46).log();
        }
        return this.defaultKeyValue;
    }
}

