/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionDialog;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.group.WizardOptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class WizardDialog
extends OptionDialog {
    protected static final String[] wizardButtons = new String[]{"wizard.back", "wizard.next", "cancel"};
    private boolean useBackspaceForBack;

    public WizardDialog(String string, Frame frame, OptionSet optionSet, String string2) {
        super(string, frame, optionSet, string2);
        if (Option.getResources().getString(this.resName("name"), null) == null) {
            this.setName("WizardDialog-" + string2 + "-" + optionSet.getConfigurableName());
        }
    }

    public WizardDialog(String string, Dialog dialog, OptionSet optionSet, String string2) {
        super(string, dialog, optionSet, string2);
        if (Option.getResources().getString(this.resName("name"), null) == null) {
            this.setName("WizardDialog-" + string2 + "-" + optionSet.getConfigurableName());
        }
    }

    @Override
    public void init(MapResourceBundle mapResourceBundle) {
        super.init(mapResourceBundle);
        if (this.getButton("wizard.next") != null) {
            this.getButton("wizard.next").addActionListener(this.createNextHandler());
        }
        if (this.getButton("wizard.back") != null) {
            ActionListener actionListener = this.createBackHandler();
            this.getButton("wizard.back").addActionListener(actionListener);
            this.useBackspaceForBack = mapResourceBundle.getBoolean(this.resName("usebackspaceforback"), true);
            if (this.useBackspaceForBack) {
                JRootPane jRootPane = this.getRootPane();
                KeyStroke keyStroke = KeyStroke.getKeyStroke(8, 0);
                this.getRootPane();
                jRootPane.registerKeyboardAction(actionListener, keyStroke, 1);
            }
        }
        this.enableButtons();
    }

    @Override
    protected String[] initButtonNames(MapResourceBundle mapResourceBundle) {
        String string = mapResourceBundle.getString(this.resName("buttons"), null);
        if (string == null) {
            return wizardButtons;
        }
        return super.initButtonNames(mapResourceBundle);
    }

    @Override
    public void dispose() {
        int n;
        if (this.getButton("wizard.back") != null) {
            this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
            for (n = this.getButton("wizard.back").getActionListeners().length - 1; n >= 0; --n) {
                this.getButton("wizard.back").removeActionListener(this.getButton("wizard.back").getActionListeners()[n]);
            }
        }
        if (this.getButton("wizard.next") != null) {
            for (n = this.getButton("wizard.next").getActionListeners().length - 1; n >= 0; --n) {
                this.getButton("wizard.next").removeActionListener(this.getButton("wizard.next").getActionListeners()[n]);
            }
        }
        super.dispose();
    }

    protected ActionListener createNextHandler() {
        return new NextHandler();
    }

    protected ActionListener createBackHandler() {
        return new BackHandler();
    }

    protected void enableButtons() {
        if (this.optionGroup instanceof WizardOptionGroup) {
            if (this.getButton("wizard.next") != null) {
                String string = Option.getResources().getString("dialog.button.wizard." + (((WizardOptionGroup)this.optionGroup).isLast() ? "finish" : "next") + ".label", "Next");
                String string2 = Option.getResources().getString("dialog.button.wizard." + (((WizardOptionGroup)this.optionGroup).isLast() ? "finish" : "next") + ".mnemonic", "n");
                this.getButton("wizard.next").setText(string);
                this.getButton("wizard.next").setMnemonic(string2.charAt(0));
                this.getButton("wizard.next").setDefaultCapable(true);
            }
            if (this.getButton("wizard.back") != null) {
                this.getButton("wizard.back").setEnabled(!((WizardOptionGroup)this.optionGroup).isFirst());
            }
        }
    }

    public void doNext() {
        if (this.optionGroup instanceof WizardOptionGroup) {
            boolean bl = ((WizardOptionGroup)this.optionGroup).isLast();
            if (((WizardOptionGroup)this.optionGroup).nextPane()) {
                if (bl) {
                    this.setVisible(false);
                } else {
                    this.enableButtons();
                }
            }
        }
    }

    public void doBack() {
        if (this.optionGroup instanceof WizardOptionGroup) {
            ((WizardOptionGroup)this.optionGroup).previousPane();
            this.enableButtons();
        }
    }

    protected class BackHandler
    implements ActionListener {
        protected BackHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardDialog.this.doBack();
        }
    }

    protected class NextHandler
    implements ActionListener {
        protected NextHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardDialog.this.doNext();
        }
    }
}

